/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides comprehensive details about an Amazon Web Services resource and its associated security findings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceResult implements SdkPojo, Serializable, ToCopyableBuilder<ResourceResult.Builder, ResourceResult> {
    private static final SdkField<String> RESOURCE_GUID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceGuid").getter(getter(ResourceResult::resourceGuid)).setter(setter(Builder::resourceGuid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceGuid").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceId").getter(getter(ResourceResult::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(ResourceResult::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Region")
            .getter(getter(ResourceResult::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()).build();

    private static final SdkField<String> RESOURCE_CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceCategory").getter(getter(ResourceResult::resourceCategoryAsString))
            .setter(setter(Builder::resourceCategory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceCategory").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(ResourceResult::resourceType)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceName").getter(getter(ResourceResult::resourceName)).setter(setter(Builder::resourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceName").build()).build();

    private static final SdkField<String> RESOURCE_CREATION_TIME_DT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceCreationTimeDt").getter(getter(ResourceResult::resourceCreationTimeDt))
            .setter(setter(Builder::resourceCreationTimeDt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceCreationTimeDt").build())
            .build();

    private static final SdkField<String> RESOURCE_DETAIL_CAPTURE_TIME_DT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ResourceDetailCaptureTimeDt")
            .getter(getter(ResourceResult::resourceDetailCaptureTimeDt))
            .setter(setter(Builder::resourceDetailCaptureTimeDt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceDetailCaptureTimeDt")
                    .build()).build();

    private static final SdkField<List<ResourceFindingsSummary>> FINDINGS_SUMMARY_FIELD = SdkField
            .<List<ResourceFindingsSummary>> builder(MarshallingType.LIST)
            .memberName("FindingsSummary")
            .getter(getter(ResourceResult::findingsSummary))
            .setter(setter(Builder::findingsSummary))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FindingsSummary").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceFindingsSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceFindingsSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ResourceTag>> RESOURCE_TAGS_FIELD = SdkField
            .<List<ResourceTag>> builder(MarshallingType.LIST)
            .memberName("ResourceTags")
            .getter(getter(ResourceResult::resourceTags))
            .setter(setter(Builder::resourceTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceTag> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceTag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Document> RESOURCE_CONFIG_FIELD = SdkField.<Document> builder(MarshallingType.DOCUMENT)
            .memberName("ResourceConfig").getter(getter(ResourceResult::resourceConfig)).setter(setter(Builder::resourceConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_GUID_FIELD,
            RESOURCE_ID_FIELD, ACCOUNT_ID_FIELD, REGION_FIELD, RESOURCE_CATEGORY_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_NAME_FIELD,
            RESOURCE_CREATION_TIME_DT_FIELD, RESOURCE_DETAIL_CAPTURE_TIME_DT_FIELD, FINDINGS_SUMMARY_FIELD, RESOURCE_TAGS_FIELD,
            RESOURCE_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String resourceGuid;

    private final String resourceId;

    private final String accountId;

    private final String region;

    private final String resourceCategory;

    private final String resourceType;

    private final String resourceName;

    private final String resourceCreationTimeDt;

    private final String resourceDetailCaptureTimeDt;

    private final List<ResourceFindingsSummary> findingsSummary;

    private final List<ResourceTag> resourceTags;

    private final Document resourceConfig;

    private ResourceResult(BuilderImpl builder) {
        this.resourceGuid = builder.resourceGuid;
        this.resourceId = builder.resourceId;
        this.accountId = builder.accountId;
        this.region = builder.region;
        this.resourceCategory = builder.resourceCategory;
        this.resourceType = builder.resourceType;
        this.resourceName = builder.resourceName;
        this.resourceCreationTimeDt = builder.resourceCreationTimeDt;
        this.resourceDetailCaptureTimeDt = builder.resourceDetailCaptureTimeDt;
        this.findingsSummary = builder.findingsSummary;
        this.resourceTags = builder.resourceTags;
        this.resourceConfig = builder.resourceConfig;
    }

    /**
     * <p>
     * The global identifier used to identify a resource.
     * </p>
     * 
     * @return The global identifier used to identify a resource.
     */
    public final String resourceGuid() {
        return resourceGuid;
    }

    /**
     * <p>
     * The unique identifier for a resource.
     * </p>
     * 
     * @return The unique identifier for a resource.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The Amazon Web Services account that owns the resource.
     * </p>
     * 
     * @return The Amazon Web Services account that owns the resource.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The Amazon Web Services Region where the resource is located.
     * </p>
     * 
     * @return The Amazon Web Services Region where the resource is located.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * The grouping where the resource belongs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceCategory}
     * will return {@link ResourceCategory#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceCategoryAsString}.
     * </p>
     * 
     * @return The grouping where the resource belongs.
     * @see ResourceCategory
     */
    public final ResourceCategory resourceCategory() {
        return ResourceCategory.fromValue(resourceCategory);
    }

    /**
     * <p>
     * The grouping where the resource belongs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceCategory}
     * will return {@link ResourceCategory#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceCategoryAsString}.
     * </p>
     * 
     * @return The grouping where the resource belongs.
     * @see ResourceCategory
     */
    public final String resourceCategoryAsString() {
        return resourceCategory;
    }

    /**
     * <p>
     * The type of resource.
     * </p>
     * 
     * @return The type of resource.
     */
    public final String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The name of the resource.
     * </p>
     * 
     * @return The name of the resource.
     */
    public final String resourceName() {
        return resourceName;
    }

    /**
     * <p>
     * The time when the resource was created.
     * </p>
     * 
     * @return The time when the resource was created.
     */
    public final String resourceCreationTimeDt() {
        return resourceCreationTimeDt;
    }

    /**
     * <p>
     * The timestamp when information about the resource was captured.
     * </p>
     * 
     * @return The timestamp when information about the resource was captured.
     */
    public final String resourceDetailCaptureTimeDt() {
        return resourceDetailCaptureTimeDt;
    }

    /**
     * For responses, this returns true if the service returned a value for the FindingsSummary property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFindingsSummary() {
        return findingsSummary != null && !(findingsSummary instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An aggregated view of security findings associated with a resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFindingsSummary} method.
     * </p>
     * 
     * @return An aggregated view of security findings associated with a resource.
     */
    public final List<ResourceFindingsSummary> findingsSummary() {
        return findingsSummary;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceTags property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceTags() {
        return resourceTags != null && !(resourceTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The key-value pairs associated with a resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceTags} method.
     * </p>
     * 
     * @return The key-value pairs associated with a resource.
     */
    public final List<ResourceTag> resourceTags() {
        return resourceTags;
    }

    /**
     * <p>
     * The configuration details of a resource.
     * </p>
     * 
     * @return The configuration details of a resource.
     */
    public final Document resourceConfig() {
        return resourceConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceGuid());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(resourceCategoryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceCreationTimeDt());
        hashCode = 31 * hashCode + Objects.hashCode(resourceDetailCaptureTimeDt());
        hashCode = 31 * hashCode + Objects.hashCode(hasFindingsSummary() ? findingsSummary() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceTags() ? resourceTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(resourceConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceResult)) {
            return false;
        }
        ResourceResult other = (ResourceResult) obj;
        return Objects.equals(resourceGuid(), other.resourceGuid()) && Objects.equals(resourceId(), other.resourceId())
                && Objects.equals(accountId(), other.accountId()) && Objects.equals(region(), other.region())
                && Objects.equals(resourceCategoryAsString(), other.resourceCategoryAsString())
                && Objects.equals(resourceType(), other.resourceType()) && Objects.equals(resourceName(), other.resourceName())
                && Objects.equals(resourceCreationTimeDt(), other.resourceCreationTimeDt())
                && Objects.equals(resourceDetailCaptureTimeDt(), other.resourceDetailCaptureTimeDt())
                && hasFindingsSummary() == other.hasFindingsSummary()
                && Objects.equals(findingsSummary(), other.findingsSummary()) && hasResourceTags() == other.hasResourceTags()
                && Objects.equals(resourceTags(), other.resourceTags())
                && Objects.equals(resourceConfig(), other.resourceConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceResult").add("ResourceGuid", resourceGuid()).add("ResourceId", resourceId())
                .add("AccountId", accountId()).add("Region", region()).add("ResourceCategory", resourceCategoryAsString())
                .add("ResourceType", resourceType()).add("ResourceName", resourceName())
                .add("ResourceCreationTimeDt", resourceCreationTimeDt())
                .add("ResourceDetailCaptureTimeDt", resourceDetailCaptureTimeDt())
                .add("FindingsSummary", hasFindingsSummary() ? findingsSummary() : null)
                .add("ResourceTags", hasResourceTags() ? resourceTags() : null).add("ResourceConfig", resourceConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceGuid":
            return Optional.ofNullable(clazz.cast(resourceGuid()));
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        case "ResourceCategory":
            return Optional.ofNullable(clazz.cast(resourceCategoryAsString()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "ResourceName":
            return Optional.ofNullable(clazz.cast(resourceName()));
        case "ResourceCreationTimeDt":
            return Optional.ofNullable(clazz.cast(resourceCreationTimeDt()));
        case "ResourceDetailCaptureTimeDt":
            return Optional.ofNullable(clazz.cast(resourceDetailCaptureTimeDt()));
        case "FindingsSummary":
            return Optional.ofNullable(clazz.cast(findingsSummary()));
        case "ResourceTags":
            return Optional.ofNullable(clazz.cast(resourceTags()));
        case "ResourceConfig":
            return Optional.ofNullable(clazz.cast(resourceConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResourceGuid", RESOURCE_GUID_FIELD);
        map.put("ResourceId", RESOURCE_ID_FIELD);
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("Region", REGION_FIELD);
        map.put("ResourceCategory", RESOURCE_CATEGORY_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("ResourceName", RESOURCE_NAME_FIELD);
        map.put("ResourceCreationTimeDt", RESOURCE_CREATION_TIME_DT_FIELD);
        map.put("ResourceDetailCaptureTimeDt", RESOURCE_DETAIL_CAPTURE_TIME_DT_FIELD);
        map.put("FindingsSummary", FINDINGS_SUMMARY_FIELD);
        map.put("ResourceTags", RESOURCE_TAGS_FIELD);
        map.put("ResourceConfig", RESOURCE_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceResult, T> g) {
        return obj -> g.apply((ResourceResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceResult> {
        /**
         * <p>
         * The global identifier used to identify a resource.
         * </p>
         * 
         * @param resourceGuid
         *        The global identifier used to identify a resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceGuid(String resourceGuid);

        /**
         * <p>
         * The unique identifier for a resource.
         * </p>
         * 
         * @param resourceId
         *        The unique identifier for a resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The Amazon Web Services account that owns the resource.
         * </p>
         * 
         * @param accountId
         *        The Amazon Web Services account that owns the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The Amazon Web Services Region where the resource is located.
         * </p>
         * 
         * @param region
         *        The Amazon Web Services Region where the resource is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The grouping where the resource belongs.
         * </p>
         * 
         * @param resourceCategory
         *        The grouping where the resource belongs.
         * @see ResourceCategory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceCategory
         */
        Builder resourceCategory(String resourceCategory);

        /**
         * <p>
         * The grouping where the resource belongs.
         * </p>
         * 
         * @param resourceCategory
         *        The grouping where the resource belongs.
         * @see ResourceCategory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceCategory
         */
        Builder resourceCategory(ResourceCategory resourceCategory);

        /**
         * <p>
         * The type of resource.
         * </p>
         * 
         * @param resourceType
         *        The type of resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The name of the resource.
         * </p>
         * 
         * @param resourceName
         *        The name of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceName(String resourceName);

        /**
         * <p>
         * The time when the resource was created.
         * </p>
         * 
         * @param resourceCreationTimeDt
         *        The time when the resource was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceCreationTimeDt(String resourceCreationTimeDt);

        /**
         * <p>
         * The timestamp when information about the resource was captured.
         * </p>
         * 
         * @param resourceDetailCaptureTimeDt
         *        The timestamp when information about the resource was captured.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceDetailCaptureTimeDt(String resourceDetailCaptureTimeDt);

        /**
         * <p>
         * An aggregated view of security findings associated with a resource.
         * </p>
         * 
         * @param findingsSummary
         *        An aggregated view of security findings associated with a resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingsSummary(Collection<ResourceFindingsSummary> findingsSummary);

        /**
         * <p>
         * An aggregated view of security findings associated with a resource.
         * </p>
         * 
         * @param findingsSummary
         *        An aggregated view of security findings associated with a resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingsSummary(ResourceFindingsSummary... findingsSummary);

        /**
         * <p>
         * An aggregated view of security findings associated with a resource.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.ResourceFindingsSummary.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.ResourceFindingsSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.ResourceFindingsSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #findingsSummary(List<ResourceFindingsSummary>)}.
         * 
         * @param findingsSummary
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.ResourceFindingsSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #findingsSummary(java.util.Collection<ResourceFindingsSummary>)
         */
        Builder findingsSummary(Consumer<ResourceFindingsSummary.Builder>... findingsSummary);

        /**
         * <p>
         * The key-value pairs associated with a resource.
         * </p>
         * 
         * @param resourceTags
         *        The key-value pairs associated with a resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTags(Collection<ResourceTag> resourceTags);

        /**
         * <p>
         * The key-value pairs associated with a resource.
         * </p>
         * 
         * @param resourceTags
         *        The key-value pairs associated with a resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTags(ResourceTag... resourceTags);

        /**
         * <p>
         * The key-value pairs associated with a resource.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.ResourceTag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.securityhub.model.ResourceTag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.ResourceTag.Builder#build()} is called immediately
         * and its result is passed to {@link #resourceTags(List<ResourceTag>)}.
         * 
         * @param resourceTags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.ResourceTag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceTags(java.util.Collection<ResourceTag>)
         */
        Builder resourceTags(Consumer<ResourceTag.Builder>... resourceTags);

        /**
         * <p>
         * The configuration details of a resource.
         * </p>
         * 
         * @param resourceConfig
         *        The configuration details of a resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceConfig(Document resourceConfig);
    }

    static final class BuilderImpl implements Builder {
        private String resourceGuid;

        private String resourceId;

        private String accountId;

        private String region;

        private String resourceCategory;

        private String resourceType;

        private String resourceName;

        private String resourceCreationTimeDt;

        private String resourceDetailCaptureTimeDt;

        private List<ResourceFindingsSummary> findingsSummary = DefaultSdkAutoConstructList.getInstance();

        private List<ResourceTag> resourceTags = DefaultSdkAutoConstructList.getInstance();

        private Document resourceConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceResult model) {
            resourceGuid(model.resourceGuid);
            resourceId(model.resourceId);
            accountId(model.accountId);
            region(model.region);
            resourceCategory(model.resourceCategory);
            resourceType(model.resourceType);
            resourceName(model.resourceName);
            resourceCreationTimeDt(model.resourceCreationTimeDt);
            resourceDetailCaptureTimeDt(model.resourceDetailCaptureTimeDt);
            findingsSummary(model.findingsSummary);
            resourceTags(model.resourceTags);
            resourceConfig(model.resourceConfig);
        }

        public final String getResourceGuid() {
            return resourceGuid;
        }

        public final void setResourceGuid(String resourceGuid) {
            this.resourceGuid = resourceGuid;
        }

        @Override
        public final Builder resourceGuid(String resourceGuid) {
            this.resourceGuid = resourceGuid;
            return this;
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getResourceCategory() {
            return resourceCategory;
        }

        public final void setResourceCategory(String resourceCategory) {
            this.resourceCategory = resourceCategory;
        }

        @Override
        public final Builder resourceCategory(String resourceCategory) {
            this.resourceCategory = resourceCategory;
            return this;
        }

        @Override
        public final Builder resourceCategory(ResourceCategory resourceCategory) {
            this.resourceCategory(resourceCategory == null ? null : resourceCategory.toString());
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getResourceName() {
            return resourceName;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final String getResourceCreationTimeDt() {
            return resourceCreationTimeDt;
        }

        public final void setResourceCreationTimeDt(String resourceCreationTimeDt) {
            this.resourceCreationTimeDt = resourceCreationTimeDt;
        }

        @Override
        public final Builder resourceCreationTimeDt(String resourceCreationTimeDt) {
            this.resourceCreationTimeDt = resourceCreationTimeDt;
            return this;
        }

        public final String getResourceDetailCaptureTimeDt() {
            return resourceDetailCaptureTimeDt;
        }

        public final void setResourceDetailCaptureTimeDt(String resourceDetailCaptureTimeDt) {
            this.resourceDetailCaptureTimeDt = resourceDetailCaptureTimeDt;
        }

        @Override
        public final Builder resourceDetailCaptureTimeDt(String resourceDetailCaptureTimeDt) {
            this.resourceDetailCaptureTimeDt = resourceDetailCaptureTimeDt;
            return this;
        }

        public final List<ResourceFindingsSummary.Builder> getFindingsSummary() {
            List<ResourceFindingsSummary.Builder> result = ResourceFindingsSummaryListCopier.copyToBuilder(this.findingsSummary);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFindingsSummary(Collection<ResourceFindingsSummary.BuilderImpl> findingsSummary) {
            this.findingsSummary = ResourceFindingsSummaryListCopier.copyFromBuilder(findingsSummary);
        }

        @Override
        public final Builder findingsSummary(Collection<ResourceFindingsSummary> findingsSummary) {
            this.findingsSummary = ResourceFindingsSummaryListCopier.copy(findingsSummary);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingsSummary(ResourceFindingsSummary... findingsSummary) {
            findingsSummary(Arrays.asList(findingsSummary));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingsSummary(Consumer<ResourceFindingsSummary.Builder>... findingsSummary) {
            findingsSummary(Stream.of(findingsSummary).map(c -> ResourceFindingsSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ResourceTag.Builder> getResourceTags() {
            List<ResourceTag.Builder> result = ResourceTagListCopier.copyToBuilder(this.resourceTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceTags(Collection<ResourceTag.BuilderImpl> resourceTags) {
            this.resourceTags = ResourceTagListCopier.copyFromBuilder(resourceTags);
        }

        @Override
        public final Builder resourceTags(Collection<ResourceTag> resourceTags) {
            this.resourceTags = ResourceTagListCopier.copy(resourceTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(ResourceTag... resourceTags) {
            resourceTags(Arrays.asList(resourceTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(Consumer<ResourceTag.Builder>... resourceTags) {
            resourceTags(Stream.of(resourceTags).map(c -> ResourceTag.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Document getResourceConfig() {
            return resourceConfig;
        }

        public final void setResourceConfig(Document resourceConfig) {
            this.resourceConfig = resourceConfig;
        }

        @Override
        public final Builder resourceConfig(Document resourceConfig) {
            this.resourceConfig = resourceConfig;
            return this;
        }

        @Override
        public ResourceResult build() {
            return new ResourceResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
