/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the configuration for organizing and categorizing Amazon Web Services resources based on associated security
 * findings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceGroupByRule implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceGroupByRule.Builder, ResourceGroupByRule> {
    private static final SdkField<String> GROUP_BY_FIELD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupByField").getter(getter(ResourceGroupByRule::groupByFieldAsString))
            .setter(setter(Builder::groupByField))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupByField").build()).build();

    private static final SdkField<ResourcesFilters> FILTERS_FIELD = SdkField.<ResourcesFilters> builder(MarshallingType.SDK_POJO)
            .memberName("Filters").getter(getter(ResourceGroupByRule::filters)).setter(setter(Builder::filters))
            .constructor(ResourcesFilters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_BY_FIELD_FIELD,
            FILTERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String groupByField;

    private final ResourcesFilters filters;

    private ResourceGroupByRule(BuilderImpl builder) {
        this.groupByField = builder.groupByField;
        this.filters = builder.filters;
    }

    /**
     * <p>
     * Specifies the attribute that resources should be grouped by.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #groupByField} will
     * return {@link ResourceGroupByField#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #groupByFieldAsString}.
     * </p>
     * 
     * @return Specifies the attribute that resources should be grouped by.
     * @see ResourceGroupByField
     */
    public final ResourceGroupByField groupByField() {
        return ResourceGroupByField.fromValue(groupByField);
    }

    /**
     * <p>
     * Specifies the attribute that resources should be grouped by.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #groupByField} will
     * return {@link ResourceGroupByField#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #groupByFieldAsString}.
     * </p>
     * 
     * @return Specifies the attribute that resources should be grouped by.
     * @see ResourceGroupByField
     */
    public final String groupByFieldAsString() {
        return groupByField;
    }

    /**
     * <p>
     * The criteria used to select resources and associated security findings.
     * </p>
     * 
     * @return The criteria used to select resources and associated security findings.
     */
    public final ResourcesFilters filters() {
        return filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groupByFieldAsString());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceGroupByRule)) {
            return false;
        }
        ResourceGroupByRule other = (ResourceGroupByRule) obj;
        return Objects.equals(groupByFieldAsString(), other.groupByFieldAsString()) && Objects.equals(filters(), other.filters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceGroupByRule").add("GroupByField", groupByFieldAsString()).add("Filters", filters())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupByField":
            return Optional.ofNullable(clazz.cast(groupByFieldAsString()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GroupByField", GROUP_BY_FIELD_FIELD);
        map.put("Filters", FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceGroupByRule, T> g) {
        return obj -> g.apply((ResourceGroupByRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceGroupByRule> {
        /**
         * <p>
         * Specifies the attribute that resources should be grouped by.
         * </p>
         * 
         * @param groupByField
         *        Specifies the attribute that resources should be grouped by.
         * @see ResourceGroupByField
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceGroupByField
         */
        Builder groupByField(String groupByField);

        /**
         * <p>
         * Specifies the attribute that resources should be grouped by.
         * </p>
         * 
         * @param groupByField
         *        Specifies the attribute that resources should be grouped by.
         * @see ResourceGroupByField
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceGroupByField
         */
        Builder groupByField(ResourceGroupByField groupByField);

        /**
         * <p>
         * The criteria used to select resources and associated security findings.
         * </p>
         * 
         * @param filters
         *        The criteria used to select resources and associated security findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(ResourcesFilters filters);

        /**
         * <p>
         * The criteria used to select resources and associated security findings.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourcesFilters.Builder} avoiding the
         * need to create one manually via {@link ResourcesFilters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourcesFilters.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(ResourcesFilters)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link ResourcesFilters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(ResourcesFilters)
         */
        default Builder filters(Consumer<ResourcesFilters.Builder> filters) {
            return filters(ResourcesFilters.builder().applyMutation(filters).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String groupByField;

        private ResourcesFilters filters;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceGroupByRule model) {
            groupByField(model.groupByField);
            filters(model.filters);
        }

        public final String getGroupByField() {
            return groupByField;
        }

        public final void setGroupByField(String groupByField) {
            this.groupByField = groupByField;
        }

        @Override
        public final Builder groupByField(String groupByField) {
            this.groupByField = groupByField;
            return this;
        }

        @Override
        public final Builder groupByField(ResourceGroupByField groupByField) {
            this.groupByField(groupByField == null ? null : groupByField.toString());
            return this;
        }

        public final ResourcesFilters.Builder getFilters() {
            return filters != null ? filters.toBuilder() : null;
        }

        public final void setFilters(ResourcesFilters.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        @Override
        public final Builder filters(ResourcesFilters filters) {
            this.filters = filters;
            return this;
        }

        @Override
        public ResourceGroupByRule build() {
            return new ResourceGroupByRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
