/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A resource related to a finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Resource implements SdkPojo, Serializable, ToCopyableBuilder<Resource.Builder, Resource> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(Resource::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(Resource::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> PARTITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Partition").getter(getter(Resource::partitionAsString)).setter(setter(Builder::partition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Partition").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Region")
            .getter(getter(Resource::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()).build();

    private static final SdkField<String> RESOURCE_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceRole").getter(getter(Resource::resourceRole)).setter(setter(Builder::resourceRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceRole").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(Resource::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<DataClassificationDetails> DATA_CLASSIFICATION_FIELD = SdkField
            .<DataClassificationDetails> builder(MarshallingType.SDK_POJO).memberName("DataClassification")
            .getter(getter(Resource::dataClassification)).setter(setter(Builder::dataClassification))
            .constructor(DataClassificationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataClassification").build())
            .build();

    private static final SdkField<ResourceDetails> DETAILS_FIELD = SdkField.<ResourceDetails> builder(MarshallingType.SDK_POJO)
            .memberName("Details").getter(getter(Resource::details)).setter(setter(Builder::details))
            .constructor(ResourceDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Details").build()).build();

    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationName").getter(getter(Resource::applicationName)).setter(setter(Builder::applicationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()).build();

    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationArn").getter(getter(Resource::applicationArn)).setter(setter(Builder::applicationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, ID_FIELD,
            PARTITION_FIELD, REGION_FIELD, RESOURCE_ROLE_FIELD, TAGS_FIELD, DATA_CLASSIFICATION_FIELD, DETAILS_FIELD,
            APPLICATION_NAME_FIELD, APPLICATION_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String id;

    private final String partition;

    private final String region;

    private final String resourceRole;

    private final Map<String, String> tags;

    private final DataClassificationDetails dataClassification;

    private final ResourceDetails details;

    private final String applicationName;

    private final String applicationArn;

    private Resource(BuilderImpl builder) {
        this.type = builder.type;
        this.id = builder.id;
        this.partition = builder.partition;
        this.region = builder.region;
        this.resourceRole = builder.resourceRole;
        this.tags = builder.tags;
        this.dataClassification = builder.dataClassification;
        this.details = builder.details;
        this.applicationName = builder.applicationName;
        this.applicationArn = builder.applicationArn;
    }

    /**
     * <p>
     * The type of the resource that details are provided for. If possible, set <code>Type</code> to one of the
     * supported resource types. For example, if the resource is an EC2 instance, then set <code>Type</code> to
     * <code>AwsEc2Instance</code>.
     * </p>
     * <p>
     * If the resource does not match any of the provided types, then set <code>Type</code> to <code>Other</code>.
     * </p>
     * <p>
     * Length Constraints: Minimum length of 1. Maximum length of 256.
     * </p>
     * 
     * @return The type of the resource that details are provided for. If possible, set <code>Type</code> to one of the
     *         supported resource types. For example, if the resource is an EC2 instance, then set <code>Type</code> to
     *         <code>AwsEc2Instance</code>.</p>
     *         <p>
     *         If the resource does not match any of the provided types, then set <code>Type</code> to
     *         <code>Other</code>.
     *         </p>
     *         <p>
     *         Length Constraints: Minimum length of 1. Maximum length of 256.
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * The canonical identifier for the given resource type.
     * </p>
     * 
     * @return The canonical identifier for the given resource type.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The canonical Amazon Web Services partition name that the Region is assigned to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #partition} will
     * return {@link Partition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #partitionAsString}.
     * </p>
     * 
     * @return The canonical Amazon Web Services partition name that the Region is assigned to.
     * @see Partition
     */
    public final Partition partition() {
        return Partition.fromValue(partition);
    }

    /**
     * <p>
     * The canonical Amazon Web Services partition name that the Region is assigned to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #partition} will
     * return {@link Partition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #partitionAsString}.
     * </p>
     * 
     * @return The canonical Amazon Web Services partition name that the Region is assigned to.
     * @see Partition
     */
    public final String partitionAsString() {
        return partition;
    }

    /**
     * <p>
     * The canonical Amazon Web Services external Region name where this resource is located.
     * </p>
     * <p>
     * Length Constraints: Minimum length of 1. Maximum length of 16.
     * </p>
     * 
     * @return The canonical Amazon Web Services external Region name where this resource is located.</p>
     *         <p>
     *         Length Constraints: Minimum length of 1. Maximum length of 16.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * Identifies the role of the resource in the finding. A resource is either the actor or target of the finding
     * activity,
     * </p>
     * 
     * @return Identifies the role of the resource in the finding. A resource is either the actor or target of the
     *         finding activity,
     */
    public final String resourceRole() {
        return resourceRole;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of Amazon Web Services tags associated with a resource at the time the finding was processed. Tags must
     * follow <a href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-conventions">Amazon Web
     * Services tag naming limits and requirements</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of Amazon Web Services tags associated with a resource at the time the finding was processed. Tags
     *         must follow <a
     *         href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-conventions">Amazon Web
     *         Services tag naming limits and requirements</a>.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * Contains information about sensitive data that was detected on the resource.
     * </p>
     * 
     * @return Contains information about sensitive data that was detected on the resource.
     */
    public final DataClassificationDetails dataClassification() {
        return dataClassification;
    }

    /**
     * <p>
     * Additional details about the resource related to a finding.
     * </p>
     * 
     * @return Additional details about the resource related to a finding.
     */
    public final ResourceDetails details() {
        return details;
    }

    /**
     * <p>
     * The name of the application that is related to a finding.
     * </p>
     * 
     * @return The name of the application that is related to a finding.
     */
    public final String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the application that is related to a finding.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the application that is related to a finding.
     */
    public final String applicationArn() {
        return applicationArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(partitionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(resourceRole());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dataClassification());
        hashCode = 31 * hashCode + Objects.hashCode(details());
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(applicationArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Resource)) {
            return false;
        }
        Resource other = (Resource) obj;
        return Objects.equals(type(), other.type()) && Objects.equals(id(), other.id())
                && Objects.equals(partitionAsString(), other.partitionAsString()) && Objects.equals(region(), other.region())
                && Objects.equals(resourceRole(), other.resourceRole()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(dataClassification(), other.dataClassification())
                && Objects.equals(details(), other.details()) && Objects.equals(applicationName(), other.applicationName())
                && Objects.equals(applicationArn(), other.applicationArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Resource").add("Type", type()).add("Id", id()).add("Partition", partitionAsString())
                .add("Region", region()).add("ResourceRole", resourceRole()).add("Tags", hasTags() ? tags() : null)
                .add("DataClassification", dataClassification()).add("Details", details())
                .add("ApplicationName", applicationName()).add("ApplicationArn", applicationArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Partition":
            return Optional.ofNullable(clazz.cast(partitionAsString()));
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        case "ResourceRole":
            return Optional.ofNullable(clazz.cast(resourceRole()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "DataClassification":
            return Optional.ofNullable(clazz.cast(dataClassification()));
        case "Details":
            return Optional.ofNullable(clazz.cast(details()));
        case "ApplicationName":
            return Optional.ofNullable(clazz.cast(applicationName()));
        case "ApplicationArn":
            return Optional.ofNullable(clazz.cast(applicationArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Type", TYPE_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Partition", PARTITION_FIELD);
        map.put("Region", REGION_FIELD);
        map.put("ResourceRole", RESOURCE_ROLE_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("DataClassification", DATA_CLASSIFICATION_FIELD);
        map.put("Details", DETAILS_FIELD);
        map.put("ApplicationName", APPLICATION_NAME_FIELD);
        map.put("ApplicationArn", APPLICATION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Resource, T> g) {
        return obj -> g.apply((Resource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Resource> {
        /**
         * <p>
         * The type of the resource that details are provided for. If possible, set <code>Type</code> to one of the
         * supported resource types. For example, if the resource is an EC2 instance, then set <code>Type</code> to
         * <code>AwsEc2Instance</code>.
         * </p>
         * <p>
         * If the resource does not match any of the provided types, then set <code>Type</code> to <code>Other</code>.
         * </p>
         * <p>
         * Length Constraints: Minimum length of 1. Maximum length of 256.
         * </p>
         * 
         * @param type
         *        The type of the resource that details are provided for. If possible, set <code>Type</code> to one of
         *        the supported resource types. For example, if the resource is an EC2 instance, then set
         *        <code>Type</code> to <code>AwsEc2Instance</code>.</p>
         *        <p>
         *        If the resource does not match any of the provided types, then set <code>Type</code> to
         *        <code>Other</code>.
         *        </p>
         *        <p>
         *        Length Constraints: Minimum length of 1. Maximum length of 256.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The canonical identifier for the given resource type.
         * </p>
         * 
         * @param id
         *        The canonical identifier for the given resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The canonical Amazon Web Services partition name that the Region is assigned to.
         * </p>
         * 
         * @param partition
         *        The canonical Amazon Web Services partition name that the Region is assigned to.
         * @see Partition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Partition
         */
        Builder partition(String partition);

        /**
         * <p>
         * The canonical Amazon Web Services partition name that the Region is assigned to.
         * </p>
         * 
         * @param partition
         *        The canonical Amazon Web Services partition name that the Region is assigned to.
         * @see Partition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Partition
         */
        Builder partition(Partition partition);

        /**
         * <p>
         * The canonical Amazon Web Services external Region name where this resource is located.
         * </p>
         * <p>
         * Length Constraints: Minimum length of 1. Maximum length of 16.
         * </p>
         * 
         * @param region
         *        The canonical Amazon Web Services external Region name where this resource is located.</p>
         *        <p>
         *        Length Constraints: Minimum length of 1. Maximum length of 16.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * Identifies the role of the resource in the finding. A resource is either the actor or target of the finding
         * activity,
         * </p>
         * 
         * @param resourceRole
         *        Identifies the role of the resource in the finding. A resource is either the actor or target of the
         *        finding activity,
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceRole(String resourceRole);

        /**
         * <p>
         * A list of Amazon Web Services tags associated with a resource at the time the finding was processed. Tags
         * must follow <a
         * href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-conventions">Amazon Web
         * Services tag naming limits and requirements</a>.
         * </p>
         * 
         * @param tags
         *        A list of Amazon Web Services tags associated with a resource at the time the finding was processed.
         *        Tags must follow <a
         *        href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-conventions">Amazon Web
         *        Services tag naming limits and requirements</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * Contains information about sensitive data that was detected on the resource.
         * </p>
         * 
         * @param dataClassification
         *        Contains information about sensitive data that was detected on the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataClassification(DataClassificationDetails dataClassification);

        /**
         * <p>
         * Contains information about sensitive data that was detected on the resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataClassificationDetails.Builder}
         * avoiding the need to create one manually via {@link DataClassificationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataClassificationDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #dataClassification(DataClassificationDetails)}.
         * 
         * @param dataClassification
         *        a consumer that will call methods on {@link DataClassificationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataClassification(DataClassificationDetails)
         */
        default Builder dataClassification(Consumer<DataClassificationDetails.Builder> dataClassification) {
            return dataClassification(DataClassificationDetails.builder().applyMutation(dataClassification).build());
        }

        /**
         * <p>
         * Additional details about the resource related to a finding.
         * </p>
         * 
         * @param details
         *        Additional details about the resource related to a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(ResourceDetails details);

        /**
         * <p>
         * Additional details about the resource related to a finding.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceDetails.Builder} avoiding the
         * need to create one manually via {@link ResourceDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #details(ResourceDetails)}.
         * 
         * @param details
         *        a consumer that will call methods on {@link ResourceDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #details(ResourceDetails)
         */
        default Builder details(Consumer<ResourceDetails.Builder> details) {
            return details(ResourceDetails.builder().applyMutation(details).build());
        }

        /**
         * <p>
         * The name of the application that is related to a finding.
         * </p>
         * 
         * @param applicationName
         *        The name of the application that is related to a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the application that is related to a finding.
         * </p>
         * 
         * @param applicationArn
         *        The Amazon Resource Name (ARN) of the application that is related to a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationArn(String applicationArn);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String id;

        private String partition;

        private String region;

        private String resourceRole;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private DataClassificationDetails dataClassification;

        private ResourceDetails details;

        private String applicationName;

        private String applicationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Resource model) {
            type(model.type);
            id(model.id);
            partition(model.partition);
            region(model.region);
            resourceRole(model.resourceRole);
            tags(model.tags);
            dataClassification(model.dataClassification);
            details(model.details);
            applicationName(model.applicationName);
            applicationArn(model.applicationArn);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getPartition() {
            return partition;
        }

        public final void setPartition(String partition) {
            this.partition = partition;
        }

        @Override
        public final Builder partition(String partition) {
            this.partition = partition;
            return this;
        }

        @Override
        public final Builder partition(Partition partition) {
            this.partition(partition == null ? null : partition.toString());
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getResourceRole() {
            return resourceRole;
        }

        public final void setResourceRole(String resourceRole) {
            this.resourceRole = resourceRole;
        }

        @Override
        public final Builder resourceRole(String resourceRole) {
            this.resourceRole = resourceRole;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = FieldMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = FieldMapCopier.copy(tags);
            return this;
        }

        public final DataClassificationDetails.Builder getDataClassification() {
            return dataClassification != null ? dataClassification.toBuilder() : null;
        }

        public final void setDataClassification(DataClassificationDetails.BuilderImpl dataClassification) {
            this.dataClassification = dataClassification != null ? dataClassification.build() : null;
        }

        @Override
        public final Builder dataClassification(DataClassificationDetails dataClassification) {
            this.dataClassification = dataClassification;
            return this;
        }

        public final ResourceDetails.Builder getDetails() {
            return details != null ? details.toBuilder() : null;
        }

        public final void setDetails(ResourceDetails.BuilderImpl details) {
            this.details = details != null ? details.build() : null;
        }

        @Override
        public final Builder details(ResourceDetails details) {
            this.details = details;
            return this;
        }

        public final String getApplicationName() {
            return applicationName;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final String getApplicationArn() {
            return applicationArn;
        }

        public final void setApplicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
        }

        @Override
        public final Builder applicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
            return this;
        }

        @Override
        public Resource build() {
            return new Resource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
