/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of process-related information about a finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProcessDetails implements SdkPojo, Serializable, ToCopyableBuilder<ProcessDetails.Builder, ProcessDetails> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ProcessDetails::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Path")
            .getter(getter(ProcessDetails::path)).setter(setter(Builder::path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()).build();

    private static final SdkField<Integer> PID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Pid")
            .getter(getter(ProcessDetails::pid)).setter(setter(Builder::pid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pid").build()).build();

    private static final SdkField<Integer> PARENT_PID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ParentPid").getter(getter(ProcessDetails::parentPid)).setter(setter(Builder::parentPid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentPid").build()).build();

    private static final SdkField<String> LAUNCHED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LaunchedAt").getter(getter(ProcessDetails::launchedAt)).setter(setter(Builder::launchedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchedAt").build()).build();

    private static final SdkField<String> TERMINATED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TerminatedAt").getter(getter(ProcessDetails::terminatedAt)).setter(setter(Builder::terminatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, PATH_FIELD,
            PID_FIELD, PARENT_PID_FIELD, LAUNCHED_AT_FIELD, TERMINATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String path;

    private final Integer pid;

    private final Integer parentPid;

    private final String launchedAt;

    private final String terminatedAt;

    private ProcessDetails(BuilderImpl builder) {
        this.name = builder.name;
        this.path = builder.path;
        this.pid = builder.pid;
        this.parentPid = builder.parentPid;
        this.launchedAt = builder.launchedAt;
        this.terminatedAt = builder.terminatedAt;
    }

    /**
     * <p>
     * The name of the process.
     * </p>
     * <p>
     * Length Constraints: Minimum of 1. Maximum of 64.
     * </p>
     * 
     * @return The name of the process.</p>
     *         <p>
     *         Length Constraints: Minimum of 1. Maximum of 64.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The path to the process executable.
     * </p>
     * <p>
     * Length Constraints: Minimum of 1. Maximum of 512.
     * </p>
     * 
     * @return The path to the process executable.</p>
     *         <p>
     *         Length Constraints: Minimum of 1. Maximum of 512.
     */
    public final String path() {
        return path;
    }

    /**
     * <p>
     * The process ID.
     * </p>
     * 
     * @return The process ID.
     */
    public final Integer pid() {
        return pid;
    }

    /**
     * <p>
     * The parent process ID. This field accepts positive integers between <code>O</code> and <code>2147483647</code>.
     * </p>
     * 
     * @return The parent process ID. This field accepts positive integers between <code>O</code> and
     *         <code>2147483647</code>.
     */
    public final Integer parentPid() {
        return parentPid;
    }

    /**
     * <p>
     * Indicates when the process was launched.
     * </p>
     * <p>
     * For more information about the validation and formatting of timestamp fields in Security Hub, see <a
     * href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a>.
     * </p>
     * 
     * @return Indicates when the process was launched.</p>
     *         <p>
     *         For more information about the validation and formatting of timestamp fields in Security Hub, see <a
     *         href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a>.
     */
    public final String launchedAt() {
        return launchedAt;
    }

    /**
     * <p>
     * Indicates when the process was terminated.
     * </p>
     * <p>
     * For more information about the validation and formatting of timestamp fields in Security Hub, see <a
     * href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a>.
     * </p>
     * 
     * @return Indicates when the process was terminated.</p>
     *         <p>
     *         For more information about the validation and formatting of timestamp fields in Security Hub, see <a
     *         href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a>.
     */
    public final String terminatedAt() {
        return terminatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(path());
        hashCode = 31 * hashCode + Objects.hashCode(pid());
        hashCode = 31 * hashCode + Objects.hashCode(parentPid());
        hashCode = 31 * hashCode + Objects.hashCode(launchedAt());
        hashCode = 31 * hashCode + Objects.hashCode(terminatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProcessDetails)) {
            return false;
        }
        ProcessDetails other = (ProcessDetails) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(path(), other.path()) && Objects.equals(pid(), other.pid())
                && Objects.equals(parentPid(), other.parentPid()) && Objects.equals(launchedAt(), other.launchedAt())
                && Objects.equals(terminatedAt(), other.terminatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProcessDetails").add("Name", name()).add("Path", path()).add("Pid", pid())
                .add("ParentPid", parentPid()).add("LaunchedAt", launchedAt()).add("TerminatedAt", terminatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Path":
            return Optional.ofNullable(clazz.cast(path()));
        case "Pid":
            return Optional.ofNullable(clazz.cast(pid()));
        case "ParentPid":
            return Optional.ofNullable(clazz.cast(parentPid()));
        case "LaunchedAt":
            return Optional.ofNullable(clazz.cast(launchedAt()));
        case "TerminatedAt":
            return Optional.ofNullable(clazz.cast(terminatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Path", PATH_FIELD);
        map.put("Pid", PID_FIELD);
        map.put("ParentPid", PARENT_PID_FIELD);
        map.put("LaunchedAt", LAUNCHED_AT_FIELD);
        map.put("TerminatedAt", TERMINATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProcessDetails, T> g) {
        return obj -> g.apply((ProcessDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProcessDetails> {
        /**
         * <p>
         * The name of the process.
         * </p>
         * <p>
         * Length Constraints: Minimum of 1. Maximum of 64.
         * </p>
         * 
         * @param name
         *        The name of the process.</p>
         *        <p>
         *        Length Constraints: Minimum of 1. Maximum of 64.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The path to the process executable.
         * </p>
         * <p>
         * Length Constraints: Minimum of 1. Maximum of 512.
         * </p>
         * 
         * @param path
         *        The path to the process executable.</p>
         *        <p>
         *        Length Constraints: Minimum of 1. Maximum of 512.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(String path);

        /**
         * <p>
         * The process ID.
         * </p>
         * 
         * @param pid
         *        The process ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pid(Integer pid);

        /**
         * <p>
         * The parent process ID. This field accepts positive integers between <code>O</code> and
         * <code>2147483647</code>.
         * </p>
         * 
         * @param parentPid
         *        The parent process ID. This field accepts positive integers between <code>O</code> and
         *        <code>2147483647</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentPid(Integer parentPid);

        /**
         * <p>
         * Indicates when the process was launched.
         * </p>
         * <p>
         * For more information about the validation and formatting of timestamp fields in Security Hub, see <a
         * href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a>.
         * </p>
         * 
         * @param launchedAt
         *        Indicates when the process was launched.</p>
         *        <p>
         *        For more information about the validation and formatting of timestamp fields in Security Hub, see <a
         *        href
         *        ="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchedAt(String launchedAt);

        /**
         * <p>
         * Indicates when the process was terminated.
         * </p>
         * <p>
         * For more information about the validation and formatting of timestamp fields in Security Hub, see <a
         * href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a>.
         * </p>
         * 
         * @param terminatedAt
         *        Indicates when the process was terminated.</p>
         *        <p>
         *        For more information about the validation and formatting of timestamp fields in Security Hub, see <a
         *        href
         *        ="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminatedAt(String terminatedAt);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String path;

        private Integer pid;

        private Integer parentPid;

        private String launchedAt;

        private String terminatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(ProcessDetails model) {
            name(model.name);
            path(model.path);
            pid(model.pid);
            parentPid(model.parentPid);
            launchedAt(model.launchedAt);
            terminatedAt(model.terminatedAt);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPath() {
            return path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final Integer getPid() {
            return pid;
        }

        public final void setPid(Integer pid) {
            this.pid = pid;
        }

        @Override
        public final Builder pid(Integer pid) {
            this.pid = pid;
            return this;
        }

        public final Integer getParentPid() {
            return parentPid;
        }

        public final void setParentPid(Integer parentPid) {
            this.parentPid = parentPid;
        }

        @Override
        public final Builder parentPid(Integer parentPid) {
            this.parentPid = parentPid;
            return this;
        }

        public final String getLaunchedAt() {
            return launchedAt;
        }

        public final void setLaunchedAt(String launchedAt) {
            this.launchedAt = launchedAt;
        }

        @Override
        public final Builder launchedAt(String launchedAt) {
            this.launchedAt = launchedAt;
            return this;
        }

        public final String getTerminatedAt() {
            return terminatedAt;
        }

        public final void setTerminatedAt(String terminatedAt) {
            this.terminatedAt = terminatedAt;
        }

        @Override
        public final Builder terminatedAt(String terminatedAt) {
            this.terminatedAt = terminatedAt;
            return this;
        }

        @Override
        public ProcessDetails build() {
            return new ProcessDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
