/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A port scan that was part of the port probe. For each scan, PortProbeDetails provides information about the local IP
 * address and port that were scanned, and the remote IP address that the scan originated from.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PortProbeDetail implements SdkPojo, Serializable, ToCopyableBuilder<PortProbeDetail.Builder, PortProbeDetail> {
    private static final SdkField<ActionLocalPortDetails> LOCAL_PORT_DETAILS_FIELD = SdkField
            .<ActionLocalPortDetails> builder(MarshallingType.SDK_POJO).memberName("LocalPortDetails")
            .getter(getter(PortProbeDetail::localPortDetails)).setter(setter(Builder::localPortDetails))
            .constructor(ActionLocalPortDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalPortDetails").build()).build();

    private static final SdkField<ActionLocalIpDetails> LOCAL_IP_DETAILS_FIELD = SdkField
            .<ActionLocalIpDetails> builder(MarshallingType.SDK_POJO).memberName("LocalIpDetails")
            .getter(getter(PortProbeDetail::localIpDetails)).setter(setter(Builder::localIpDetails))
            .constructor(ActionLocalIpDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalIpDetails").build()).build();

    private static final SdkField<ActionRemoteIpDetails> REMOTE_IP_DETAILS_FIELD = SdkField
            .<ActionRemoteIpDetails> builder(MarshallingType.SDK_POJO).memberName("RemoteIpDetails")
            .getter(getter(PortProbeDetail::remoteIpDetails)).setter(setter(Builder::remoteIpDetails))
            .constructor(ActionRemoteIpDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoteIpDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCAL_PORT_DETAILS_FIELD,
            LOCAL_IP_DETAILS_FIELD, REMOTE_IP_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ActionLocalPortDetails localPortDetails;

    private final ActionLocalIpDetails localIpDetails;

    private final ActionRemoteIpDetails remoteIpDetails;

    private PortProbeDetail(BuilderImpl builder) {
        this.localPortDetails = builder.localPortDetails;
        this.localIpDetails = builder.localIpDetails;
        this.remoteIpDetails = builder.remoteIpDetails;
    }

    /**
     * <p>
     * Provides information about the port that was scanned.
     * </p>
     * 
     * @return Provides information about the port that was scanned.
     */
    public final ActionLocalPortDetails localPortDetails() {
        return localPortDetails;
    }

    /**
     * <p>
     * Provides information about the IP address where the scanned port is located.
     * </p>
     * 
     * @return Provides information about the IP address where the scanned port is located.
     */
    public final ActionLocalIpDetails localIpDetails() {
        return localIpDetails;
    }

    /**
     * <p>
     * Provides information about the remote IP address that performed the scan.
     * </p>
     * 
     * @return Provides information about the remote IP address that performed the scan.
     */
    public final ActionRemoteIpDetails remoteIpDetails() {
        return remoteIpDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(localPortDetails());
        hashCode = 31 * hashCode + Objects.hashCode(localIpDetails());
        hashCode = 31 * hashCode + Objects.hashCode(remoteIpDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PortProbeDetail)) {
            return false;
        }
        PortProbeDetail other = (PortProbeDetail) obj;
        return Objects.equals(localPortDetails(), other.localPortDetails())
                && Objects.equals(localIpDetails(), other.localIpDetails())
                && Objects.equals(remoteIpDetails(), other.remoteIpDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PortProbeDetail").add("LocalPortDetails", localPortDetails())
                .add("LocalIpDetails", localIpDetails()).add("RemoteIpDetails", remoteIpDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LocalPortDetails":
            return Optional.ofNullable(clazz.cast(localPortDetails()));
        case "LocalIpDetails":
            return Optional.ofNullable(clazz.cast(localIpDetails()));
        case "RemoteIpDetails":
            return Optional.ofNullable(clazz.cast(remoteIpDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LocalPortDetails", LOCAL_PORT_DETAILS_FIELD);
        map.put("LocalIpDetails", LOCAL_IP_DETAILS_FIELD);
        map.put("RemoteIpDetails", REMOTE_IP_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PortProbeDetail, T> g) {
        return obj -> g.apply((PortProbeDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PortProbeDetail> {
        /**
         * <p>
         * Provides information about the port that was scanned.
         * </p>
         * 
         * @param localPortDetails
         *        Provides information about the port that was scanned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localPortDetails(ActionLocalPortDetails localPortDetails);

        /**
         * <p>
         * Provides information about the port that was scanned.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActionLocalPortDetails.Builder} avoiding
         * the need to create one manually via {@link ActionLocalPortDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActionLocalPortDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #localPortDetails(ActionLocalPortDetails)}.
         * 
         * @param localPortDetails
         *        a consumer that will call methods on {@link ActionLocalPortDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #localPortDetails(ActionLocalPortDetails)
         */
        default Builder localPortDetails(Consumer<ActionLocalPortDetails.Builder> localPortDetails) {
            return localPortDetails(ActionLocalPortDetails.builder().applyMutation(localPortDetails).build());
        }

        /**
         * <p>
         * Provides information about the IP address where the scanned port is located.
         * </p>
         * 
         * @param localIpDetails
         *        Provides information about the IP address where the scanned port is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localIpDetails(ActionLocalIpDetails localIpDetails);

        /**
         * <p>
         * Provides information about the IP address where the scanned port is located.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActionLocalIpDetails.Builder} avoiding
         * the need to create one manually via {@link ActionLocalIpDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActionLocalIpDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #localIpDetails(ActionLocalIpDetails)}.
         * 
         * @param localIpDetails
         *        a consumer that will call methods on {@link ActionLocalIpDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #localIpDetails(ActionLocalIpDetails)
         */
        default Builder localIpDetails(Consumer<ActionLocalIpDetails.Builder> localIpDetails) {
            return localIpDetails(ActionLocalIpDetails.builder().applyMutation(localIpDetails).build());
        }

        /**
         * <p>
         * Provides information about the remote IP address that performed the scan.
         * </p>
         * 
         * @param remoteIpDetails
         *        Provides information about the remote IP address that performed the scan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteIpDetails(ActionRemoteIpDetails remoteIpDetails);

        /**
         * <p>
         * Provides information about the remote IP address that performed the scan.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActionRemoteIpDetails.Builder} avoiding
         * the need to create one manually via {@link ActionRemoteIpDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActionRemoteIpDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #remoteIpDetails(ActionRemoteIpDetails)}.
         * 
         * @param remoteIpDetails
         *        a consumer that will call methods on {@link ActionRemoteIpDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #remoteIpDetails(ActionRemoteIpDetails)
         */
        default Builder remoteIpDetails(Consumer<ActionRemoteIpDetails.Builder> remoteIpDetails) {
            return remoteIpDetails(ActionRemoteIpDetails.builder().applyMutation(remoteIpDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ActionLocalPortDetails localPortDetails;

        private ActionLocalIpDetails localIpDetails;

        private ActionRemoteIpDetails remoteIpDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(PortProbeDetail model) {
            localPortDetails(model.localPortDetails);
            localIpDetails(model.localIpDetails);
            remoteIpDetails(model.remoteIpDetails);
        }

        public final ActionLocalPortDetails.Builder getLocalPortDetails() {
            return localPortDetails != null ? localPortDetails.toBuilder() : null;
        }

        public final void setLocalPortDetails(ActionLocalPortDetails.BuilderImpl localPortDetails) {
            this.localPortDetails = localPortDetails != null ? localPortDetails.build() : null;
        }

        @Override
        public final Builder localPortDetails(ActionLocalPortDetails localPortDetails) {
            this.localPortDetails = localPortDetails;
            return this;
        }

        public final ActionLocalIpDetails.Builder getLocalIpDetails() {
            return localIpDetails != null ? localIpDetails.toBuilder() : null;
        }

        public final void setLocalIpDetails(ActionLocalIpDetails.BuilderImpl localIpDetails) {
            this.localIpDetails = localIpDetails != null ? localIpDetails.build() : null;
        }

        @Override
        public final Builder localIpDetails(ActionLocalIpDetails localIpDetails) {
            this.localIpDetails = localIpDetails;
            return this;
        }

        public final ActionRemoteIpDetails.Builder getRemoteIpDetails() {
            return remoteIpDetails != null ? remoteIpDetails.toBuilder() : null;
        }

        public final void setRemoteIpDetails(ActionRemoteIpDetails.BuilderImpl remoteIpDetails) {
            this.remoteIpDetails = remoteIpDetails != null ? remoteIpDetails.build() : null;
        }

        @Override
        public final Builder remoteIpDetails(ActionRemoteIpDetails remoteIpDetails) {
            this.remoteIpDetails = remoteIpDetails;
            return this;
        }

        @Override
        public PortProbeDetail build() {
            return new PortProbeDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
