/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that includes the data type of a security control parameter and its current value.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ParameterValue implements SdkPojo, Serializable, ToCopyableBuilder<ParameterValue.Builder, ParameterValue> {
    private static final SdkField<Integer> INTEGER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Integer").getter(getter(ParameterValue::integer)).setter(setter(Builder::integer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Integer").build()).build();

    private static final SdkField<List<Integer>> INTEGER_LIST_FIELD = SdkField
            .<List<Integer>> builder(MarshallingType.LIST)
            .memberName("IntegerList")
            .getter(getter(ParameterValue::integerList))
            .setter(setter(Builder::integerList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegerList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Double> DOUBLE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Double")
            .getter(getter(ParameterValue::doubleValue)).setter(setter(Builder::doubleValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Double").build()).build();

    private static final SdkField<String> STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("String")
            .getter(getter(ParameterValue::string)).setter(setter(Builder::string))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("String").build()).build();

    private static final SdkField<List<String>> STRING_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("StringList")
            .getter(getter(ParameterValue::stringList))
            .setter(setter(Builder::stringList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> BOOLEAN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Boolean").getter(getter(ParameterValue::booleanValue)).setter(setter(Builder::booleanValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Boolean").build()).build();

    private static final SdkField<String> ENUM_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Enum")
            .getter(getter(ParameterValue::enumValue)).setter(setter(Builder::enumValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enum").build()).build();

    private static final SdkField<List<String>> ENUM_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EnumList")
            .getter(getter(ParameterValue::enumList))
            .setter(setter(Builder::enumList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnumList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTEGER_FIELD,
            INTEGER_LIST_FIELD, DOUBLE_FIELD, STRING_FIELD, STRING_LIST_FIELD, BOOLEAN_FIELD, ENUM_FIELD, ENUM_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer integer;

    private final List<Integer> integerList;

    private final Double doubleValue;

    private final String string;

    private final List<String> stringList;

    private final Boolean booleanValue;

    private final String enumValue;

    private final List<String> enumList;

    private final Type type;

    private ParameterValue(BuilderImpl builder) {
        this.integer = builder.integer;
        this.integerList = builder.integerList;
        this.doubleValue = builder.doubleValue;
        this.string = builder.string;
        this.stringList = builder.stringList;
        this.booleanValue = builder.booleanValue;
        this.enumValue = builder.enumValue;
        this.enumList = builder.enumList;
        this.type = builder.type;
    }

    /**
     * <p>
     * A control parameter that is an integer.
     * </p>
     * 
     * @return A control parameter that is an integer.
     */
    public final Integer integer() {
        return integer;
    }

    /**
     * For responses, this returns true if the service returned a value for the IntegerList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIntegerList() {
        return integerList != null && !(integerList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A control parameter that is a list of integers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIntegerList} method.
     * </p>
     * 
     * @return A control parameter that is a list of integers.
     */
    public final List<Integer> integerList() {
        return integerList;
    }

    /**
     * <p>
     * A control parameter that is a double.
     * </p>
     * 
     * @return A control parameter that is a double.
     */
    public final Double doubleValue() {
        return doubleValue;
    }

    /**
     * <p>
     * A control parameter that is a string.
     * </p>
     * 
     * @return A control parameter that is a string.
     */
    public final String string() {
        return string;
    }

    /**
     * For responses, this returns true if the service returned a value for the StringList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStringList() {
        return stringList != null && !(stringList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A control parameter that is a list of strings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStringList} method.
     * </p>
     * 
     * @return A control parameter that is a list of strings.
     */
    public final List<String> stringList() {
        return stringList;
    }

    /**
     * <p>
     * A control parameter that is a boolean.
     * </p>
     * 
     * @return A control parameter that is a boolean.
     */
    public final Boolean booleanValue() {
        return booleanValue;
    }

    /**
     * <p>
     * A control parameter that is an enum.
     * </p>
     * 
     * @return A control parameter that is an enum.
     */
    public final String enumValue() {
        return enumValue;
    }

    /**
     * For responses, this returns true if the service returned a value for the EnumList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEnumList() {
        return enumList != null && !(enumList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A control parameter that is a list of enums.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnumList} method.
     * </p>
     * 
     * @return A control parameter that is a list of enums.
     */
    public final List<String> enumList() {
        return enumList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(integer());
        hashCode = 31 * hashCode + Objects.hashCode(hasIntegerList() ? integerList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(doubleValue());
        hashCode = 31 * hashCode + Objects.hashCode(string());
        hashCode = 31 * hashCode + Objects.hashCode(hasStringList() ? stringList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(booleanValue());
        hashCode = 31 * hashCode + Objects.hashCode(enumValue());
        hashCode = 31 * hashCode + Objects.hashCode(hasEnumList() ? enumList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParameterValue)) {
            return false;
        }
        ParameterValue other = (ParameterValue) obj;
        return Objects.equals(integer(), other.integer()) && hasIntegerList() == other.hasIntegerList()
                && Objects.equals(integerList(), other.integerList()) && Objects.equals(doubleValue(), other.doubleValue())
                && Objects.equals(string(), other.string()) && hasStringList() == other.hasStringList()
                && Objects.equals(stringList(), other.stringList()) && Objects.equals(booleanValue(), other.booleanValue())
                && Objects.equals(enumValue(), other.enumValue()) && hasEnumList() == other.hasEnumList()
                && Objects.equals(enumList(), other.enumList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ParameterValue").add("Integer", integer())
                .add("IntegerList", hasIntegerList() ? integerList() : null).add("Double", doubleValue()).add("String", string())
                .add("StringList", hasStringList() ? stringList() : null).add("Boolean", booleanValue()).add("Enum", enumValue())
                .add("EnumList", hasEnumList() ? enumList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Integer":
            return Optional.ofNullable(clazz.cast(integer()));
        case "IntegerList":
            return Optional.ofNullable(clazz.cast(integerList()));
        case "Double":
            return Optional.ofNullable(clazz.cast(doubleValue()));
        case "String":
            return Optional.ofNullable(clazz.cast(string()));
        case "StringList":
            return Optional.ofNullable(clazz.cast(stringList()));
        case "Boolean":
            return Optional.ofNullable(clazz.cast(booleanValue()));
        case "Enum":
            return Optional.ofNullable(clazz.cast(enumValue()));
        case "EnumList":
            return Optional.ofNullable(clazz.cast(enumList()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #integer()} initialized to the given value.
     *
     * <p>
     * A control parameter that is an integer.
     * </p>
     * 
     * @param integer
     *        A control parameter that is an integer.
     */
    public static ParameterValue fromInteger(Integer integer) {
        return builder().integer(integer).build();
    }

    /**
     * Create an instance of this class with {@link #integerList()} initialized to the given value.
     *
     * <p>
     * A control parameter that is a list of integers.
     * </p>
     * 
     * @param integerList
     *        A control parameter that is a list of integers.
     */
    public static ParameterValue fromIntegerList(List<Integer> integerList) {
        return builder().integerList(integerList).build();
    }

    /**
     * Create an instance of this class with {@link #doubleValue()} initialized to the given value.
     *
     * <p>
     * A control parameter that is a double.
     * </p>
     * 
     * @param doubleValue
     *        A control parameter that is a double.
     */
    public static ParameterValue fromDoubleValue(Double doubleValue) {
        return builder().doubleValue(doubleValue).build();
    }

    /**
     * Create an instance of this class with {@link #string()} initialized to the given value.
     *
     * <p>
     * A control parameter that is a string.
     * </p>
     * 
     * @param string
     *        A control parameter that is a string.
     */
    public static ParameterValue fromString(String string) {
        return builder().string(string).build();
    }

    /**
     * Create an instance of this class with {@link #stringList()} initialized to the given value.
     *
     * <p>
     * A control parameter that is a list of strings.
     * </p>
     * 
     * @param stringList
     *        A control parameter that is a list of strings.
     */
    public static ParameterValue fromStringList(List<String> stringList) {
        return builder().stringList(stringList).build();
    }

    /**
     * Create an instance of this class with {@link #booleanValue()} initialized to the given value.
     *
     * <p>
     * A control parameter that is a boolean.
     * </p>
     * 
     * @param booleanValue
     *        A control parameter that is a boolean.
     */
    public static ParameterValue fromBooleanValue(Boolean booleanValue) {
        return builder().booleanValue(booleanValue).build();
    }

    /**
     * Create an instance of this class with {@link #enumValue()} initialized to the given value.
     *
     * <p>
     * A control parameter that is an enum.
     * </p>
     * 
     * @param enumValue
     *        A control parameter that is an enum.
     */
    public static ParameterValue fromEnumValue(String enumValue) {
        return builder().enumValue(enumValue).build();
    }

    /**
     * Create an instance of this class with {@link #enumList()} initialized to the given value.
     *
     * <p>
     * A control parameter that is a list of enums.
     * </p>
     * 
     * @param enumList
     *        A control parameter that is a list of enums.
     */
    public static ParameterValue fromEnumList(List<String> enumList) {
        return builder().enumList(enumList).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Integer", INTEGER_FIELD);
        map.put("IntegerList", INTEGER_LIST_FIELD);
        map.put("Double", DOUBLE_FIELD);
        map.put("String", STRING_FIELD);
        map.put("StringList", STRING_LIST_FIELD);
        map.put("Boolean", BOOLEAN_FIELD);
        map.put("Enum", ENUM_FIELD);
        map.put("EnumList", ENUM_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ParameterValue, T> g) {
        return obj -> g.apply((ParameterValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ParameterValue> {
        /**
         * <p>
         * A control parameter that is an integer.
         * </p>
         * 
         * @param integer
         *        A control parameter that is an integer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integer(Integer integer);

        /**
         * <p>
         * A control parameter that is a list of integers.
         * </p>
         * 
         * @param integerList
         *        A control parameter that is a list of integers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integerList(Collection<Integer> integerList);

        /**
         * <p>
         * A control parameter that is a list of integers.
         * </p>
         * 
         * @param integerList
         *        A control parameter that is a list of integers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integerList(Integer... integerList);

        /**
         * <p>
         * A control parameter that is a double.
         * </p>
         * 
         * @param doubleValue
         *        A control parameter that is a double.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder doubleValue(Double doubleValue);

        /**
         * <p>
         * A control parameter that is a string.
         * </p>
         * 
         * @param string
         *        A control parameter that is a string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder string(String string);

        /**
         * <p>
         * A control parameter that is a list of strings.
         * </p>
         * 
         * @param stringList
         *        A control parameter that is a list of strings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringList(Collection<String> stringList);

        /**
         * <p>
         * A control parameter that is a list of strings.
         * </p>
         * 
         * @param stringList
         *        A control parameter that is a list of strings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringList(String... stringList);

        /**
         * <p>
         * A control parameter that is a boolean.
         * </p>
         * 
         * @param booleanValue
         *        A control parameter that is a boolean.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder booleanValue(Boolean booleanValue);

        /**
         * <p>
         * A control parameter that is an enum.
         * </p>
         * 
         * @param enumValue
         *        A control parameter that is an enum.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enumValue(String enumValue);

        /**
         * <p>
         * A control parameter that is a list of enums.
         * </p>
         * 
         * @param enumList
         *        A control parameter that is a list of enums.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enumList(Collection<String> enumList);

        /**
         * <p>
         * A control parameter that is a list of enums.
         * </p>
         * 
         * @param enumList
         *        A control parameter that is a list of enums.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enumList(String... enumList);
    }

    static final class BuilderImpl implements Builder {
        private Integer integer;

        private List<Integer> integerList = DefaultSdkAutoConstructList.getInstance();

        private Double doubleValue;

        private String string;

        private List<String> stringList = DefaultSdkAutoConstructList.getInstance();

        private Boolean booleanValue;

        private String enumValue;

        private List<String> enumList = DefaultSdkAutoConstructList.getInstance();

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ParameterValue model) {
            integer(model.integer);
            integerList(model.integerList);
            doubleValue(model.doubleValue);
            string(model.string);
            stringList(model.stringList);
            booleanValue(model.booleanValue);
            enumValue(model.enumValue);
            enumList(model.enumList);
        }

        public final Integer getInteger() {
            return integer;
        }

        public final void setInteger(Integer integer) {
            Object oldValue = this.integer;
            this.integer = integer;
            handleUnionValueChange(Type.INTEGER, oldValue, this.integer);
        }

        @Override
        public final Builder integer(Integer integer) {
            Object oldValue = this.integer;
            this.integer = integer;
            handleUnionValueChange(Type.INTEGER, oldValue, this.integer);
            return this;
        }

        public final Collection<Integer> getIntegerList() {
            if (integerList instanceof SdkAutoConstructList) {
                return null;
            }
            return integerList;
        }

        public final void setIntegerList(Collection<Integer> integerList) {
            Object oldValue = this.integerList;
            this.integerList = IntegerListCopier.copy(integerList);
            handleUnionValueChange(Type.INTEGER_LIST, oldValue, this.integerList);
        }

        @Override
        public final Builder integerList(Collection<Integer> integerList) {
            Object oldValue = this.integerList;
            this.integerList = IntegerListCopier.copy(integerList);
            handleUnionValueChange(Type.INTEGER_LIST, oldValue, this.integerList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder integerList(Integer... integerList) {
            integerList(Arrays.asList(integerList));
            return this;
        }

        public final Double getDoubleValue() {
            return doubleValue;
        }

        public final void setDoubleValue(Double doubleValue) {
            Object oldValue = this.doubleValue;
            this.doubleValue = doubleValue;
            handleUnionValueChange(Type.DOUBLE, oldValue, this.doubleValue);
        }

        @Override
        public final Builder doubleValue(Double doubleValue) {
            Object oldValue = this.doubleValue;
            this.doubleValue = doubleValue;
            handleUnionValueChange(Type.DOUBLE, oldValue, this.doubleValue);
            return this;
        }

        public final String getString() {
            return string;
        }

        public final void setString(String string) {
            Object oldValue = this.string;
            this.string = string;
            handleUnionValueChange(Type.STRING, oldValue, this.string);
        }

        @Override
        public final Builder string(String string) {
            Object oldValue = this.string;
            this.string = string;
            handleUnionValueChange(Type.STRING, oldValue, this.string);
            return this;
        }

        public final Collection<String> getStringList() {
            if (stringList instanceof SdkAutoConstructList) {
                return null;
            }
            return stringList;
        }

        public final void setStringList(Collection<String> stringList) {
            Object oldValue = this.stringList;
            this.stringList = StringListCopier.copy(stringList);
            handleUnionValueChange(Type.STRING_LIST, oldValue, this.stringList);
        }

        @Override
        public final Builder stringList(Collection<String> stringList) {
            Object oldValue = this.stringList;
            this.stringList = StringListCopier.copy(stringList);
            handleUnionValueChange(Type.STRING_LIST, oldValue, this.stringList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stringList(String... stringList) {
            stringList(Arrays.asList(stringList));
            return this;
        }

        public final Boolean getBooleanValue() {
            return booleanValue;
        }

        public final void setBooleanValue(Boolean booleanValue) {
            Object oldValue = this.booleanValue;
            this.booleanValue = booleanValue;
            handleUnionValueChange(Type.BOOLEAN, oldValue, this.booleanValue);
        }

        @Override
        public final Builder booleanValue(Boolean booleanValue) {
            Object oldValue = this.booleanValue;
            this.booleanValue = booleanValue;
            handleUnionValueChange(Type.BOOLEAN, oldValue, this.booleanValue);
            return this;
        }

        public final String getEnumValue() {
            return enumValue;
        }

        public final void setEnumValue(String enumValue) {
            Object oldValue = this.enumValue;
            this.enumValue = enumValue;
            handleUnionValueChange(Type.ENUM, oldValue, this.enumValue);
        }

        @Override
        public final Builder enumValue(String enumValue) {
            Object oldValue = this.enumValue;
            this.enumValue = enumValue;
            handleUnionValueChange(Type.ENUM, oldValue, this.enumValue);
            return this;
        }

        public final Collection<String> getEnumList() {
            if (enumList instanceof SdkAutoConstructList) {
                return null;
            }
            return enumList;
        }

        public final void setEnumList(Collection<String> enumList) {
            Object oldValue = this.enumList;
            this.enumList = StringListCopier.copy(enumList);
            handleUnionValueChange(Type.ENUM_LIST, oldValue, this.enumList);
        }

        @Override
        public final Builder enumList(Collection<String> enumList) {
            Object oldValue = this.enumList;
            this.enumList = StringListCopier.copy(enumList);
            handleUnionValueChange(Type.ENUM_LIST, oldValue, this.enumList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enumList(String... enumList) {
            enumList(Arrays.asList(enumList));
            return this;
        }

        @Override
        public ParameterValue build() {
            return new ParameterValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ParameterValue#type()
     */
    public enum Type {
        INTEGER,

        INTEGER_LIST,

        DOUBLE,

        STRING,

        STRING_LIST,

        BOOLEAN,

        ENUM,

        ENUM_LIST,

        UNKNOWN_TO_SDK_VERSION
    }
}
