/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the filtering criteria for security findings using OCSF.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OcsfFindingFilters implements SdkPojo, Serializable,
        ToCopyableBuilder<OcsfFindingFilters.Builder, OcsfFindingFilters> {
    private static final SdkField<List<CompositeFilter>> COMPOSITE_FILTERS_FIELD = SdkField
            .<List<CompositeFilter>> builder(MarshallingType.LIST)
            .memberName("CompositeFilters")
            .getter(getter(OcsfFindingFilters::compositeFilters))
            .setter(setter(Builder::compositeFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompositeFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CompositeFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CompositeFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> COMPOSITE_OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CompositeOperator").getter(getter(OcsfFindingFilters::compositeOperatorAsString))
            .setter(setter(Builder::compositeOperator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompositeOperator").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPOSITE_FILTERS_FIELD,
            COMPOSITE_OPERATOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<CompositeFilter> compositeFilters;

    private final String compositeOperator;

    private OcsfFindingFilters(BuilderImpl builder) {
        this.compositeFilters = builder.compositeFilters;
        this.compositeOperator = builder.compositeOperator;
    }

    /**
     * For responses, this returns true if the service returned a value for the CompositeFilters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCompositeFilters() {
        return compositeFilters != null && !(compositeFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Enables the creation of complex filtering conditions by combining filter criteria.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCompositeFilters} method.
     * </p>
     * 
     * @return Enables the creation of complex filtering conditions by combining filter criteria.
     */
    public final List<CompositeFilter> compositeFilters() {
        return compositeFilters;
    }

    /**
     * <p>
     * The logical operators used to combine the filtering on multiple <code>CompositeFilters</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #compositeOperator}
     * will return {@link AllowedOperators#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #compositeOperatorAsString}.
     * </p>
     * 
     * @return The logical operators used to combine the filtering on multiple <code>CompositeFilters</code>.
     * @see AllowedOperators
     */
    public final AllowedOperators compositeOperator() {
        return AllowedOperators.fromValue(compositeOperator);
    }

    /**
     * <p>
     * The logical operators used to combine the filtering on multiple <code>CompositeFilters</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #compositeOperator}
     * will return {@link AllowedOperators#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #compositeOperatorAsString}.
     * </p>
     * 
     * @return The logical operators used to combine the filtering on multiple <code>CompositeFilters</code>.
     * @see AllowedOperators
     */
    public final String compositeOperatorAsString() {
        return compositeOperator;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCompositeFilters() ? compositeFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(compositeOperatorAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OcsfFindingFilters)) {
            return false;
        }
        OcsfFindingFilters other = (OcsfFindingFilters) obj;
        return hasCompositeFilters() == other.hasCompositeFilters()
                && Objects.equals(compositeFilters(), other.compositeFilters())
                && Objects.equals(compositeOperatorAsString(), other.compositeOperatorAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OcsfFindingFilters").add("CompositeFilters", hasCompositeFilters() ? compositeFilters() : null)
                .add("CompositeOperator", compositeOperatorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CompositeFilters":
            return Optional.ofNullable(clazz.cast(compositeFilters()));
        case "CompositeOperator":
            return Optional.ofNullable(clazz.cast(compositeOperatorAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CompositeFilters", COMPOSITE_FILTERS_FIELD);
        map.put("CompositeOperator", COMPOSITE_OPERATOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OcsfFindingFilters, T> g) {
        return obj -> g.apply((OcsfFindingFilters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OcsfFindingFilters> {
        /**
         * <p>
         * Enables the creation of complex filtering conditions by combining filter criteria.
         * </p>
         * 
         * @param compositeFilters
         *        Enables the creation of complex filtering conditions by combining filter criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compositeFilters(Collection<CompositeFilter> compositeFilters);

        /**
         * <p>
         * Enables the creation of complex filtering conditions by combining filter criteria.
         * </p>
         * 
         * @param compositeFilters
         *        Enables the creation of complex filtering conditions by combining filter criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compositeFilters(CompositeFilter... compositeFilters);

        /**
         * <p>
         * Enables the creation of complex filtering conditions by combining filter criteria.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.CompositeFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.securityhub.model.CompositeFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.CompositeFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #compositeFilters(List<CompositeFilter>)}.
         * 
         * @param compositeFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.CompositeFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #compositeFilters(java.util.Collection<CompositeFilter>)
         */
        Builder compositeFilters(Consumer<CompositeFilter.Builder>... compositeFilters);

        /**
         * <p>
         * The logical operators used to combine the filtering on multiple <code>CompositeFilters</code>.
         * </p>
         * 
         * @param compositeOperator
         *        The logical operators used to combine the filtering on multiple <code>CompositeFilters</code>.
         * @see AllowedOperators
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AllowedOperators
         */
        Builder compositeOperator(String compositeOperator);

        /**
         * <p>
         * The logical operators used to combine the filtering on multiple <code>CompositeFilters</code>.
         * </p>
         * 
         * @param compositeOperator
         *        The logical operators used to combine the filtering on multiple <code>CompositeFilters</code>.
         * @see AllowedOperators
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AllowedOperators
         */
        Builder compositeOperator(AllowedOperators compositeOperator);
    }

    static final class BuilderImpl implements Builder {
        private List<CompositeFilter> compositeFilters = DefaultSdkAutoConstructList.getInstance();

        private String compositeOperator;

        private BuilderImpl() {
        }

        private BuilderImpl(OcsfFindingFilters model) {
            compositeFilters(model.compositeFilters);
            compositeOperator(model.compositeOperator);
        }

        public final List<CompositeFilter.Builder> getCompositeFilters() {
            List<CompositeFilter.Builder> result = CompositeFilterListCopier.copyToBuilder(this.compositeFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCompositeFilters(Collection<CompositeFilter.BuilderImpl> compositeFilters) {
            this.compositeFilters = CompositeFilterListCopier.copyFromBuilder(compositeFilters);
        }

        @Override
        public final Builder compositeFilters(Collection<CompositeFilter> compositeFilters) {
            this.compositeFilters = CompositeFilterListCopier.copy(compositeFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compositeFilters(CompositeFilter... compositeFilters) {
            compositeFilters(Arrays.asList(compositeFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compositeFilters(Consumer<CompositeFilter.Builder>... compositeFilters) {
            compositeFilters(Stream.of(compositeFilters).map(c -> CompositeFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getCompositeOperator() {
            return compositeOperator;
        }

        public final void setCompositeOperator(String compositeOperator) {
            this.compositeOperator = compositeOperator;
        }

        @Override
        public final Builder compositeOperator(String compositeOperator) {
            this.compositeOperator = compositeOperator;
            return this;
        }

        @Override
        public final Builder compositeOperator(AllowedOperators compositeOperator) {
            this.compositeOperator(compositeOperator == null ? null : compositeOperator.toString());
            return this;
        }

        @Override
        public OcsfFindingFilters build() {
            return new OcsfFindingFilters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
