/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum OcsfDateField {
    FINDING_INFO_CREATED_TIME_DT("finding_info.created_time_dt"),

    FINDING_INFO_FIRST_SEEN_TIME_DT("finding_info.first_seen_time_dt"),

    FINDING_INFO_LAST_SEEN_TIME_DT("finding_info.last_seen_time_dt"),

    FINDING_INFO_MODIFIED_TIME_DT("finding_info.modified_time_dt"),

    RESOURCES_IMAGE_CREATED_TIME_DT("resources.image.created_time_dt"),

    RESOURCES_IMAGE_LAST_USED_TIME_DT("resources.image.last_used_time_dt"),

    RESOURCES_MODIFIED_TIME_DT("resources.modified_time_dt"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OcsfDateField> VALUE_MAP = EnumUtils.uniqueIndex(OcsfDateField.class,
            OcsfDateField::toString);

    private final String value;

    private OcsfDateField(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return OcsfDateField corresponding to the value
     */
    public static OcsfDateField fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link OcsfDateField}s
     */
    public static Set<OcsfDateField> knownValues() {
        Set<OcsfDateField> knownValues = EnumSet.allOf(OcsfDateField.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
