/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the location of a network endpoint involved in an Amazon GuardDuty Extended Threat
 * Detection attack sequence. GuardDuty generates an attack sequence finding when multiple events align to a potentially
 * suspicious activity. To receive GuardDuty attack sequence findings in Security Hub, you must have GuardDuty enabled.
 * For more information, see <a
 * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty-extended-threat-detection.html">GuardDuty Extended
 * Threat Detection </a> in the <i>Amazon GuardDuty User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkGeoLocation implements SdkPojo, Serializable,
        ToCopyableBuilder<NetworkGeoLocation.Builder, NetworkGeoLocation> {
    private static final SdkField<String> CITY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("City")
            .getter(getter(NetworkGeoLocation::city)).setter(setter(Builder::city))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("City").build()).build();

    private static final SdkField<String> COUNTRY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Country")
            .getter(getter(NetworkGeoLocation::country)).setter(setter(Builder::country))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Country").build()).build();

    private static final SdkField<Double> LAT_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Lat")
            .getter(getter(NetworkGeoLocation::lat)).setter(setter(Builder::lat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lat").build()).build();

    private static final SdkField<Double> LON_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Lon")
            .getter(getter(NetworkGeoLocation::lon)).setter(setter(Builder::lon))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lon").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CITY_FIELD, COUNTRY_FIELD,
            LAT_FIELD, LON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String city;

    private final String country;

    private final Double lat;

    private final Double lon;

    private NetworkGeoLocation(BuilderImpl builder) {
        this.city = builder.city;
        this.country = builder.country;
        this.lat = builder.lat;
        this.lon = builder.lon;
    }

    /**
     * <p>
     * The name of the city.
     * </p>
     * 
     * @return The name of the city.
     */
    public final String city() {
        return city;
    }

    /**
     * <p>
     * The name of the country.
     * </p>
     * 
     * @return The name of the country.
     */
    public final String country() {
        return country;
    }

    /**
     * <p>
     * The latitude information of the endpoint location.
     * </p>
     * 
     * @return The latitude information of the endpoint location.
     */
    public final Double lat() {
        return lat;
    }

    /**
     * <p>
     * The longitude information of the endpoint location.
     * </p>
     * 
     * @return The longitude information of the endpoint location.
     */
    public final Double lon() {
        return lon;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(city());
        hashCode = 31 * hashCode + Objects.hashCode(country());
        hashCode = 31 * hashCode + Objects.hashCode(lat());
        hashCode = 31 * hashCode + Objects.hashCode(lon());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkGeoLocation)) {
            return false;
        }
        NetworkGeoLocation other = (NetworkGeoLocation) obj;
        return Objects.equals(city(), other.city()) && Objects.equals(country(), other.country())
                && Objects.equals(lat(), other.lat()) && Objects.equals(lon(), other.lon());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NetworkGeoLocation").add("City", city()).add("Country", country()).add("Lat", lat())
                .add("Lon", lon()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "City":
            return Optional.ofNullable(clazz.cast(city()));
        case "Country":
            return Optional.ofNullable(clazz.cast(country()));
        case "Lat":
            return Optional.ofNullable(clazz.cast(lat()));
        case "Lon":
            return Optional.ofNullable(clazz.cast(lon()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("City", CITY_FIELD);
        map.put("Country", COUNTRY_FIELD);
        map.put("Lat", LAT_FIELD);
        map.put("Lon", LON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NetworkGeoLocation, T> g) {
        return obj -> g.apply((NetworkGeoLocation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkGeoLocation> {
        /**
         * <p>
         * The name of the city.
         * </p>
         * 
         * @param city
         *        The name of the city.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder city(String city);

        /**
         * <p>
         * The name of the country.
         * </p>
         * 
         * @param country
         *        The name of the country.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder country(String country);

        /**
         * <p>
         * The latitude information of the endpoint location.
         * </p>
         * 
         * @param lat
         *        The latitude information of the endpoint location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lat(Double lat);

        /**
         * <p>
         * The longitude information of the endpoint location.
         * </p>
         * 
         * @param lon
         *        The longitude information of the endpoint location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lon(Double lon);
    }

    static final class BuilderImpl implements Builder {
        private String city;

        private String country;

        private Double lat;

        private Double lon;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkGeoLocation model) {
            city(model.city);
            country(model.country);
            lat(model.lat);
            lon(model.lon);
        }

        public final String getCity() {
            return city;
        }

        public final void setCity(String city) {
            this.city = city;
        }

        @Override
        public final Builder city(String city) {
            this.city = city;
            return this;
        }

        public final String getCountry() {
            return country;
        }

        public final void setCountry(String country) {
            this.country = country;
        }

        @Override
        public final Builder country(String country) {
            this.country = country;
            return this;
        }

        public final Double getLat() {
            return lat;
        }

        public final void setLat(Double lat) {
            this.lat = lat;
        }

        @Override
        public final Builder lat(Double lat) {
            this.lat = lat;
            return this;
        }

        public final Double getLon() {
            return lon;
        }

        public final void setLon(Double lon) {
            this.lon = lon;
        }

        @Override
        public final Builder lon(Double lon) {
            this.lon = lon;
            return this;
        }

        @Override
        public NetworkGeoLocation build() {
            return new NetworkGeoLocation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
