/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListConnectorsV2Request extends SecurityHubRequest implements
        ToCopyableBuilder<ListConnectorsV2Request.Builder, ListConnectorsV2Request> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListConnectorsV2Request::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListConnectorsV2Request::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxResults").build()).build();

    private static final SdkField<String> PROVIDER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProviderName").getter(getter(ListConnectorsV2Request::providerNameAsString))
            .setter(setter(Builder::providerName))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ProviderName").build()).build();

    private static final SdkField<String> CONNECTOR_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectorStatus").getter(getter(ListConnectorsV2Request::connectorStatusAsString))
            .setter(setter(Builder::connectorStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ConnectorStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD, PROVIDER_NAME_FIELD, CONNECTOR_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final Integer maxResults;

    private final String providerName;

    private final String connectorStatus;

    private ListConnectorsV2Request(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.providerName = builder.providerName;
        this.connectorStatus = builder.connectorStatus;
    }

    /**
     * <p>
     * The pagination token per the Amazon Web Services Pagination standard
     * </p>
     * 
     * @return The pagination token per the Amazon Web Services Pagination standard
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to be returned.
     * </p>
     * 
     * @return The maximum number of results to be returned.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The name of the third-party provider.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #providerName} will
     * return {@link ConnectorProviderName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #providerNameAsString}.
     * </p>
     * 
     * @return The name of the third-party provider.
     * @see ConnectorProviderName
     */
    public final ConnectorProviderName providerName() {
        return ConnectorProviderName.fromValue(providerName);
    }

    /**
     * <p>
     * The name of the third-party provider.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #providerName} will
     * return {@link ConnectorProviderName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #providerNameAsString}.
     * </p>
     * 
     * @return The name of the third-party provider.
     * @see ConnectorProviderName
     */
    public final String providerNameAsString() {
        return providerName;
    }

    /**
     * <p>
     * The status for the connectorV2.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectorStatus}
     * will return {@link ConnectorStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectorStatusAsString}.
     * </p>
     * 
     * @return The status for the connectorV2.
     * @see ConnectorStatus
     */
    public final ConnectorStatus connectorStatus() {
        return ConnectorStatus.fromValue(connectorStatus);
    }

    /**
     * <p>
     * The status for the connectorV2.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectorStatus}
     * will return {@link ConnectorStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectorStatusAsString}.
     * </p>
     * 
     * @return The status for the connectorV2.
     * @see ConnectorStatus
     */
    public final String connectorStatusAsString() {
        return connectorStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(providerNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(connectorStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConnectorsV2Request)) {
            return false;
        }
        ListConnectorsV2Request other = (ListConnectorsV2Request) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(providerNameAsString(), other.providerNameAsString())
                && Objects.equals(connectorStatusAsString(), other.connectorStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListConnectorsV2Request").add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("ProviderName", providerNameAsString()).add("ConnectorStatus", connectorStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "ProviderName":
            return Optional.ofNullable(clazz.cast(providerNameAsString()));
        case "ConnectorStatus":
            return Optional.ofNullable(clazz.cast(connectorStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("ProviderName", PROVIDER_NAME_FIELD);
        map.put("ConnectorStatus", CONNECTOR_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListConnectorsV2Request, T> g) {
        return obj -> g.apply((ListConnectorsV2Request) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SecurityHubRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListConnectorsV2Request> {
        /**
         * <p>
         * The pagination token per the Amazon Web Services Pagination standard
         * </p>
         * 
         * @param nextToken
         *        The pagination token per the Amazon Web Services Pagination standard
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to be returned.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The name of the third-party provider.
         * </p>
         * 
         * @param providerName
         *        The name of the third-party provider.
         * @see ConnectorProviderName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorProviderName
         */
        Builder providerName(String providerName);

        /**
         * <p>
         * The name of the third-party provider.
         * </p>
         * 
         * @param providerName
         *        The name of the third-party provider.
         * @see ConnectorProviderName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorProviderName
         */
        Builder providerName(ConnectorProviderName providerName);

        /**
         * <p>
         * The status for the connectorV2.
         * </p>
         * 
         * @param connectorStatus
         *        The status for the connectorV2.
         * @see ConnectorStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorStatus
         */
        Builder connectorStatus(String connectorStatus);

        /**
         * <p>
         * The status for the connectorV2.
         * </p>
         * 
         * @param connectorStatus
         *        The status for the connectorV2.
         * @see ConnectorStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorStatus
         */
        Builder connectorStatus(ConnectorStatus connectorStatus);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecurityHubRequest.BuilderImpl implements Builder {
        private String nextToken;

        private Integer maxResults;

        private String providerName;

        private String connectorStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ListConnectorsV2Request model) {
            super(model);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            providerName(model.providerName);
            connectorStatus(model.connectorStatus);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getProviderName() {
            return providerName;
        }

        public final void setProviderName(String providerName) {
            this.providerName = providerName;
        }

        @Override
        public final Builder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        @Override
        public final Builder providerName(ConnectorProviderName providerName) {
            this.providerName(providerName == null ? null : providerName.toString());
            return this;
        }

        public final String getConnectorStatus() {
            return connectorStatus;
        }

        public final void setConnectorStatus(String connectorStatus) {
            this.connectorStatus = connectorStatus;
        }

        @Override
        public final Builder connectorStatus(String connectorStatus) {
            this.connectorStatus = connectorStatus;
            return this;
        }

        @Override
        public final Builder connectorStatus(ConnectorStatus connectorStatus) {
            this.connectorStatus(connectorStatus == null ? null : connectorStatus.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListConnectorsV2Request build() {
            return new ListConnectorsV2Request(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
