/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAggregatorsV2Response extends SecurityHubResponse implements
        ToCopyableBuilder<ListAggregatorsV2Response.Builder, ListAggregatorsV2Response> {
    private static final SdkField<List<AggregatorV2>> AGGREGATORS_V2_FIELD = SdkField
            .<List<AggregatorV2>> builder(MarshallingType.LIST)
            .memberName("AggregatorsV2")
            .getter(getter(ListAggregatorsV2Response::aggregatorsV2))
            .setter(setter(Builder::aggregatorsV2))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregatorsV2").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AggregatorV2> builder(MarshallingType.SDK_POJO)
                                            .constructor(AggregatorV2::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAggregatorsV2Response::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGGREGATORS_V2_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<AggregatorV2> aggregatorsV2;

    private final String nextToken;

    private ListAggregatorsV2Response(BuilderImpl builder) {
        super(builder);
        this.aggregatorsV2 = builder.aggregatorsV2;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AggregatorsV2 property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAggregatorsV2() {
        return aggregatorsV2 != null && !(aggregatorsV2 instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of aggregators.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAggregatorsV2} method.
     * </p>
     * 
     * @return An array of aggregators.
     */
    public final List<AggregatorV2> aggregatorsV2() {
        return aggregatorsV2;
    }

    /**
     * <p>
     * The pagination token to use to request the next page of results. Otherwise, this parameter is null.
     * </p>
     * 
     * @return The pagination token to use to request the next page of results. Otherwise, this parameter is null.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAggregatorsV2() ? aggregatorsV2() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAggregatorsV2Response)) {
            return false;
        }
        ListAggregatorsV2Response other = (ListAggregatorsV2Response) obj;
        return hasAggregatorsV2() == other.hasAggregatorsV2() && Objects.equals(aggregatorsV2(), other.aggregatorsV2())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAggregatorsV2Response").add("AggregatorsV2", hasAggregatorsV2() ? aggregatorsV2() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AggregatorsV2":
            return Optional.ofNullable(clazz.cast(aggregatorsV2()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AggregatorsV2", AGGREGATORS_V2_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAggregatorsV2Response, T> g) {
        return obj -> g.apply((ListAggregatorsV2Response) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SecurityHubResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListAggregatorsV2Response> {
        /**
         * <p>
         * An array of aggregators.
         * </p>
         * 
         * @param aggregatorsV2
         *        An array of aggregators.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregatorsV2(Collection<AggregatorV2> aggregatorsV2);

        /**
         * <p>
         * An array of aggregators.
         * </p>
         * 
         * @param aggregatorsV2
         *        An array of aggregators.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregatorsV2(AggregatorV2... aggregatorsV2);

        /**
         * <p>
         * An array of aggregators.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AggregatorV2.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.securityhub.model.AggregatorV2#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AggregatorV2.Builder#build()} is called immediately
         * and its result is passed to {@link #aggregatorsV2(List<AggregatorV2>)}.
         * 
         * @param aggregatorsV2
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AggregatorV2.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aggregatorsV2(java.util.Collection<AggregatorV2>)
         */
        Builder aggregatorsV2(Consumer<AggregatorV2.Builder>... aggregatorsV2);

        /**
         * <p>
         * The pagination token to use to request the next page of results. Otherwise, this parameter is null.
         * </p>
         * 
         * @param nextToken
         *        The pagination token to use to request the next page of results. Otherwise, this parameter is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SecurityHubResponse.BuilderImpl implements Builder {
        private List<AggregatorV2> aggregatorsV2 = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAggregatorsV2Response model) {
            super(model);
            aggregatorsV2(model.aggregatorsV2);
            nextToken(model.nextToken);
        }

        public final List<AggregatorV2.Builder> getAggregatorsV2() {
            List<AggregatorV2.Builder> result = AggregatorV2ListCopier.copyToBuilder(this.aggregatorsV2);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAggregatorsV2(Collection<AggregatorV2.BuilderImpl> aggregatorsV2) {
            this.aggregatorsV2 = AggregatorV2ListCopier.copyFromBuilder(aggregatorsV2);
        }

        @Override
        public final Builder aggregatorsV2(Collection<AggregatorV2> aggregatorsV2) {
            this.aggregatorsV2 = AggregatorV2ListCopier.copy(aggregatorsV2);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregatorsV2(AggregatorV2... aggregatorsV2) {
            aggregatorsV2(Arrays.asList(aggregatorsV2));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregatorsV2(Consumer<AggregatorV2.Builder>... aggregatorsV2) {
            aggregatorsV2(Stream.of(aggregatorsV2).map(c -> AggregatorV2.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAggregatorsV2Response build() {
            return new ListAggregatorsV2Response(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
