/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The options for customizing a security control parameter that is a list of integers.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IntegerListConfigurationOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<IntegerListConfigurationOptions.Builder, IntegerListConfigurationOptions> {
    private static final SdkField<List<Integer>> DEFAULT_VALUE_FIELD = SdkField
            .<List<Integer>> builder(MarshallingType.LIST)
            .memberName("DefaultValue")
            .getter(getter(IntegerListConfigurationOptions::defaultValue))
            .setter(setter(Builder::defaultValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultValue").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MIN_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Min")
            .getter(getter(IntegerListConfigurationOptions::min)).setter(setter(Builder::min))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Min").build()).build();

    private static final SdkField<Integer> MAX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Max")
            .getter(getter(IntegerListConfigurationOptions::max)).setter(setter(Builder::max))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Max").build()).build();

    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxItems").getter(getter(IntegerListConfigurationOptions::maxItems)).setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_VALUE_FIELD,
            MIN_FIELD, MAX_FIELD, MAX_ITEMS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<Integer> defaultValue;

    private final Integer min;

    private final Integer max;

    private final Integer maxItems;

    private IntegerListConfigurationOptions(BuilderImpl builder) {
        this.defaultValue = builder.defaultValue;
        this.min = builder.min;
        this.max = builder.max;
        this.maxItems = builder.maxItems;
    }

    /**
     * For responses, this returns true if the service returned a value for the DefaultValue property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDefaultValue() {
        return defaultValue != null && !(defaultValue instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Security Hub default value for a control parameter that is a list of integers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDefaultValue} method.
     * </p>
     * 
     * @return The Security Hub default value for a control parameter that is a list of integers.
     */
    public final List<Integer> defaultValue() {
        return defaultValue;
    }

    /**
     * <p>
     * The minimum valid value for a control parameter that is a list of integers.
     * </p>
     * 
     * @return The minimum valid value for a control parameter that is a list of integers.
     */
    public final Integer min() {
        return min;
    }

    /**
     * <p>
     * The maximum valid value for a control parameter that is a list of integers.
     * </p>
     * 
     * @return The maximum valid value for a control parameter that is a list of integers.
     */
    public final Integer max() {
        return max;
    }

    /**
     * <p>
     * The maximum number of list items that an interger list control parameter can accept.
     * </p>
     * 
     * @return The maximum number of list items that an interger list control parameter can accept.
     */
    public final Integer maxItems() {
        return maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDefaultValue() ? defaultValue() : null);
        hashCode = 31 * hashCode + Objects.hashCode(min());
        hashCode = 31 * hashCode + Objects.hashCode(max());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntegerListConfigurationOptions)) {
            return false;
        }
        IntegerListConfigurationOptions other = (IntegerListConfigurationOptions) obj;
        return hasDefaultValue() == other.hasDefaultValue() && Objects.equals(defaultValue(), other.defaultValue())
                && Objects.equals(min(), other.min()) && Objects.equals(max(), other.max())
                && Objects.equals(maxItems(), other.maxItems());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IntegerListConfigurationOptions").add("DefaultValue", hasDefaultValue() ? defaultValue() : null)
                .add("Min", min()).add("Max", max()).add("MaxItems", maxItems()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DefaultValue":
            return Optional.ofNullable(clazz.cast(defaultValue()));
        case "Min":
            return Optional.ofNullable(clazz.cast(min()));
        case "Max":
            return Optional.ofNullable(clazz.cast(max()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DefaultValue", DEFAULT_VALUE_FIELD);
        map.put("Min", MIN_FIELD);
        map.put("Max", MAX_FIELD);
        map.put("MaxItems", MAX_ITEMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IntegerListConfigurationOptions, T> g) {
        return obj -> g.apply((IntegerListConfigurationOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IntegerListConfigurationOptions> {
        /**
         * <p>
         * The Security Hub default value for a control parameter that is a list of integers.
         * </p>
         * 
         * @param defaultValue
         *        The Security Hub default value for a control parameter that is a list of integers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValue(Collection<Integer> defaultValue);

        /**
         * <p>
         * The Security Hub default value for a control parameter that is a list of integers.
         * </p>
         * 
         * @param defaultValue
         *        The Security Hub default value for a control parameter that is a list of integers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValue(Integer... defaultValue);

        /**
         * <p>
         * The minimum valid value for a control parameter that is a list of integers.
         * </p>
         * 
         * @param min
         *        The minimum valid value for a control parameter that is a list of integers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder min(Integer min);

        /**
         * <p>
         * The maximum valid value for a control parameter that is a list of integers.
         * </p>
         * 
         * @param max
         *        The maximum valid value for a control parameter that is a list of integers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder max(Integer max);

        /**
         * <p>
         * The maximum number of list items that an interger list control parameter can accept.
         * </p>
         * 
         * @param maxItems
         *        The maximum number of list items that an interger list control parameter can accept.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(Integer maxItems);
    }

    static final class BuilderImpl implements Builder {
        private List<Integer> defaultValue = DefaultSdkAutoConstructList.getInstance();

        private Integer min;

        private Integer max;

        private Integer maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(IntegerListConfigurationOptions model) {
            defaultValue(model.defaultValue);
            min(model.min);
            max(model.max);
            maxItems(model.maxItems);
        }

        public final Collection<Integer> getDefaultValue() {
            if (defaultValue instanceof SdkAutoConstructList) {
                return null;
            }
            return defaultValue;
        }

        public final void setDefaultValue(Collection<Integer> defaultValue) {
            this.defaultValue = IntegerListCopier.copy(defaultValue);
        }

        @Override
        public final Builder defaultValue(Collection<Integer> defaultValue) {
            this.defaultValue = IntegerListCopier.copy(defaultValue);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultValue(Integer... defaultValue) {
            defaultValue(Arrays.asList(defaultValue));
            return this;
        }

        public final Integer getMin() {
            return min;
        }

        public final void setMin(Integer min) {
            this.min = min;
        }

        @Override
        public final Builder min(Integer min) {
            this.min = min;
            return this;
        }

        public final Integer getMax() {
            return max;
        }

        public final void setMax(Integer max) {
            this.max = max;
        }

        @Override
        public final Builder max(Integer max) {
            this.max = max;
            return this;
        }

        public final Integer getMaxItems() {
            return maxItems;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        @Override
        public IntegerListConfigurationOptions build() {
            return new IntegerListConfigurationOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
