/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The insight result values returned by the <code>GetInsightResults</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InsightResultValue implements SdkPojo, Serializable,
        ToCopyableBuilder<InsightResultValue.Builder, InsightResultValue> {
    private static final SdkField<String> GROUP_BY_ATTRIBUTE_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupByAttributeValue").getter(getter(InsightResultValue::groupByAttributeValue))
            .setter(setter(Builder::groupByAttributeValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupByAttributeValue").build())
            .build();

    private static final SdkField<Integer> COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Count")
            .getter(getter(InsightResultValue::count)).setter(setter(Builder::count))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Count").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            GROUP_BY_ATTRIBUTE_VALUE_FIELD, COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String groupByAttributeValue;

    private final Integer count;

    private InsightResultValue(BuilderImpl builder) {
        this.groupByAttributeValue = builder.groupByAttributeValue;
        this.count = builder.count;
    }

    /**
     * <p>
     * The value of the attribute that the findings are grouped by for the insight whose results are returned by the
     * <code>GetInsightResults</code> operation.
     * </p>
     * 
     * @return The value of the attribute that the findings are grouped by for the insight whose results are returned by
     *         the <code>GetInsightResults</code> operation.
     */
    public final String groupByAttributeValue() {
        return groupByAttributeValue;
    }

    /**
     * <p>
     * The number of findings returned for each <code>GroupByAttributeValue</code>.
     * </p>
     * 
     * @return The number of findings returned for each <code>GroupByAttributeValue</code>.
     */
    public final Integer count() {
        return count;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groupByAttributeValue());
        hashCode = 31 * hashCode + Objects.hashCode(count());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InsightResultValue)) {
            return false;
        }
        InsightResultValue other = (InsightResultValue) obj;
        return Objects.equals(groupByAttributeValue(), other.groupByAttributeValue()) && Objects.equals(count(), other.count());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InsightResultValue").add("GroupByAttributeValue", groupByAttributeValue()).add("Count", count())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupByAttributeValue":
            return Optional.ofNullable(clazz.cast(groupByAttributeValue()));
        case "Count":
            return Optional.ofNullable(clazz.cast(count()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GroupByAttributeValue", GROUP_BY_ATTRIBUTE_VALUE_FIELD);
        map.put("Count", COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InsightResultValue, T> g) {
        return obj -> g.apply((InsightResultValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InsightResultValue> {
        /**
         * <p>
         * The value of the attribute that the findings are grouped by for the insight whose results are returned by the
         * <code>GetInsightResults</code> operation.
         * </p>
         * 
         * @param groupByAttributeValue
         *        The value of the attribute that the findings are grouped by for the insight whose results are returned
         *        by the <code>GetInsightResults</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupByAttributeValue(String groupByAttributeValue);

        /**
         * <p>
         * The number of findings returned for each <code>GroupByAttributeValue</code>.
         * </p>
         * 
         * @param count
         *        The number of findings returned for each <code>GroupByAttributeValue</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Integer count);
    }

    static final class BuilderImpl implements Builder {
        private String groupByAttributeValue;

        private Integer count;

        private BuilderImpl() {
        }

        private BuilderImpl(InsightResultValue model) {
            groupByAttributeValue(model.groupByAttributeValue);
            count(model.count);
        }

        public final String getGroupByAttributeValue() {
            return groupByAttributeValue;
        }

        public final void setGroupByAttributeValue(String groupByAttributeValue) {
            this.groupByAttributeValue = groupByAttributeValue;
        }

        @Override
        public final Builder groupByAttributeValue(String groupByAttributeValue) {
            this.groupByAttributeValue = groupByAttributeValue;
            return this;
        }

        public final Integer getCount() {
            return count;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        @Override
        public InsightResultValue build() {
            return new InsightResultValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
