/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the how the finding attribute should be grouped.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GroupByRule implements SdkPojo, Serializable, ToCopyableBuilder<GroupByRule.Builder, GroupByRule> {
    private static final SdkField<OcsfFindingFilters> FILTERS_FIELD = SdkField
            .<OcsfFindingFilters> builder(MarshallingType.SDK_POJO).memberName("Filters").getter(getter(GroupByRule::filters))
            .setter(setter(Builder::filters)).constructor(OcsfFindingFilters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build()).build();

    private static final SdkField<String> GROUP_BY_FIELD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupByField").getter(getter(GroupByRule::groupByFieldAsString)).setter(setter(Builder::groupByField))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupByField").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD,
            GROUP_BY_FIELD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final OcsfFindingFilters filters;

    private final String groupByField;

    private GroupByRule(BuilderImpl builder) {
        this.filters = builder.filters;
        this.groupByField = builder.groupByField;
    }

    /**
     * <p>
     * The criteria used to select which security findings should be included in the grouping operation.
     * </p>
     * 
     * @return The criteria used to select which security findings should be included in the grouping operation.
     */
    public final OcsfFindingFilters filters() {
        return filters;
    }

    /**
     * <p>
     * The attribute by which filtered findings should be grouped.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #groupByField} will
     * return {@link GroupByField#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #groupByFieldAsString}.
     * </p>
     * 
     * @return The attribute by which filtered findings should be grouped.
     * @see GroupByField
     */
    public final GroupByField groupByField() {
        return GroupByField.fromValue(groupByField);
    }

    /**
     * <p>
     * The attribute by which filtered findings should be grouped.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #groupByField} will
     * return {@link GroupByField#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #groupByFieldAsString}.
     * </p>
     * 
     * @return The attribute by which filtered findings should be grouped.
     * @see GroupByField
     */
    public final String groupByFieldAsString() {
        return groupByField;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(groupByFieldAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroupByRule)) {
            return false;
        }
        GroupByRule other = (GroupByRule) obj;
        return Objects.equals(filters(), other.filters()) && Objects.equals(groupByFieldAsString(), other.groupByFieldAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GroupByRule").add("Filters", filters()).add("GroupByField", groupByFieldAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "GroupByField":
            return Optional.ofNullable(clazz.cast(groupByFieldAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Filters", FILTERS_FIELD);
        map.put("GroupByField", GROUP_BY_FIELD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GroupByRule, T> g) {
        return obj -> g.apply((GroupByRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GroupByRule> {
        /**
         * <p>
         * The criteria used to select which security findings should be included in the grouping operation.
         * </p>
         * 
         * @param filters
         *        The criteria used to select which security findings should be included in the grouping operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(OcsfFindingFilters filters);

        /**
         * <p>
         * The criteria used to select which security findings should be included in the grouping operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link OcsfFindingFilters.Builder} avoiding the
         * need to create one manually via {@link OcsfFindingFilters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OcsfFindingFilters.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(OcsfFindingFilters)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link OcsfFindingFilters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(OcsfFindingFilters)
         */
        default Builder filters(Consumer<OcsfFindingFilters.Builder> filters) {
            return filters(OcsfFindingFilters.builder().applyMutation(filters).build());
        }

        /**
         * <p>
         * The attribute by which filtered findings should be grouped.
         * </p>
         * 
         * @param groupByField
         *        The attribute by which filtered findings should be grouped.
         * @see GroupByField
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GroupByField
         */
        Builder groupByField(String groupByField);

        /**
         * <p>
         * The attribute by which filtered findings should be grouped.
         * </p>
         * 
         * @param groupByField
         *        The attribute by which filtered findings should be grouped.
         * @see GroupByField
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GroupByField
         */
        Builder groupByField(GroupByField groupByField);
    }

    static final class BuilderImpl implements Builder {
        private OcsfFindingFilters filters;

        private String groupByField;

        private BuilderImpl() {
        }

        private BuilderImpl(GroupByRule model) {
            filters(model.filters);
            groupByField(model.groupByField);
        }

        public final OcsfFindingFilters.Builder getFilters() {
            return filters != null ? filters.toBuilder() : null;
        }

        public final void setFilters(OcsfFindingFilters.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        @Override
        public final Builder filters(OcsfFindingFilters filters) {
            this.filters = filters;
            return this;
        }

        public final String getGroupByField() {
            return groupByField;
        }

        public final void setGroupByField(String groupByField) {
            this.groupByField = groupByField;
        }

        @Override
        public final Builder groupByField(String groupByField) {
            this.groupByField = groupByField;
            return this;
        }

        @Override
        public final Builder groupByField(GroupByField groupByField) {
            this.groupByField(groupByField == null ? null : groupByField.toString());
            return this;
        }

        @Override
        public GroupByRule build() {
            return new GroupByRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
