/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetResourcesTrendsV2Request extends SecurityHubRequest implements
        ToCopyableBuilder<GetResourcesTrendsV2Request.Builder, GetResourcesTrendsV2Request> {
    private static final SdkField<ResourcesTrendsFilters> FILTERS_FIELD = SdkField
            .<ResourcesTrendsFilters> builder(MarshallingType.SDK_POJO).memberName("Filters")
            .getter(getter(GetResourcesTrendsV2Request::filters)).setter(setter(Builder::filters))
            .constructor(ResourcesTrendsFilters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime")
            .getter(getter(GetResourcesTrendsV2Request::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime")
            .getter(getter(GetResourcesTrendsV2Request::endTime))
            .setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetResourcesTrendsV2Request::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(GetResourcesTrendsV2Request::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD,
            START_TIME_FIELD, END_TIME_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ResourcesTrendsFilters filters;

    private final Instant startTime;

    private final Instant endTime;

    private final String nextToken;

    private final Integer maxResults;

    private GetResourcesTrendsV2Request(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The filters to apply to the resources trend data.
     * </p>
     * 
     * @return The filters to apply to the resources trend data.
     */
    public final ResourcesTrendsFilters filters() {
        return filters;
    }

    /**
     * <p>
     * The starting timestamp for the time period to analyze resources trends, in ISO 8601 format.
     * </p>
     * 
     * @return The starting timestamp for the time period to analyze resources trends, in ISO 8601 format.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The ending timestamp for the time period to analyze resources trends, in ISO 8601 format.
     * </p>
     * 
     * @return The ending timestamp for the time period to analyze resources trends, in ISO 8601 format.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The token to use for paginating results. This value is returned in the response if more results are available.
     * </p>
     * 
     * @return The token to use for paginating results. This value is returned in the response if more results are
     *         available.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of trend data points to return in a single response.
     * </p>
     * 
     * @return The maximum number of trend data points to return in a single response.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourcesTrendsV2Request)) {
            return false;
        }
        GetResourcesTrendsV2Request other = (GetResourcesTrendsV2Request) obj;
        return Objects.equals(filters(), other.filters()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetResourcesTrendsV2Request").add("Filters", filters()).add("StartTime", startTime())
                .add("EndTime", endTime()).add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Filters", FILTERS_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetResourcesTrendsV2Request, T> g) {
        return obj -> g.apply((GetResourcesTrendsV2Request) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SecurityHubRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetResourcesTrendsV2Request> {
        /**
         * <p>
         * The filters to apply to the resources trend data.
         * </p>
         * 
         * @param filters
         *        The filters to apply to the resources trend data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(ResourcesTrendsFilters filters);

        /**
         * <p>
         * The filters to apply to the resources trend data.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourcesTrendsFilters.Builder} avoiding
         * the need to create one manually via {@link ResourcesTrendsFilters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourcesTrendsFilters.Builder#build()} is called immediately and
         * its result is passed to {@link #filters(ResourcesTrendsFilters)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link ResourcesTrendsFilters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(ResourcesTrendsFilters)
         */
        default Builder filters(Consumer<ResourcesTrendsFilters.Builder> filters) {
            return filters(ResourcesTrendsFilters.builder().applyMutation(filters).build());
        }

        /**
         * <p>
         * The starting timestamp for the time period to analyze resources trends, in ISO 8601 format.
         * </p>
         * 
         * @param startTime
         *        The starting timestamp for the time period to analyze resources trends, in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The ending timestamp for the time period to analyze resources trends, in ISO 8601 format.
         * </p>
         * 
         * @param endTime
         *        The ending timestamp for the time period to analyze resources trends, in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The token to use for paginating results. This value is returned in the response if more results are
         * available.
         * </p>
         * 
         * @param nextToken
         *        The token to use for paginating results. This value is returned in the response if more results are
         *        available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of trend data points to return in a single response.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of trend data points to return in a single response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecurityHubRequest.BuilderImpl implements Builder {
        private ResourcesTrendsFilters filters;

        private Instant startTime;

        private Instant endTime;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourcesTrendsV2Request model) {
            super(model);
            filters(model.filters);
            startTime(model.startTime);
            endTime(model.endTime);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final ResourcesTrendsFilters.Builder getFilters() {
            return filters != null ? filters.toBuilder() : null;
        }

        public final void setFilters(ResourcesTrendsFilters.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        @Override
        public final Builder filters(ResourcesTrendsFilters filters) {
            this.filters = filters;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetResourcesTrendsV2Request build() {
            return new GetResourcesTrendsV2Request(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
