/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetResourcesStatisticsV2Request extends SecurityHubRequest implements
        ToCopyableBuilder<GetResourcesStatisticsV2Request.Builder, GetResourcesStatisticsV2Request> {
    private static final SdkField<List<ResourceGroupByRule>> GROUP_BY_RULES_FIELD = SdkField
            .<List<ResourceGroupByRule>> builder(MarshallingType.LIST)
            .memberName("GroupByRules")
            .getter(getter(GetResourcesStatisticsV2Request::groupByRules))
            .setter(setter(Builder::groupByRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupByRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceGroupByRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceGroupByRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SortOrder").getter(getter(GetResourcesStatisticsV2Request::sortOrderAsString))
            .setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()).build();

    private static final SdkField<Integer> MAX_STATISTIC_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxStatisticResults").getter(getter(GetResourcesStatisticsV2Request::maxStatisticResults))
            .setter(setter(Builder::maxStatisticResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxStatisticResults").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_BY_RULES_FIELD,
            SORT_ORDER_FIELD, MAX_STATISTIC_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ResourceGroupByRule> groupByRules;

    private final String sortOrder;

    private final Integer maxStatisticResults;

    private GetResourcesStatisticsV2Request(BuilderImpl builder) {
        super(builder);
        this.groupByRules = builder.groupByRules;
        this.sortOrder = builder.sortOrder;
        this.maxStatisticResults = builder.maxStatisticResults;
    }

    /**
     * For responses, this returns true if the service returned a value for the GroupByRules property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGroupByRules() {
        return groupByRules != null && !(groupByRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * How resource statistics should be aggregated and organized in the response.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroupByRules} method.
     * </p>
     * 
     * @return How resource statistics should be aggregated and organized in the response.
     */
    public final List<ResourceGroupByRule> groupByRules() {
        return groupByRules;
    }

    /**
     * <p>
     * Sorts aggregated statistics.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return Sorts aggregated statistics.
     * @see SortOrder
     */
    public final SortOrder sortOrder() {
        return SortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * Sorts aggregated statistics.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return Sorts aggregated statistics.
     * @see SortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    /**
     * <p>
     * The maximum number of results to be returned.
     * </p>
     * 
     * @return The maximum number of results to be returned.
     */
    public final Integer maxStatisticResults() {
        return maxStatisticResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasGroupByRules() ? groupByRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxStatisticResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourcesStatisticsV2Request)) {
            return false;
        }
        GetResourcesStatisticsV2Request other = (GetResourcesStatisticsV2Request) obj;
        return hasGroupByRules() == other.hasGroupByRules() && Objects.equals(groupByRules(), other.groupByRules())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString())
                && Objects.equals(maxStatisticResults(), other.maxStatisticResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetResourcesStatisticsV2Request").add("GroupByRules", hasGroupByRules() ? groupByRules() : null)
                .add("SortOrder", sortOrderAsString()).add("MaxStatisticResults", maxStatisticResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupByRules":
            return Optional.ofNullable(clazz.cast(groupByRules()));
        case "SortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        case "MaxStatisticResults":
            return Optional.ofNullable(clazz.cast(maxStatisticResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GroupByRules", GROUP_BY_RULES_FIELD);
        map.put("SortOrder", SORT_ORDER_FIELD);
        map.put("MaxStatisticResults", MAX_STATISTIC_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetResourcesStatisticsV2Request, T> g) {
        return obj -> g.apply((GetResourcesStatisticsV2Request) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SecurityHubRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetResourcesStatisticsV2Request> {
        /**
         * <p>
         * How resource statistics should be aggregated and organized in the response.
         * </p>
         * 
         * @param groupByRules
         *        How resource statistics should be aggregated and organized in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupByRules(Collection<ResourceGroupByRule> groupByRules);

        /**
         * <p>
         * How resource statistics should be aggregated and organized in the response.
         * </p>
         * 
         * @param groupByRules
         *        How resource statistics should be aggregated and organized in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupByRules(ResourceGroupByRule... groupByRules);

        /**
         * <p>
         * How resource statistics should be aggregated and organized in the response.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.ResourceGroupByRule.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.ResourceGroupByRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.ResourceGroupByRule.Builder#build()} is called
         * immediately and its result is passed to {@link #groupByRules(List<ResourceGroupByRule>)}.
         * 
         * @param groupByRules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.ResourceGroupByRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groupByRules(java.util.Collection<ResourceGroupByRule>)
         */
        Builder groupByRules(Consumer<ResourceGroupByRule.Builder>... groupByRules);

        /**
         * <p>
         * Sorts aggregated statistics.
         * </p>
         * 
         * @param sortOrder
         *        Sorts aggregated statistics.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * Sorts aggregated statistics.
         * </p>
         * 
         * @param sortOrder
         *        Sorts aggregated statistics.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(SortOrder sortOrder);

        /**
         * <p>
         * The maximum number of results to be returned.
         * </p>
         * 
         * @param maxStatisticResults
         *        The maximum number of results to be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxStatisticResults(Integer maxStatisticResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecurityHubRequest.BuilderImpl implements Builder {
        private List<ResourceGroupByRule> groupByRules = DefaultSdkAutoConstructList.getInstance();

        private String sortOrder;

        private Integer maxStatisticResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourcesStatisticsV2Request model) {
            super(model);
            groupByRules(model.groupByRules);
            sortOrder(model.sortOrder);
            maxStatisticResults(model.maxStatisticResults);
        }

        public final List<ResourceGroupByRule.Builder> getGroupByRules() {
            List<ResourceGroupByRule.Builder> result = ResourceGroupByRulesCopier.copyToBuilder(this.groupByRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupByRules(Collection<ResourceGroupByRule.BuilderImpl> groupByRules) {
            this.groupByRules = ResourceGroupByRulesCopier.copyFromBuilder(groupByRules);
        }

        @Override
        public final Builder groupByRules(Collection<ResourceGroupByRule> groupByRules) {
            this.groupByRules = ResourceGroupByRulesCopier.copy(groupByRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupByRules(ResourceGroupByRule... groupByRules) {
            groupByRules(Arrays.asList(groupByRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupByRules(Consumer<ResourceGroupByRule.Builder>... groupByRules) {
            groupByRules(Stream.of(groupByRules).map(c -> ResourceGroupByRule.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final Integer getMaxStatisticResults() {
            return maxStatisticResults;
        }

        public final void setMaxStatisticResults(Integer maxStatisticResults) {
            this.maxStatisticResults = maxStatisticResults;
        }

        @Override
        public final Builder maxStatisticResults(Integer maxStatisticResults) {
            this.maxStatisticResults = maxStatisticResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetResourcesStatisticsV2Request build() {
            return new GetResourcesStatisticsV2Request(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
