/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetConnectorV2Response extends SecurityHubResponse implements
        ToCopyableBuilder<GetConnectorV2Response.Builder, GetConnectorV2Response> {
    private static final SdkField<String> CONNECTOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectorArn").getter(getter(GetConnectorV2Response::connectorArn))
            .setter(setter(Builder::connectorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorArn").build()).build();

    private static final SdkField<String> CONNECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectorId").getter(getter(GetConnectorV2Response::connectorId)).setter(setter(Builder::connectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GetConnectorV2Response::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(GetConnectorV2Response::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyArn").getter(getter(GetConnectorV2Response::kmsKeyArn)).setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyArn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt")
            .getter(getter(GetConnectorV2Response::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedAt")
            .getter(getter(GetConnectorV2Response::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<HealthCheck> HEALTH_FIELD = SdkField.<HealthCheck> builder(MarshallingType.SDK_POJO)
            .memberName("Health").getter(getter(GetConnectorV2Response::health)).setter(setter(Builder::health))
            .constructor(HealthCheck::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Health").build()).build();

    private static final SdkField<ProviderDetail> PROVIDER_DETAIL_FIELD = SdkField
            .<ProviderDetail> builder(MarshallingType.SDK_POJO).memberName("ProviderDetail")
            .getter(getter(GetConnectorV2Response::providerDetail)).setter(setter(Builder::providerDetail))
            .constructor(ProviderDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProviderDetail").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_ARN_FIELD,
            CONNECTOR_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, KMS_KEY_ARN_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD,
            HEALTH_FIELD, PROVIDER_DETAIL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String connectorArn;

    private final String connectorId;

    private final String name;

    private final String description;

    private final String kmsKeyArn;

    private final Instant createdAt;

    private final Instant lastUpdatedAt;

    private final HealthCheck health;

    private final ProviderDetail providerDetail;

    private GetConnectorV2Response(BuilderImpl builder) {
        super(builder);
        this.connectorArn = builder.connectorArn;
        this.connectorId = builder.connectorId;
        this.name = builder.name;
        this.description = builder.description;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.health = builder.health;
        this.providerDetail = builder.providerDetail;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the connectorV2.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the connectorV2.
     */
    public final String connectorArn() {
        return connectorArn;
    }

    /**
     * <p>
     * The UUID of the connectorV2 to identify connectorV2 resource.
     * </p>
     * 
     * @return The UUID of the connectorV2 to identify connectorV2 resource.
     */
    public final String connectorId() {
        return connectorId;
    }

    /**
     * <p>
     * The name of the connectorV2.
     * </p>
     * 
     * @return The name of the connectorV2.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the connectorV2.
     * </p>
     * 
     * @return The description of the connectorV2.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of KMS key used for the connectorV2.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of KMS key used for the connectorV2.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    /**
     * <p>
     * ISO 8601 UTC timestamp for the time create the connectorV2.
     * </p>
     * 
     * @return ISO 8601 UTC timestamp for the time create the connectorV2.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * ISO 8601 UTC timestamp for the time update the connectorV2 connectorStatus.
     * </p>
     * 
     * @return ISO 8601 UTC timestamp for the time update the connectorV2 connectorStatus.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * The current health status for connectorV2
     * </p>
     * 
     * @return The current health status for connectorV2
     */
    public final HealthCheck health() {
        return health;
    }

    /**
     * <p>
     * The third-party provider detail for a service configuration.
     * </p>
     * 
     * @return The third-party provider detail for a service configuration.
     */
    public final ProviderDetail providerDetail() {
        return providerDetail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(connectorArn());
        hashCode = 31 * hashCode + Objects.hashCode(connectorId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(health());
        hashCode = 31 * hashCode + Objects.hashCode(providerDetail());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConnectorV2Response)) {
            return false;
        }
        GetConnectorV2Response other = (GetConnectorV2Response) obj;
        return Objects.equals(connectorArn(), other.connectorArn()) && Objects.equals(connectorId(), other.connectorId())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(kmsKeyArn(), other.kmsKeyArn()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(health(), other.health())
                && Objects.equals(providerDetail(), other.providerDetail());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetConnectorV2Response").add("ConnectorArn", connectorArn()).add("ConnectorId", connectorId())
                .add("Name", name()).add("Description", description()).add("KmsKeyArn", kmsKeyArn())
                .add("CreatedAt", createdAt()).add("LastUpdatedAt", lastUpdatedAt()).add("Health", health())
                .add("ProviderDetail", providerDetail()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectorArn":
            return Optional.ofNullable(clazz.cast(connectorArn()));
        case "ConnectorId":
            return Optional.ofNullable(clazz.cast(connectorId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "KmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "LastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "Health":
            return Optional.ofNullable(clazz.cast(health()));
        case "ProviderDetail":
            return Optional.ofNullable(clazz.cast(providerDetail()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConnectorArn", CONNECTOR_ARN_FIELD);
        map.put("ConnectorId", CONNECTOR_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("KmsKeyArn", KMS_KEY_ARN_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("LastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("Health", HEALTH_FIELD);
        map.put("ProviderDetail", PROVIDER_DETAIL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetConnectorV2Response, T> g) {
        return obj -> g.apply((GetConnectorV2Response) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SecurityHubResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetConnectorV2Response> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the connectorV2.
         * </p>
         * 
         * @param connectorArn
         *        The Amazon Resource Name (ARN) of the connectorV2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorArn(String connectorArn);

        /**
         * <p>
         * The UUID of the connectorV2 to identify connectorV2 resource.
         * </p>
         * 
         * @param connectorId
         *        The UUID of the connectorV2 to identify connectorV2 resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorId(String connectorId);

        /**
         * <p>
         * The name of the connectorV2.
         * </p>
         * 
         * @param name
         *        The name of the connectorV2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the connectorV2.
         * </p>
         * 
         * @param description
         *        The description of the connectorV2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of KMS key used for the connectorV2.
         * </p>
         * 
         * @param kmsKeyArn
         *        The Amazon Resource Name (ARN) of KMS key used for the connectorV2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);

        /**
         * <p>
         * ISO 8601 UTC timestamp for the time create the connectorV2.
         * </p>
         * 
         * @param createdAt
         *        ISO 8601 UTC timestamp for the time create the connectorV2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * ISO 8601 UTC timestamp for the time update the connectorV2 connectorStatus.
         * </p>
         * 
         * @param lastUpdatedAt
         *        ISO 8601 UTC timestamp for the time update the connectorV2 connectorStatus.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * The current health status for connectorV2
         * </p>
         * 
         * @param health
         *        The current health status for connectorV2
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder health(HealthCheck health);

        /**
         * <p>
         * The current health status for connectorV2
         * </p>
         * This is a convenience method that creates an instance of the {@link HealthCheck.Builder} avoiding the need to
         * create one manually via {@link HealthCheck#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HealthCheck.Builder#build()} is called immediately and its result
         * is passed to {@link #health(HealthCheck)}.
         * 
         * @param health
         *        a consumer that will call methods on {@link HealthCheck.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #health(HealthCheck)
         */
        default Builder health(Consumer<HealthCheck.Builder> health) {
            return health(HealthCheck.builder().applyMutation(health).build());
        }

        /**
         * <p>
         * The third-party provider detail for a service configuration.
         * </p>
         * 
         * @param providerDetail
         *        The third-party provider detail for a service configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerDetail(ProviderDetail providerDetail);

        /**
         * <p>
         * The third-party provider detail for a service configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProviderDetail.Builder} avoiding the need
         * to create one manually via {@link ProviderDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProviderDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #providerDetail(ProviderDetail)}.
         * 
         * @param providerDetail
         *        a consumer that will call methods on {@link ProviderDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #providerDetail(ProviderDetail)
         */
        default Builder providerDetail(Consumer<ProviderDetail.Builder> providerDetail) {
            return providerDetail(ProviderDetail.builder().applyMutation(providerDetail).build());
        }
    }

    static final class BuilderImpl extends SecurityHubResponse.BuilderImpl implements Builder {
        private String connectorArn;

        private String connectorId;

        private String name;

        private String description;

        private String kmsKeyArn;

        private Instant createdAt;

        private Instant lastUpdatedAt;

        private HealthCheck health;

        private ProviderDetail providerDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConnectorV2Response model) {
            super(model);
            connectorArn(model.connectorArn);
            connectorId(model.connectorId);
            name(model.name);
            description(model.description);
            kmsKeyArn(model.kmsKeyArn);
            createdAt(model.createdAt);
            lastUpdatedAt(model.lastUpdatedAt);
            health(model.health);
            providerDetail(model.providerDetail);
        }

        public final String getConnectorArn() {
            return connectorArn;
        }

        public final void setConnectorArn(String connectorArn) {
            this.connectorArn = connectorArn;
        }

        @Override
        public final Builder connectorArn(String connectorArn) {
            this.connectorArn = connectorArn;
            return this;
        }

        public final String getConnectorId() {
            return connectorId;
        }

        public final void setConnectorId(String connectorId) {
            this.connectorId = connectorId;
        }

        @Override
        public final Builder connectorId(String connectorId) {
            this.connectorId = connectorId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final HealthCheck.Builder getHealth() {
            return health != null ? health.toBuilder() : null;
        }

        public final void setHealth(HealthCheck.BuilderImpl health) {
            this.health = health != null ? health.build() : null;
        }

        @Override
        public final Builder health(HealthCheck health) {
            this.health = health;
            return this;
        }

        public final ProviderDetail.Builder getProviderDetail() {
            return providerDetail != null ? providerDetail.toBuilder() : null;
        }

        public final void setProviderDetail(ProviderDetail.BuilderImpl providerDetail) {
            this.providerDetail = providerDetail != null ? providerDetail.build() : null;
        }

        @Override
        public final Builder providerDetail(ProviderDetail providerDetail) {
            this.providerDetail = providerDetail;
            return this;
        }

        @Override
        public GetConnectorV2Response build() {
            return new GetConnectorV2Response(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
