/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A filter for string-based fields in findings trend data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FindingsTrendsStringFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<FindingsTrendsStringFilter.Builder, FindingsTrendsStringFilter> {
    private static final SdkField<String> FIELD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FieldName").getter(getter(FindingsTrendsStringFilter::fieldNameAsString))
            .setter(setter(Builder::fieldName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldName").build()).build();

    private static final SdkField<StringFilter> FILTER_FIELD = SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
            .memberName("Filter").getter(getter(FindingsTrendsStringFilter::filter)).setter(setter(Builder::filter))
            .constructor(StringFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(FIELD_NAME_FIELD, FILTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String fieldName;

    private final StringFilter filter;

    private FindingsTrendsStringFilter(BuilderImpl builder) {
        this.fieldName = builder.fieldName;
        this.filter = builder.filter;
    }

    /**
     * <p>
     * The name of the findings field to filter on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fieldName} will
     * return {@link FindingsTrendsStringField#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #fieldNameAsString}.
     * </p>
     * 
     * @return The name of the findings field to filter on.
     * @see FindingsTrendsStringField
     */
    public final FindingsTrendsStringField fieldName() {
        return FindingsTrendsStringField.fromValue(fieldName);
    }

    /**
     * <p>
     * The name of the findings field to filter on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fieldName} will
     * return {@link FindingsTrendsStringField#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #fieldNameAsString}.
     * </p>
     * 
     * @return The name of the findings field to filter on.
     * @see FindingsTrendsStringField
     */
    public final String fieldNameAsString() {
        return fieldName;
    }

    /**
     * Returns the value of the Filter property for this object.
     * 
     * @return The value of the Filter property for this object.
     */
    public final StringFilter filter() {
        return filter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FindingsTrendsStringFilter)) {
            return false;
        }
        FindingsTrendsStringFilter other = (FindingsTrendsStringFilter) obj;
        return Objects.equals(fieldNameAsString(), other.fieldNameAsString()) && Objects.equals(filter(), other.filter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FindingsTrendsStringFilter").add("FieldName", fieldNameAsString()).add("Filter", filter())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldName":
            return Optional.ofNullable(clazz.cast(fieldNameAsString()));
        case "Filter":
            return Optional.ofNullable(clazz.cast(filter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FieldName", FIELD_NAME_FIELD);
        map.put("Filter", FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FindingsTrendsStringFilter, T> g) {
        return obj -> g.apply((FindingsTrendsStringFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FindingsTrendsStringFilter> {
        /**
         * <p>
         * The name of the findings field to filter on.
         * </p>
         * 
         * @param fieldName
         *        The name of the findings field to filter on.
         * @see FindingsTrendsStringField
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FindingsTrendsStringField
         */
        Builder fieldName(String fieldName);

        /**
         * <p>
         * The name of the findings field to filter on.
         * </p>
         * 
         * @param fieldName
         *        The name of the findings field to filter on.
         * @see FindingsTrendsStringField
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FindingsTrendsStringField
         */
        Builder fieldName(FindingsTrendsStringField fieldName);

        /**
         * Sets the value of the Filter property for this object.
         *
         * @param filter
         *        The new value for the Filter property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(StringFilter filter);

        /**
         * Sets the value of the Filter property for this object.
         *
         * This is a convenience method that creates an instance of the {@link StringFilter.Builder} avoiding the need
         * to create one manually via {@link StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StringFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #filter(StringFilter)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(StringFilter)
         */
        default Builder filter(Consumer<StringFilter.Builder> filter) {
            return filter(StringFilter.builder().applyMutation(filter).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String fieldName;

        private StringFilter filter;

        private BuilderImpl() {
        }

        private BuilderImpl(FindingsTrendsStringFilter model) {
            fieldName(model.fieldName);
            filter(model.filter);
        }

        public final String getFieldName() {
            return fieldName;
        }

        public final void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public final Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        @Override
        public final Builder fieldName(FindingsTrendsStringField fieldName) {
            this.fieldName(fieldName == null ? null : fieldName.toString());
            return this;
        }

        public final StringFilter.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        public final void setFilter(StringFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(StringFilter filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public FindingsTrendsStringFilter build() {
            return new FindingsTrendsStringFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
