/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure that defines filters to apply to findings trend data queries.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FindingsTrendsFilters implements SdkPojo, Serializable,
        ToCopyableBuilder<FindingsTrendsFilters.Builder, FindingsTrendsFilters> {
    private static final SdkField<List<FindingsTrendsCompositeFilter>> COMPOSITE_FILTERS_FIELD = SdkField
            .<List<FindingsTrendsCompositeFilter>> builder(MarshallingType.LIST)
            .memberName("CompositeFilters")
            .getter(getter(FindingsTrendsFilters::compositeFilters))
            .setter(setter(Builder::compositeFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompositeFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FindingsTrendsCompositeFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(FindingsTrendsCompositeFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> COMPOSITE_OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CompositeOperator").getter(getter(FindingsTrendsFilters::compositeOperatorAsString))
            .setter(setter(Builder::compositeOperator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompositeOperator").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPOSITE_FILTERS_FIELD,
            COMPOSITE_OPERATOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<FindingsTrendsCompositeFilter> compositeFilters;

    private final String compositeOperator;

    private FindingsTrendsFilters(BuilderImpl builder) {
        this.compositeFilters = builder.compositeFilters;
        this.compositeOperator = builder.compositeOperator;
    }

    /**
     * For responses, this returns true if the service returned a value for the CompositeFilters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCompositeFilters() {
        return compositeFilters != null && !(compositeFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of composite filters to apply to the findings trend data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCompositeFilters} method.
     * </p>
     * 
     * @return A list of composite filters to apply to the findings trend data.
     */
    public final List<FindingsTrendsCompositeFilter> compositeFilters() {
        return compositeFilters;
    }

    /**
     * <p>
     * The logical operator (AND, OR) to apply between multiple composite filters.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #compositeOperator}
     * will return {@link AllowedOperators#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #compositeOperatorAsString}.
     * </p>
     * 
     * @return The logical operator (AND, OR) to apply between multiple composite filters.
     * @see AllowedOperators
     */
    public final AllowedOperators compositeOperator() {
        return AllowedOperators.fromValue(compositeOperator);
    }

    /**
     * <p>
     * The logical operator (AND, OR) to apply between multiple composite filters.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #compositeOperator}
     * will return {@link AllowedOperators#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #compositeOperatorAsString}.
     * </p>
     * 
     * @return The logical operator (AND, OR) to apply between multiple composite filters.
     * @see AllowedOperators
     */
    public final String compositeOperatorAsString() {
        return compositeOperator;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCompositeFilters() ? compositeFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(compositeOperatorAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FindingsTrendsFilters)) {
            return false;
        }
        FindingsTrendsFilters other = (FindingsTrendsFilters) obj;
        return hasCompositeFilters() == other.hasCompositeFilters()
                && Objects.equals(compositeFilters(), other.compositeFilters())
                && Objects.equals(compositeOperatorAsString(), other.compositeOperatorAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FindingsTrendsFilters")
                .add("CompositeFilters", hasCompositeFilters() ? compositeFilters() : null)
                .add("CompositeOperator", compositeOperatorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CompositeFilters":
            return Optional.ofNullable(clazz.cast(compositeFilters()));
        case "CompositeOperator":
            return Optional.ofNullable(clazz.cast(compositeOperatorAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CompositeFilters", COMPOSITE_FILTERS_FIELD);
        map.put("CompositeOperator", COMPOSITE_OPERATOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FindingsTrendsFilters, T> g) {
        return obj -> g.apply((FindingsTrendsFilters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FindingsTrendsFilters> {
        /**
         * <p>
         * A list of composite filters to apply to the findings trend data.
         * </p>
         * 
         * @param compositeFilters
         *        A list of composite filters to apply to the findings trend data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compositeFilters(Collection<FindingsTrendsCompositeFilter> compositeFilters);

        /**
         * <p>
         * A list of composite filters to apply to the findings trend data.
         * </p>
         * 
         * @param compositeFilters
         *        A list of composite filters to apply to the findings trend data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compositeFilters(FindingsTrendsCompositeFilter... compositeFilters);

        /**
         * <p>
         * A list of composite filters to apply to the findings trend data.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.FindingsTrendsCompositeFilter.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.FindingsTrendsCompositeFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.FindingsTrendsCompositeFilter.Builder#build()} is
         * called immediately and its result is passed to {@link #compositeFilters(List<FindingsTrendsCompositeFilter>)}.
         * 
         * @param compositeFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.FindingsTrendsCompositeFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #compositeFilters(java.util.Collection<FindingsTrendsCompositeFilter>)
         */
        Builder compositeFilters(Consumer<FindingsTrendsCompositeFilter.Builder>... compositeFilters);

        /**
         * <p>
         * The logical operator (AND, OR) to apply between multiple composite filters.
         * </p>
         * 
         * @param compositeOperator
         *        The logical operator (AND, OR) to apply between multiple composite filters.
         * @see AllowedOperators
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AllowedOperators
         */
        Builder compositeOperator(String compositeOperator);

        /**
         * <p>
         * The logical operator (AND, OR) to apply between multiple composite filters.
         * </p>
         * 
         * @param compositeOperator
         *        The logical operator (AND, OR) to apply between multiple composite filters.
         * @see AllowedOperators
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AllowedOperators
         */
        Builder compositeOperator(AllowedOperators compositeOperator);
    }

    static final class BuilderImpl implements Builder {
        private List<FindingsTrendsCompositeFilter> compositeFilters = DefaultSdkAutoConstructList.getInstance();

        private String compositeOperator;

        private BuilderImpl() {
        }

        private BuilderImpl(FindingsTrendsFilters model) {
            compositeFilters(model.compositeFilters);
            compositeOperator(model.compositeOperator);
        }

        public final List<FindingsTrendsCompositeFilter.Builder> getCompositeFilters() {
            List<FindingsTrendsCompositeFilter.Builder> result = FindingsTrendsCompositeFilterListCopier
                    .copyToBuilder(this.compositeFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCompositeFilters(Collection<FindingsTrendsCompositeFilter.BuilderImpl> compositeFilters) {
            this.compositeFilters = FindingsTrendsCompositeFilterListCopier.copyFromBuilder(compositeFilters);
        }

        @Override
        public final Builder compositeFilters(Collection<FindingsTrendsCompositeFilter> compositeFilters) {
            this.compositeFilters = FindingsTrendsCompositeFilterListCopier.copy(compositeFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compositeFilters(FindingsTrendsCompositeFilter... compositeFilters) {
            compositeFilters(Arrays.asList(compositeFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compositeFilters(Consumer<FindingsTrendsCompositeFilter.Builder>... compositeFilters) {
            compositeFilters(Stream.of(compositeFilters)
                    .map(c -> FindingsTrendsCompositeFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getCompositeOperator() {
            return compositeOperator;
        }

        public final void setCompositeOperator(String compositeOperator) {
            this.compositeOperator = compositeOperator;
        }

        @Override
        public final Builder compositeOperator(String compositeOperator) {
            this.compositeOperator = compositeOperator;
            return this;
        }

        @Override
        public final Builder compositeOperator(AllowedOperators compositeOperator) {
            this.compositeOperator(compositeOperator == null ? null : compositeOperator.toString());
            return this;
        }

        @Override
        public FindingsTrendsFilters build() {
            return new FindingsTrendsFilters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
