/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A filter structure that contains a logical combination of string filters and nested composite filters for findings
 * trend data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FindingsTrendsCompositeFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<FindingsTrendsCompositeFilter.Builder, FindingsTrendsCompositeFilter> {
    private static final SdkField<List<FindingsTrendsStringFilter>> STRING_FILTERS_FIELD = SdkField
            .<List<FindingsTrendsStringFilter>> builder(MarshallingType.LIST)
            .memberName("StringFilters")
            .getter(getter(FindingsTrendsCompositeFilter::stringFilters))
            .setter(setter(Builder::stringFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FindingsTrendsStringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(FindingsTrendsStringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<FindingsTrendsCompositeFilter>> NESTED_COMPOSITE_FILTERS_FIELD = SdkField
            .<List<FindingsTrendsCompositeFilter>> builder(MarshallingType.LIST)
            .memberName("NestedCompositeFilters")
            .getter(getter(FindingsTrendsCompositeFilter::nestedCompositeFilters))
            .setter(setter(Builder::nestedCompositeFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NestedCompositeFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FindingsTrendsCompositeFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(FindingsTrendsCompositeFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Operator").getter(getter(FindingsTrendsCompositeFilter::operatorAsString))
            .setter(setter(Builder::operator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operator").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STRING_FILTERS_FIELD,
            NESTED_COMPOSITE_FILTERS_FIELD, OPERATOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<FindingsTrendsStringFilter> stringFilters;

    private final List<FindingsTrendsCompositeFilter> nestedCompositeFilters;

    private final String operator;

    private FindingsTrendsCompositeFilter(BuilderImpl builder) {
        this.stringFilters = builder.stringFilters;
        this.nestedCompositeFilters = builder.nestedCompositeFilters;
        this.operator = builder.operator;
    }

    /**
     * For responses, this returns true if the service returned a value for the StringFilters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStringFilters() {
        return stringFilters != null && !(stringFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of string filters that apply to findings trend data fields.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStringFilters} method.
     * </p>
     * 
     * @return A list of string filters that apply to findings trend data fields.
     */
    public final List<FindingsTrendsStringFilter> stringFilters() {
        return stringFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the NestedCompositeFilters property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasNestedCompositeFilters() {
        return nestedCompositeFilters != null && !(nestedCompositeFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of nested composite filters that you can use to create complex filter conditions for findings trend data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNestedCompositeFilters} method.
     * </p>
     * 
     * @return A list of nested composite filters that you can use to create complex filter conditions for findings
     *         trend data.
     */
    public final List<FindingsTrendsCompositeFilter> nestedCompositeFilters() {
        return nestedCompositeFilters;
    }

    /**
     * <p>
     * The logical operator (AND, OR) to apply between the string filters and nested composite filters.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operator} will
     * return {@link AllowedOperators#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #operatorAsString}.
     * </p>
     * 
     * @return The logical operator (AND, OR) to apply between the string filters and nested composite filters.
     * @see AllowedOperators
     */
    public final AllowedOperators operator() {
        return AllowedOperators.fromValue(operator);
    }

    /**
     * <p>
     * The logical operator (AND, OR) to apply between the string filters and nested composite filters.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operator} will
     * return {@link AllowedOperators#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #operatorAsString}.
     * </p>
     * 
     * @return The logical operator (AND, OR) to apply between the string filters and nested composite filters.
     * @see AllowedOperators
     */
    public final String operatorAsString() {
        return operator;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasStringFilters() ? stringFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNestedCompositeFilters() ? nestedCompositeFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(operatorAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FindingsTrendsCompositeFilter)) {
            return false;
        }
        FindingsTrendsCompositeFilter other = (FindingsTrendsCompositeFilter) obj;
        return hasStringFilters() == other.hasStringFilters() && Objects.equals(stringFilters(), other.stringFilters())
                && hasNestedCompositeFilters() == other.hasNestedCompositeFilters()
                && Objects.equals(nestedCompositeFilters(), other.nestedCompositeFilters())
                && Objects.equals(operatorAsString(), other.operatorAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FindingsTrendsCompositeFilter")
                .add("StringFilters", hasStringFilters() ? stringFilters() : null)
                .add("NestedCompositeFilters", hasNestedCompositeFilters() ? nestedCompositeFilters() : null)
                .add("Operator", operatorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StringFilters":
            return Optional.ofNullable(clazz.cast(stringFilters()));
        case "NestedCompositeFilters":
            return Optional.ofNullable(clazz.cast(nestedCompositeFilters()));
        case "Operator":
            return Optional.ofNullable(clazz.cast(operatorAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StringFilters", STRING_FILTERS_FIELD);
        map.put("NestedCompositeFilters", NESTED_COMPOSITE_FILTERS_FIELD);
        map.put("Operator", OPERATOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FindingsTrendsCompositeFilter, T> g) {
        return obj -> g.apply((FindingsTrendsCompositeFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FindingsTrendsCompositeFilter> {
        /**
         * <p>
         * A list of string filters that apply to findings trend data fields.
         * </p>
         * 
         * @param stringFilters
         *        A list of string filters that apply to findings trend data fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringFilters(Collection<FindingsTrendsStringFilter> stringFilters);

        /**
         * <p>
         * A list of string filters that apply to findings trend data fields.
         * </p>
         * 
         * @param stringFilters
         *        A list of string filters that apply to findings trend data fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringFilters(FindingsTrendsStringFilter... stringFilters);

        /**
         * <p>
         * A list of string filters that apply to findings trend data fields.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.FindingsTrendsStringFilter.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.FindingsTrendsStringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.FindingsTrendsStringFilter.Builder#build()} is
         * called immediately and its result is passed to {@link #stringFilters(List<FindingsTrendsStringFilter>)}.
         * 
         * @param stringFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.FindingsTrendsStringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stringFilters(java.util.Collection<FindingsTrendsStringFilter>)
         */
        Builder stringFilters(Consumer<FindingsTrendsStringFilter.Builder>... stringFilters);

        /**
         * <p>
         * A list of nested composite filters that you can use to create complex filter conditions for findings trend
         * data.
         * </p>
         * 
         * @param nestedCompositeFilters
         *        A list of nested composite filters that you can use to create complex filter conditions for findings
         *        trend data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nestedCompositeFilters(Collection<FindingsTrendsCompositeFilter> nestedCompositeFilters);

        /**
         * <p>
         * A list of nested composite filters that you can use to create complex filter conditions for findings trend
         * data.
         * </p>
         * 
         * @param nestedCompositeFilters
         *        A list of nested composite filters that you can use to create complex filter conditions for findings
         *        trend data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nestedCompositeFilters(FindingsTrendsCompositeFilter... nestedCompositeFilters);

        /**
         * <p>
         * A list of nested composite filters that you can use to create complex filter conditions for findings trend
         * data.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.FindingsTrendsCompositeFilter.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.FindingsTrendsCompositeFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.FindingsTrendsCompositeFilter.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #nestedCompositeFilters(List<FindingsTrendsCompositeFilter>)}.
         * 
         * @param nestedCompositeFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.FindingsTrendsCompositeFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nestedCompositeFilters(java.util.Collection<FindingsTrendsCompositeFilter>)
         */
        Builder nestedCompositeFilters(Consumer<Builder>... nestedCompositeFilters);

        /**
         * <p>
         * The logical operator (AND, OR) to apply between the string filters and nested composite filters.
         * </p>
         * 
         * @param operator
         *        The logical operator (AND, OR) to apply between the string filters and nested composite filters.
         * @see AllowedOperators
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AllowedOperators
         */
        Builder operator(String operator);

        /**
         * <p>
         * The logical operator (AND, OR) to apply between the string filters and nested composite filters.
         * </p>
         * 
         * @param operator
         *        The logical operator (AND, OR) to apply between the string filters and nested composite filters.
         * @see AllowedOperators
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AllowedOperators
         */
        Builder operator(AllowedOperators operator);
    }

    static final class BuilderImpl implements Builder {
        private List<FindingsTrendsStringFilter> stringFilters = DefaultSdkAutoConstructList.getInstance();

        private List<FindingsTrendsCompositeFilter> nestedCompositeFilters = DefaultSdkAutoConstructList.getInstance();

        private String operator;

        private BuilderImpl() {
        }

        private BuilderImpl(FindingsTrendsCompositeFilter model) {
            stringFilters(model.stringFilters);
            nestedCompositeFilters(model.nestedCompositeFilters);
            operator(model.operator);
        }

        public final List<FindingsTrendsStringFilter.Builder> getStringFilters() {
            List<FindingsTrendsStringFilter.Builder> result = FindingsTrendsStringFilterListCopier
                    .copyToBuilder(this.stringFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStringFilters(Collection<FindingsTrendsStringFilter.BuilderImpl> stringFilters) {
            this.stringFilters = FindingsTrendsStringFilterListCopier.copyFromBuilder(stringFilters);
        }

        @Override
        public final Builder stringFilters(Collection<FindingsTrendsStringFilter> stringFilters) {
            this.stringFilters = FindingsTrendsStringFilterListCopier.copy(stringFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stringFilters(FindingsTrendsStringFilter... stringFilters) {
            stringFilters(Arrays.asList(stringFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stringFilters(Consumer<FindingsTrendsStringFilter.Builder>... stringFilters) {
            stringFilters(Stream.of(stringFilters).map(c -> FindingsTrendsStringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<Builder> getNestedCompositeFilters() {
            List<Builder> result = FindingsTrendsCompositeFilterListCopier.copyToBuilder(this.nestedCompositeFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNestedCompositeFilters(Collection<BuilderImpl> nestedCompositeFilters) {
            this.nestedCompositeFilters = FindingsTrendsCompositeFilterListCopier.copyFromBuilder(nestedCompositeFilters);
        }

        @Override
        public final Builder nestedCompositeFilters(Collection<FindingsTrendsCompositeFilter> nestedCompositeFilters) {
            this.nestedCompositeFilters = FindingsTrendsCompositeFilterListCopier.copy(nestedCompositeFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nestedCompositeFilters(FindingsTrendsCompositeFilter... nestedCompositeFilters) {
            nestedCompositeFilters(Arrays.asList(nestedCompositeFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nestedCompositeFilters(Consumer<Builder>... nestedCompositeFilters) {
            nestedCompositeFilters(Stream.of(nestedCompositeFilters)
                    .map(c -> FindingsTrendsCompositeFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getOperator() {
            return operator;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        @Override
        public final Builder operator(AllowedOperators operator) {
            this.operator(operator == null ? null : operator.toString());
            return this;
        }

        @Override
        public FindingsTrendsCompositeFilter build() {
            return new FindingsTrendsCompositeFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
