/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnableOrganizationAdminAccountRequest extends SecurityHubRequest implements
        ToCopyableBuilder<EnableOrganizationAdminAccountRequest.Builder, EnableOrganizationAdminAccountRequest> {
    private static final SdkField<String> ADMIN_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AdminAccountId").getter(getter(EnableOrganizationAdminAccountRequest::adminAccountId))
            .setter(setter(Builder::adminAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdminAccountId").build()).build();

    private static final SdkField<String> FEATURE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Feature")
            .getter(getter(EnableOrganizationAdminAccountRequest::featureAsString)).setter(setter(Builder::feature))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Feature").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADMIN_ACCOUNT_ID_FIELD,
            FEATURE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String adminAccountId;

    private final String feature;

    private EnableOrganizationAdminAccountRequest(BuilderImpl builder) {
        super(builder);
        this.adminAccountId = builder.adminAccountId;
        this.feature = builder.feature;
    }

    /**
     * <p>
     * The Amazon Web Services account identifier of the account to designate as the Security Hub administrator account.
     * </p>
     * 
     * @return The Amazon Web Services account identifier of the account to designate as the Security Hub administrator
     *         account.
     */
    public final String adminAccountId() {
        return adminAccountId;
    }

    /**
     * <p>
     * The feature for which the delegated admin account is enabled. Defaults to Security Hub if not specified.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #feature} will
     * return {@link SecurityHubFeature#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #featureAsString}.
     * </p>
     * 
     * @return The feature for which the delegated admin account is enabled. Defaults to Security Hub if not specified.
     * @see SecurityHubFeature
     */
    public final SecurityHubFeature feature() {
        return SecurityHubFeature.fromValue(feature);
    }

    /**
     * <p>
     * The feature for which the delegated admin account is enabled. Defaults to Security Hub if not specified.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #feature} will
     * return {@link SecurityHubFeature#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #featureAsString}.
     * </p>
     * 
     * @return The feature for which the delegated admin account is enabled. Defaults to Security Hub if not specified.
     * @see SecurityHubFeature
     */
    public final String featureAsString() {
        return feature;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(adminAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(featureAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableOrganizationAdminAccountRequest)) {
            return false;
        }
        EnableOrganizationAdminAccountRequest other = (EnableOrganizationAdminAccountRequest) obj;
        return Objects.equals(adminAccountId(), other.adminAccountId())
                && Objects.equals(featureAsString(), other.featureAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnableOrganizationAdminAccountRequest").add("AdminAccountId", adminAccountId())
                .add("Feature", featureAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdminAccountId":
            return Optional.ofNullable(clazz.cast(adminAccountId()));
        case "Feature":
            return Optional.ofNullable(clazz.cast(featureAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AdminAccountId", ADMIN_ACCOUNT_ID_FIELD);
        map.put("Feature", FEATURE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnableOrganizationAdminAccountRequest, T> g) {
        return obj -> g.apply((EnableOrganizationAdminAccountRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SecurityHubRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, EnableOrganizationAdminAccountRequest> {
        /**
         * <p>
         * The Amazon Web Services account identifier of the account to designate as the Security Hub administrator
         * account.
         * </p>
         * 
         * @param adminAccountId
         *        The Amazon Web Services account identifier of the account to designate as the Security Hub
         *        administrator account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adminAccountId(String adminAccountId);

        /**
         * <p>
         * The feature for which the delegated admin account is enabled. Defaults to Security Hub if not specified.
         * </p>
         * 
         * @param feature
         *        The feature for which the delegated admin account is enabled. Defaults to Security Hub if not
         *        specified.
         * @see SecurityHubFeature
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SecurityHubFeature
         */
        Builder feature(String feature);

        /**
         * <p>
         * The feature for which the delegated admin account is enabled. Defaults to Security Hub if not specified.
         * </p>
         * 
         * @param feature
         *        The feature for which the delegated admin account is enabled. Defaults to Security Hub if not
         *        specified.
         * @see SecurityHubFeature
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SecurityHubFeature
         */
        Builder feature(SecurityHubFeature feature);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecurityHubRequest.BuilderImpl implements Builder {
        private String adminAccountId;

        private String feature;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableOrganizationAdminAccountRequest model) {
            super(model);
            adminAccountId(model.adminAccountId);
            feature(model.feature);
        }

        public final String getAdminAccountId() {
            return adminAccountId;
        }

        public final void setAdminAccountId(String adminAccountId) {
            this.adminAccountId = adminAccountId;
        }

        @Override
        public final Builder adminAccountId(String adminAccountId) {
            this.adminAccountId = adminAccountId;
            return this;
        }

        public final String getFeature() {
            return feature;
        }

        public final void setFeature(String feature) {
            this.feature = feature;
        }

        @Override
        public final Builder feature(String feature) {
            this.feature = feature;
            return this;
        }

        @Override
        public final Builder feature(SecurityHubFeature feature) {
            this.feature(feature == null ? null : feature.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public EnableOrganizationAdminAccountRequest build() {
            return new EnableOrganizationAdminAccountRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
