/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A top-level object field that provides details about an Amazon GuardDuty Extended Threat Detection attack sequence.
 * GuardDuty generates an attack sequence finding when multiple events align to a potentially suspicious activity. To
 * receive GuardDuty attack sequence findings in Security Hub, you must have GuardDuty enabled. For more information,
 * see <a href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty-extended-threat-detection.html">GuardDuty
 * Extended Threat Detection </a> in the <i>Amazon GuardDuty User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Detection implements SdkPojo, Serializable, ToCopyableBuilder<Detection.Builder, Detection> {
    private static final SdkField<Sequence> SEQUENCE_FIELD = SdkField.<Sequence> builder(MarshallingType.SDK_POJO)
            .memberName("Sequence").getter(getter(Detection::sequence)).setter(setter(Builder::sequence))
            .constructor(Sequence::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sequence").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEQUENCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Sequence sequence;

    private Detection(BuilderImpl builder) {
        this.sequence = builder.sequence;
    }

    /**
     * <p>
     * Provides details about an attack sequence.
     * </p>
     * 
     * @return Provides details about an attack sequence.
     */
    public final Sequence sequence() {
        return sequence;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sequence());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Detection)) {
            return false;
        }
        Detection other = (Detection) obj;
        return Objects.equals(sequence(), other.sequence());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Detection").add("Sequence", sequence()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Sequence":
            return Optional.ofNullable(clazz.cast(sequence()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Sequence", SEQUENCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Detection, T> g) {
        return obj -> g.apply((Detection) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Detection> {
        /**
         * <p>
         * Provides details about an attack sequence.
         * </p>
         * 
         * @param sequence
         *        Provides details about an attack sequence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sequence(Sequence sequence);

        /**
         * <p>
         * Provides details about an attack sequence.
         * </p>
         * This is a convenience method that creates an instance of the {@link Sequence.Builder} avoiding the need to
         * create one manually via {@link Sequence#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Sequence.Builder#build()} is called immediately and its result is
         * passed to {@link #sequence(Sequence)}.
         * 
         * @param sequence
         *        a consumer that will call methods on {@link Sequence.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sequence(Sequence)
         */
        default Builder sequence(Consumer<Sequence.Builder> sequence) {
            return sequence(Sequence.builder().applyMutation(sequence).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Sequence sequence;

        private BuilderImpl() {
        }

        private BuilderImpl(Detection model) {
            sequence(model.sequence);
        }

        public final Sequence.Builder getSequence() {
            return sequence != null ? sequence.toBuilder() : null;
        }

        public final void setSequence(Sequence.BuilderImpl sequence) {
            this.sequence = sequence != null ? sequence.build() : null;
        }

        @Override
        public final Builder sequence(Sequence sequence) {
            this.sequence = sequence;
            return this;
        }

        @Override
        public Detection build() {
            return new Detection(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
