/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeProductsV2Response extends SecurityHubResponse implements
        ToCopyableBuilder<DescribeProductsV2Response.Builder, DescribeProductsV2Response> {
    private static final SdkField<List<ProductV2>> PRODUCTS_V2_FIELD = SdkField
            .<List<ProductV2>> builder(MarshallingType.LIST)
            .memberName("ProductsV2")
            .getter(getter(DescribeProductsV2Response::productsV2))
            .setter(setter(Builder::productsV2))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductsV2").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProductV2> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProductV2::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeProductsV2Response::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCTS_V2_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ProductV2> productsV2;

    private final String nextToken;

    private DescribeProductsV2Response(BuilderImpl builder) {
        super(builder);
        this.productsV2 = builder.productsV2;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProductsV2 property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasProductsV2() {
        return productsV2 != null && !(productsV2 instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Gets information about the product integration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProductsV2} method.
     * </p>
     * 
     * @return Gets information about the product integration.
     */
    public final List<ProductV2> productsV2() {
        return productsV2;
    }

    /**
     * <p>
     * The pagination token to use to request the next page of results. Otherwise, this parameter is null.
     * </p>
     * 
     * @return The pagination token to use to request the next page of results. Otherwise, this parameter is null.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasProductsV2() ? productsV2() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProductsV2Response)) {
            return false;
        }
        DescribeProductsV2Response other = (DescribeProductsV2Response) obj;
        return hasProductsV2() == other.hasProductsV2() && Objects.equals(productsV2(), other.productsV2())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeProductsV2Response").add("ProductsV2", hasProductsV2() ? productsV2() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProductsV2":
            return Optional.ofNullable(clazz.cast(productsV2()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProductsV2", PRODUCTS_V2_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeProductsV2Response, T> g) {
        return obj -> g.apply((DescribeProductsV2Response) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SecurityHubResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeProductsV2Response> {
        /**
         * <p>
         * Gets information about the product integration.
         * </p>
         * 
         * @param productsV2
         *        Gets information about the product integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productsV2(Collection<ProductV2> productsV2);

        /**
         * <p>
         * Gets information about the product integration.
         * </p>
         * 
         * @param productsV2
         *        Gets information about the product integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productsV2(ProductV2... productsV2);

        /**
         * <p>
         * Gets information about the product integration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.ProductV2.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.securityhub.model.ProductV2#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.ProductV2.Builder#build()} is called immediately and
         * its result is passed to {@link #productsV2(List<ProductV2>)}.
         * 
         * @param productsV2
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.ProductV2.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #productsV2(java.util.Collection<ProductV2>)
         */
        Builder productsV2(Consumer<ProductV2.Builder>... productsV2);

        /**
         * <p>
         * The pagination token to use to request the next page of results. Otherwise, this parameter is null.
         * </p>
         * 
         * @param nextToken
         *        The pagination token to use to request the next page of results. Otherwise, this parameter is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SecurityHubResponse.BuilderImpl implements Builder {
        private List<ProductV2> productsV2 = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProductsV2Response model) {
            super(model);
            productsV2(model.productsV2);
            nextToken(model.nextToken);
        }

        public final List<ProductV2.Builder> getProductsV2() {
            List<ProductV2.Builder> result = ProductsV2ListCopier.copyToBuilder(this.productsV2);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProductsV2(Collection<ProductV2.BuilderImpl> productsV2) {
            this.productsV2 = ProductsV2ListCopier.copyFromBuilder(productsV2);
        }

        @Override
        public final Builder productsV2(Collection<ProductV2> productsV2) {
            this.productsV2 = ProductsV2ListCopier.copy(productsV2);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productsV2(ProductV2... productsV2) {
            productsV2(Arrays.asList(productsV2));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productsV2(Consumer<ProductV2.Builder>... productsV2) {
            productsV2(Stream.of(productsV2).map(c -> ProductV2.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeProductsV2Response build() {
            return new DescribeProductsV2Response(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
