/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains an instance of sensitive data that was detected by a customer-defined identifier.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomDataIdentifiersResult implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomDataIdentifiersResult.Builder, CustomDataIdentifiersResult> {
    private static final SdkField<List<CustomDataIdentifiersDetections>> DETECTIONS_FIELD = SdkField
            .<List<CustomDataIdentifiersDetections>> builder(MarshallingType.LIST)
            .memberName("Detections")
            .getter(getter(CustomDataIdentifiersResult::detections))
            .setter(setter(Builder::detections))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Detections").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CustomDataIdentifiersDetections> builder(MarshallingType.SDK_POJO)
                                            .constructor(CustomDataIdentifiersDetections::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Long> TOTAL_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("TotalCount").getter(getter(CustomDataIdentifiersResult::totalCount)).setter(setter(Builder::totalCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTIONS_FIELD,
            TOTAL_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<CustomDataIdentifiersDetections> detections;

    private final Long totalCount;

    private CustomDataIdentifiersResult(BuilderImpl builder) {
        this.detections = builder.detections;
        this.totalCount = builder.totalCount;
    }

    /**
     * For responses, this returns true if the service returned a value for the Detections property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDetections() {
        return detections != null && !(detections instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of detected instances of sensitive data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDetections} method.
     * </p>
     * 
     * @return The list of detected instances of sensitive data.
     */
    public final List<CustomDataIdentifiersDetections> detections() {
        return detections;
    }

    /**
     * <p>
     * The total number of occurrences of sensitive data.
     * </p>
     * 
     * @return The total number of occurrences of sensitive data.
     */
    public final Long totalCount() {
        return totalCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDetections() ? detections() : null);
        hashCode = 31 * hashCode + Objects.hashCode(totalCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomDataIdentifiersResult)) {
            return false;
        }
        CustomDataIdentifiersResult other = (CustomDataIdentifiersResult) obj;
        return hasDetections() == other.hasDetections() && Objects.equals(detections(), other.detections())
                && Objects.equals(totalCount(), other.totalCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomDataIdentifiersResult").add("Detections", hasDetections() ? detections() : null)
                .add("TotalCount", totalCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Detections":
            return Optional.ofNullable(clazz.cast(detections()));
        case "TotalCount":
            return Optional.ofNullable(clazz.cast(totalCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Detections", DETECTIONS_FIELD);
        map.put("TotalCount", TOTAL_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomDataIdentifiersResult, T> g) {
        return obj -> g.apply((CustomDataIdentifiersResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomDataIdentifiersResult> {
        /**
         * <p>
         * The list of detected instances of sensitive data.
         * </p>
         * 
         * @param detections
         *        The list of detected instances of sensitive data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detections(Collection<CustomDataIdentifiersDetections> detections);

        /**
         * <p>
         * The list of detected instances of sensitive data.
         * </p>
         * 
         * @param detections
         *        The list of detected instances of sensitive data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detections(CustomDataIdentifiersDetections... detections);

        /**
         * <p>
         * The list of detected instances of sensitive data.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.CustomDataIdentifiersDetections.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.CustomDataIdentifiersDetections#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.CustomDataIdentifiersDetections.Builder#build()} is
         * called immediately and its result is passed to {@link #detections(List<CustomDataIdentifiersDetections>)}.
         * 
         * @param detections
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.CustomDataIdentifiersDetections.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #detections(java.util.Collection<CustomDataIdentifiersDetections>)
         */
        Builder detections(Consumer<CustomDataIdentifiersDetections.Builder>... detections);

        /**
         * <p>
         * The total number of occurrences of sensitive data.
         * </p>
         * 
         * @param totalCount
         *        The total number of occurrences of sensitive data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalCount(Long totalCount);
    }

    static final class BuilderImpl implements Builder {
        private List<CustomDataIdentifiersDetections> detections = DefaultSdkAutoConstructList.getInstance();

        private Long totalCount;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomDataIdentifiersResult model) {
            detections(model.detections);
            totalCount(model.totalCount);
        }

        public final List<CustomDataIdentifiersDetections.Builder> getDetections() {
            List<CustomDataIdentifiersDetections.Builder> result = CustomDataIdentifiersDetectionsListCopier
                    .copyToBuilder(this.detections);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDetections(Collection<CustomDataIdentifiersDetections.BuilderImpl> detections) {
            this.detections = CustomDataIdentifiersDetectionsListCopier.copyFromBuilder(detections);
        }

        @Override
        public final Builder detections(Collection<CustomDataIdentifiersDetections> detections) {
            this.detections = CustomDataIdentifiersDetectionsListCopier.copy(detections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detections(CustomDataIdentifiersDetections... detections) {
            detections(Arrays.asList(detections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detections(Consumer<CustomDataIdentifiersDetections.Builder>... detections) {
            detections(Stream.of(detections).map(c -> CustomDataIdentifiersDetections.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Long getTotalCount() {
            return totalCount;
        }

        public final void setTotalCount(Long totalCount) {
            this.totalCount = totalCount;
        }

        @Override
        public final Builder totalCount(Long totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        @Override
        public CustomDataIdentifiersResult build() {
            return new CustomDataIdentifiersResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
