/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateInsightRequest extends SecurityHubRequest implements
        ToCopyableBuilder<CreateInsightRequest.Builder, CreateInsightRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateInsightRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<AwsSecurityFindingFilters> FILTERS_FIELD = SdkField
            .<AwsSecurityFindingFilters> builder(MarshallingType.SDK_POJO).memberName("Filters")
            .getter(getter(CreateInsightRequest::filters)).setter(setter(Builder::filters))
            .constructor(AwsSecurityFindingFilters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build()).build();

    private static final SdkField<String> GROUP_BY_ATTRIBUTE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupByAttribute").getter(getter(CreateInsightRequest::groupByAttribute))
            .setter(setter(Builder::groupByAttribute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupByAttribute").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, FILTERS_FIELD,
            GROUP_BY_ATTRIBUTE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final AwsSecurityFindingFilters filters;

    private final String groupByAttribute;

    private CreateInsightRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.filters = builder.filters;
        this.groupByAttribute = builder.groupByAttribute;
    }

    /**
     * <p>
     * The name of the custom insight to create.
     * </p>
     * 
     * @return The name of the custom insight to create.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * One or more attributes used to filter the findings included in the insight. The insight only includes findings
     * that match the criteria defined in the filters.
     * </p>
     * 
     * @return One or more attributes used to filter the findings included in the insight. The insight only includes
     *         findings that match the criteria defined in the filters.
     */
    public final AwsSecurityFindingFilters filters() {
        return filters;
    }

    /**
     * <p>
     * The attribute used to group the findings for the insight. The grouping attribute identifies the type of item that
     * the insight applies to. For example, if an insight is grouped by resource identifier, then the insight produces a
     * list of resource identifiers.
     * </p>
     * 
     * @return The attribute used to group the findings for the insight. The grouping attribute identifies the type of
     *         item that the insight applies to. For example, if an insight is grouped by resource identifier, then the
     *         insight produces a list of resource identifiers.
     */
    public final String groupByAttribute() {
        return groupByAttribute;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(groupByAttribute());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInsightRequest)) {
            return false;
        }
        CreateInsightRequest other = (CreateInsightRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(filters(), other.filters())
                && Objects.equals(groupByAttribute(), other.groupByAttribute());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateInsightRequest").add("Name", name()).add("Filters", filters())
                .add("GroupByAttribute", groupByAttribute()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "GroupByAttribute":
            return Optional.ofNullable(clazz.cast(groupByAttribute()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Filters", FILTERS_FIELD);
        map.put("GroupByAttribute", GROUP_BY_ATTRIBUTE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateInsightRequest, T> g) {
        return obj -> g.apply((CreateInsightRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SecurityHubRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateInsightRequest> {
        /**
         * <p>
         * The name of the custom insight to create.
         * </p>
         * 
         * @param name
         *        The name of the custom insight to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * One or more attributes used to filter the findings included in the insight. The insight only includes
         * findings that match the criteria defined in the filters.
         * </p>
         * 
         * @param filters
         *        One or more attributes used to filter the findings included in the insight. The insight only includes
         *        findings that match the criteria defined in the filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(AwsSecurityFindingFilters filters);

        /**
         * <p>
         * One or more attributes used to filter the findings included in the insight. The insight only includes
         * findings that match the criteria defined in the filters.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsSecurityFindingFilters.Builder}
         * avoiding the need to create one manually via {@link AwsSecurityFindingFilters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsSecurityFindingFilters.Builder#build()} is called immediately
         * and its result is passed to {@link #filters(AwsSecurityFindingFilters)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link AwsSecurityFindingFilters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(AwsSecurityFindingFilters)
         */
        default Builder filters(Consumer<AwsSecurityFindingFilters.Builder> filters) {
            return filters(AwsSecurityFindingFilters.builder().applyMutation(filters).build());
        }

        /**
         * <p>
         * The attribute used to group the findings for the insight. The grouping attribute identifies the type of item
         * that the insight applies to. For example, if an insight is grouped by resource identifier, then the insight
         * produces a list of resource identifiers.
         * </p>
         * 
         * @param groupByAttribute
         *        The attribute used to group the findings for the insight. The grouping attribute identifies the type
         *        of item that the insight applies to. For example, if an insight is grouped by resource identifier,
         *        then the insight produces a list of resource identifiers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupByAttribute(String groupByAttribute);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecurityHubRequest.BuilderImpl implements Builder {
        private String name;

        private AwsSecurityFindingFilters filters;

        private String groupByAttribute;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInsightRequest model) {
            super(model);
            name(model.name);
            filters(model.filters);
            groupByAttribute(model.groupByAttribute);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final AwsSecurityFindingFilters.Builder getFilters() {
            return filters != null ? filters.toBuilder() : null;
        }

        public final void setFilters(AwsSecurityFindingFilters.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        @Override
        public final Builder filters(AwsSecurityFindingFilters filters) {
            this.filters = filters;
            return this;
        }

        public final String getGroupByAttribute() {
            return groupByAttribute;
        }

        public final void setGroupByAttribute(String groupByAttribute) {
            this.groupByAttribute = groupByAttribute;
        }

        @Override
        public final Builder groupByAttribute(String groupByAttribute) {
            this.groupByAttribute = groupByAttribute;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateInsightRequest build() {
            return new CreateInsightRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
