/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFindingAggregatorResponse extends SecurityHubResponse implements
        ToCopyableBuilder<CreateFindingAggregatorResponse.Builder, CreateFindingAggregatorResponse> {
    private static final SdkField<String> FINDING_AGGREGATOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FindingAggregatorArn").getter(getter(CreateFindingAggregatorResponse::findingAggregatorArn))
            .setter(setter(Builder::findingAggregatorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FindingAggregatorArn").build())
            .build();

    private static final SdkField<String> FINDING_AGGREGATION_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FindingAggregationRegion").getter(getter(CreateFindingAggregatorResponse::findingAggregationRegion))
            .setter(setter(Builder::findingAggregationRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FindingAggregationRegion").build())
            .build();

    private static final SdkField<String> REGION_LINKING_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegionLinkingMode").getter(getter(CreateFindingAggregatorResponse::regionLinkingMode))
            .setter(setter(Builder::regionLinkingMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionLinkingMode").build()).build();

    private static final SdkField<List<String>> REGIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Regions")
            .getter(getter(CreateFindingAggregatorResponse::regions))
            .setter(setter(Builder::regions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Regions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINDING_AGGREGATOR_ARN_FIELD,
            FINDING_AGGREGATION_REGION_FIELD, REGION_LINKING_MODE_FIELD, REGIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String findingAggregatorArn;

    private final String findingAggregationRegion;

    private final String regionLinkingMode;

    private final List<String> regions;

    private CreateFindingAggregatorResponse(BuilderImpl builder) {
        super(builder);
        this.findingAggregatorArn = builder.findingAggregatorArn;
        this.findingAggregationRegion = builder.findingAggregationRegion;
        this.regionLinkingMode = builder.regionLinkingMode;
        this.regions = builder.regions;
    }

    /**
     * <p>
     * The ARN of the finding aggregator. You use the finding aggregator ARN to retrieve details for, update, and stop
     * cross-Region aggregation.
     * </p>
     * 
     * @return The ARN of the finding aggregator. You use the finding aggregator ARN to retrieve details for, update,
     *         and stop cross-Region aggregation.
     */
    public final String findingAggregatorArn() {
        return findingAggregatorArn;
    }

    /**
     * <p>
     * The home Region. Findings generated in linked Regions are replicated and sent to the home Region.
     * </p>
     * 
     * @return The home Region. Findings generated in linked Regions are replicated and sent to the home Region.
     */
    public final String findingAggregationRegion() {
        return findingAggregationRegion;
    }

    /**
     * <p>
     * Indicates whether to link all Regions, all Regions except for a list of excluded Regions, or a list of included
     * Regions.
     * </p>
     * 
     * @return Indicates whether to link all Regions, all Regions except for a list of excluded Regions, or a list of
     *         included Regions.
     */
    public final String regionLinkingMode() {
        return regionLinkingMode;
    }

    /**
     * For responses, this returns true if the service returned a value for the Regions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRegions() {
        return regions != null && !(regions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of excluded Regions or included Regions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRegions} method.
     * </p>
     * 
     * @return The list of excluded Regions or included Regions.
     */
    public final List<String> regions() {
        return regions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(findingAggregatorArn());
        hashCode = 31 * hashCode + Objects.hashCode(findingAggregationRegion());
        hashCode = 31 * hashCode + Objects.hashCode(regionLinkingMode());
        hashCode = 31 * hashCode + Objects.hashCode(hasRegions() ? regions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFindingAggregatorResponse)) {
            return false;
        }
        CreateFindingAggregatorResponse other = (CreateFindingAggregatorResponse) obj;
        return Objects.equals(findingAggregatorArn(), other.findingAggregatorArn())
                && Objects.equals(findingAggregationRegion(), other.findingAggregationRegion())
                && Objects.equals(regionLinkingMode(), other.regionLinkingMode()) && hasRegions() == other.hasRegions()
                && Objects.equals(regions(), other.regions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateFindingAggregatorResponse").add("FindingAggregatorArn", findingAggregatorArn())
                .add("FindingAggregationRegion", findingAggregationRegion()).add("RegionLinkingMode", regionLinkingMode())
                .add("Regions", hasRegions() ? regions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FindingAggregatorArn":
            return Optional.ofNullable(clazz.cast(findingAggregatorArn()));
        case "FindingAggregationRegion":
            return Optional.ofNullable(clazz.cast(findingAggregationRegion()));
        case "RegionLinkingMode":
            return Optional.ofNullable(clazz.cast(regionLinkingMode()));
        case "Regions":
            return Optional.ofNullable(clazz.cast(regions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FindingAggregatorArn", FINDING_AGGREGATOR_ARN_FIELD);
        map.put("FindingAggregationRegion", FINDING_AGGREGATION_REGION_FIELD);
        map.put("RegionLinkingMode", REGION_LINKING_MODE_FIELD);
        map.put("Regions", REGIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateFindingAggregatorResponse, T> g) {
        return obj -> g.apply((CreateFindingAggregatorResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SecurityHubResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateFindingAggregatorResponse> {
        /**
         * <p>
         * The ARN of the finding aggregator. You use the finding aggregator ARN to retrieve details for, update, and
         * stop cross-Region aggregation.
         * </p>
         * 
         * @param findingAggregatorArn
         *        The ARN of the finding aggregator. You use the finding aggregator ARN to retrieve details for, update,
         *        and stop cross-Region aggregation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingAggregatorArn(String findingAggregatorArn);

        /**
         * <p>
         * The home Region. Findings generated in linked Regions are replicated and sent to the home Region.
         * </p>
         * 
         * @param findingAggregationRegion
         *        The home Region. Findings generated in linked Regions are replicated and sent to the home Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingAggregationRegion(String findingAggregationRegion);

        /**
         * <p>
         * Indicates whether to link all Regions, all Regions except for a list of excluded Regions, or a list of
         * included Regions.
         * </p>
         * 
         * @param regionLinkingMode
         *        Indicates whether to link all Regions, all Regions except for a list of excluded Regions, or a list of
         *        included Regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionLinkingMode(String regionLinkingMode);

        /**
         * <p>
         * The list of excluded Regions or included Regions.
         * </p>
         * 
         * @param regions
         *        The list of excluded Regions or included Regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regions(Collection<String> regions);

        /**
         * <p>
         * The list of excluded Regions or included Regions.
         * </p>
         * 
         * @param regions
         *        The list of excluded Regions or included Regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regions(String... regions);
    }

    static final class BuilderImpl extends SecurityHubResponse.BuilderImpl implements Builder {
        private String findingAggregatorArn;

        private String findingAggregationRegion;

        private String regionLinkingMode;

        private List<String> regions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFindingAggregatorResponse model) {
            super(model);
            findingAggregatorArn(model.findingAggregatorArn);
            findingAggregationRegion(model.findingAggregationRegion);
            regionLinkingMode(model.regionLinkingMode);
            regions(model.regions);
        }

        public final String getFindingAggregatorArn() {
            return findingAggregatorArn;
        }

        public final void setFindingAggregatorArn(String findingAggregatorArn) {
            this.findingAggregatorArn = findingAggregatorArn;
        }

        @Override
        public final Builder findingAggregatorArn(String findingAggregatorArn) {
            this.findingAggregatorArn = findingAggregatorArn;
            return this;
        }

        public final String getFindingAggregationRegion() {
            return findingAggregationRegion;
        }

        public final void setFindingAggregationRegion(String findingAggregationRegion) {
            this.findingAggregationRegion = findingAggregationRegion;
        }

        @Override
        public final Builder findingAggregationRegion(String findingAggregationRegion) {
            this.findingAggregationRegion = findingAggregationRegion;
            return this;
        }

        public final String getRegionLinkingMode() {
            return regionLinkingMode;
        }

        public final void setRegionLinkingMode(String regionLinkingMode) {
            this.regionLinkingMode = regionLinkingMode;
        }

        @Override
        public final Builder regionLinkingMode(String regionLinkingMode) {
            this.regionLinkingMode = regionLinkingMode;
            return this;
        }

        public final Collection<String> getRegions() {
            if (regions instanceof SdkAutoConstructList) {
                return null;
            }
            return regions;
        }

        public final void setRegions(Collection<String> regions) {
            this.regions = StringListCopier.copy(regions);
        }

        @Override
        public final Builder regions(Collection<String> regions) {
            this.regions = StringListCopier.copy(regions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(String... regions) {
            regions(Arrays.asList(regions));
            return this;
        }

        @Override
        public CreateFindingAggregatorResponse build() {
            return new CreateFindingAggregatorResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
