/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateConnectorV2Request extends SecurityHubRequest implements
        ToCopyableBuilder<CreateConnectorV2Request.Builder, CreateConnectorV2Request> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateConnectorV2Request::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateConnectorV2Request::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<ProviderConfiguration> PROVIDER_FIELD = SdkField
            .<ProviderConfiguration> builder(MarshallingType.SDK_POJO).memberName("Provider")
            .getter(getter(CreateConnectorV2Request::provider)).setter(setter(Builder::provider))
            .constructor(ProviderConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Provider").build()).build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyArn").getter(getter(CreateConnectorV2Request::kmsKeyArn)).setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyArn").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateConnectorV2Request::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateConnectorV2Request::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            PROVIDER_FIELD, KMS_KEY_ARN_FIELD, TAGS_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String description;

    private final ProviderConfiguration provider;

    private final String kmsKeyArn;

    private final Map<String, String> tags;

    private final String clientToken;

    private CreateConnectorV2Request(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.provider = builder.provider;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.tags = builder.tags;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The unique name of the connectorV2.
     * </p>
     * 
     * @return The unique name of the connectorV2.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the connectorV2.
     * </p>
     * 
     * @return The description of the connectorV2.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The third-party provider’s service configuration.
     * </p>
     * 
     * @return The third-party provider’s service configuration.
     */
    public final ProviderConfiguration provider() {
        return provider;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of KMS key used to encrypt secrets for the connectorV2.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of KMS key used to encrypt secrets for the connectorV2.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags to add to the connectorV2 when you create.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags to add to the connectorV2 when you create.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * A unique identifier used to ensure idempotency.
     * </p>
     * 
     * @return A unique identifier used to ensure idempotency.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(provider());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConnectorV2Request)) {
            return false;
        }
        CreateConnectorV2Request other = (CreateConnectorV2Request) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(provider(), other.provider()) && Objects.equals(kmsKeyArn(), other.kmsKeyArn())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateConnectorV2Request").add("Name", name()).add("Description", description())
                .add("Provider", provider()).add("KmsKeyArn", kmsKeyArn()).add("Tags", hasTags() ? tags() : null)
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Provider":
            return Optional.ofNullable(clazz.cast(provider()));
        case "KmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Provider", PROVIDER_FIELD);
        map.put("KmsKeyArn", KMS_KEY_ARN_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateConnectorV2Request, T> g) {
        return obj -> g.apply((CreateConnectorV2Request) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SecurityHubRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateConnectorV2Request> {
        /**
         * <p>
         * The unique name of the connectorV2.
         * </p>
         * 
         * @param name
         *        The unique name of the connectorV2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the connectorV2.
         * </p>
         * 
         * @param description
         *        The description of the connectorV2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The third-party provider’s service configuration.
         * </p>
         * 
         * @param provider
         *        The third-party provider’s service configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provider(ProviderConfiguration provider);

        /**
         * <p>
         * The third-party provider’s service configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProviderConfiguration.Builder} avoiding
         * the need to create one manually via {@link ProviderConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProviderConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #provider(ProviderConfiguration)}.
         * 
         * @param provider
         *        a consumer that will call methods on {@link ProviderConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provider(ProviderConfiguration)
         */
        default Builder provider(Consumer<ProviderConfiguration.Builder> provider) {
            return provider(ProviderConfiguration.builder().applyMutation(provider).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of KMS key used to encrypt secrets for the connectorV2.
         * </p>
         * 
         * @param kmsKeyArn
         *        The Amazon Resource Name (ARN) of KMS key used to encrypt secrets for the connectorV2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);

        /**
         * <p>
         * The tags to add to the connectorV2 when you create.
         * </p>
         * 
         * @param tags
         *        The tags to add to the connectorV2 when you create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * A unique identifier used to ensure idempotency.
         * </p>
         * 
         * @param clientToken
         *        A unique identifier used to ensure idempotency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecurityHubRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private ProviderConfiguration provider;

        private String kmsKeyArn;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConnectorV2Request model) {
            super(model);
            name(model.name);
            description(model.description);
            provider(model.provider);
            kmsKeyArn(model.kmsKeyArn);
            tags(model.tags);
            clientToken(model.clientToken);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ProviderConfiguration.Builder getProvider() {
            return provider != null ? provider.toBuilder() : null;
        }

        public final void setProvider(ProviderConfiguration.BuilderImpl provider) {
            this.provider = provider != null ? provider.build() : null;
        }

        @Override
        public final Builder provider(ProviderConfiguration provider) {
            this.provider = provider;
            return this;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateConnectorV2Request build() {
            return new CreateConnectorV2Request(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
