/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAggregatorV2Response extends SecurityHubResponse implements
        ToCopyableBuilder<CreateAggregatorV2Response.Builder, CreateAggregatorV2Response> {
    private static final SdkField<String> AGGREGATOR_V2_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AggregatorV2Arn").getter(getter(CreateAggregatorV2Response::aggregatorV2Arn))
            .setter(setter(Builder::aggregatorV2Arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregatorV2Arn").build()).build();

    private static final SdkField<String> AGGREGATION_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AggregationRegion").getter(getter(CreateAggregatorV2Response::aggregationRegion))
            .setter(setter(Builder::aggregationRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregationRegion").build()).build();

    private static final SdkField<String> REGION_LINKING_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegionLinkingMode").getter(getter(CreateAggregatorV2Response::regionLinkingMode))
            .setter(setter(Builder::regionLinkingMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionLinkingMode").build()).build();

    private static final SdkField<List<String>> LINKED_REGIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("LinkedRegions")
            .getter(getter(CreateAggregatorV2Response::linkedRegions))
            .setter(setter(Builder::linkedRegions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkedRegions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGGREGATOR_V2_ARN_FIELD,
            AGGREGATION_REGION_FIELD, REGION_LINKING_MODE_FIELD, LINKED_REGIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String aggregatorV2Arn;

    private final String aggregationRegion;

    private final String regionLinkingMode;

    private final List<String> linkedRegions;

    private CreateAggregatorV2Response(BuilderImpl builder) {
        super(builder);
        this.aggregatorV2Arn = builder.aggregatorV2Arn;
        this.aggregationRegion = builder.aggregationRegion;
        this.regionLinkingMode = builder.regionLinkingMode;
        this.linkedRegions = builder.linkedRegions;
    }

    /**
     * <p>
     * The ARN of the AggregatorV2.
     * </p>
     * 
     * @return The ARN of the AggregatorV2.
     */
    public final String aggregatorV2Arn() {
        return aggregatorV2Arn;
    }

    /**
     * <p>
     * The Amazon Web Services Region where data is aggregated.
     * </p>
     * 
     * @return The Amazon Web Services Region where data is aggregated.
     */
    public final String aggregationRegion() {
        return aggregationRegion;
    }

    /**
     * <p>
     * Determines how Regions are linked to an Aggregator V2.
     * </p>
     * 
     * @return Determines how Regions are linked to an Aggregator V2.
     */
    public final String regionLinkingMode() {
        return regionLinkingMode;
    }

    /**
     * For responses, this returns true if the service returned a value for the LinkedRegions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLinkedRegions() {
        return linkedRegions != null && !(linkedRegions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of Regions that are linked to the aggregation Region.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLinkedRegions} method.
     * </p>
     * 
     * @return The list of Regions that are linked to the aggregation Region.
     */
    public final List<String> linkedRegions() {
        return linkedRegions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(aggregatorV2Arn());
        hashCode = 31 * hashCode + Objects.hashCode(aggregationRegion());
        hashCode = 31 * hashCode + Objects.hashCode(regionLinkingMode());
        hashCode = 31 * hashCode + Objects.hashCode(hasLinkedRegions() ? linkedRegions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAggregatorV2Response)) {
            return false;
        }
        CreateAggregatorV2Response other = (CreateAggregatorV2Response) obj;
        return Objects.equals(aggregatorV2Arn(), other.aggregatorV2Arn())
                && Objects.equals(aggregationRegion(), other.aggregationRegion())
                && Objects.equals(regionLinkingMode(), other.regionLinkingMode())
                && hasLinkedRegions() == other.hasLinkedRegions() && Objects.equals(linkedRegions(), other.linkedRegions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAggregatorV2Response").add("AggregatorV2Arn", aggregatorV2Arn())
                .add("AggregationRegion", aggregationRegion()).add("RegionLinkingMode", regionLinkingMode())
                .add("LinkedRegions", hasLinkedRegions() ? linkedRegions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AggregatorV2Arn":
            return Optional.ofNullable(clazz.cast(aggregatorV2Arn()));
        case "AggregationRegion":
            return Optional.ofNullable(clazz.cast(aggregationRegion()));
        case "RegionLinkingMode":
            return Optional.ofNullable(clazz.cast(regionLinkingMode()));
        case "LinkedRegions":
            return Optional.ofNullable(clazz.cast(linkedRegions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AggregatorV2Arn", AGGREGATOR_V2_ARN_FIELD);
        map.put("AggregationRegion", AGGREGATION_REGION_FIELD);
        map.put("RegionLinkingMode", REGION_LINKING_MODE_FIELD);
        map.put("LinkedRegions", LINKED_REGIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAggregatorV2Response, T> g) {
        return obj -> g.apply((CreateAggregatorV2Response) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SecurityHubResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateAggregatorV2Response> {
        /**
         * <p>
         * The ARN of the AggregatorV2.
         * </p>
         * 
         * @param aggregatorV2Arn
         *        The ARN of the AggregatorV2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregatorV2Arn(String aggregatorV2Arn);

        /**
         * <p>
         * The Amazon Web Services Region where data is aggregated.
         * </p>
         * 
         * @param aggregationRegion
         *        The Amazon Web Services Region where data is aggregated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregationRegion(String aggregationRegion);

        /**
         * <p>
         * Determines how Regions are linked to an Aggregator V2.
         * </p>
         * 
         * @param regionLinkingMode
         *        Determines how Regions are linked to an Aggregator V2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionLinkingMode(String regionLinkingMode);

        /**
         * <p>
         * The list of Regions that are linked to the aggregation Region.
         * </p>
         * 
         * @param linkedRegions
         *        The list of Regions that are linked to the aggregation Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkedRegions(Collection<String> linkedRegions);

        /**
         * <p>
         * The list of Regions that are linked to the aggregation Region.
         * </p>
         * 
         * @param linkedRegions
         *        The list of Regions that are linked to the aggregation Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkedRegions(String... linkedRegions);
    }

    static final class BuilderImpl extends SecurityHubResponse.BuilderImpl implements Builder {
        private String aggregatorV2Arn;

        private String aggregationRegion;

        private String regionLinkingMode;

        private List<String> linkedRegions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAggregatorV2Response model) {
            super(model);
            aggregatorV2Arn(model.aggregatorV2Arn);
            aggregationRegion(model.aggregationRegion);
            regionLinkingMode(model.regionLinkingMode);
            linkedRegions(model.linkedRegions);
        }

        public final String getAggregatorV2Arn() {
            return aggregatorV2Arn;
        }

        public final void setAggregatorV2Arn(String aggregatorV2Arn) {
            this.aggregatorV2Arn = aggregatorV2Arn;
        }

        @Override
        public final Builder aggregatorV2Arn(String aggregatorV2Arn) {
            this.aggregatorV2Arn = aggregatorV2Arn;
            return this;
        }

        public final String getAggregationRegion() {
            return aggregationRegion;
        }

        public final void setAggregationRegion(String aggregationRegion) {
            this.aggregationRegion = aggregationRegion;
        }

        @Override
        public final Builder aggregationRegion(String aggregationRegion) {
            this.aggregationRegion = aggregationRegion;
            return this;
        }

        public final String getRegionLinkingMode() {
            return regionLinkingMode;
        }

        public final void setRegionLinkingMode(String regionLinkingMode) {
            this.regionLinkingMode = regionLinkingMode;
        }

        @Override
        public final Builder regionLinkingMode(String regionLinkingMode) {
            this.regionLinkingMode = regionLinkingMode;
            return this;
        }

        public final Collection<String> getLinkedRegions() {
            if (linkedRegions instanceof SdkAutoConstructList) {
                return null;
            }
            return linkedRegions;
        }

        public final void setLinkedRegions(Collection<String> linkedRegions) {
            this.linkedRegions = StringListCopier.copy(linkedRegions);
        }

        @Override
        public final Builder linkedRegions(Collection<String> linkedRegions) {
            this.linkedRegions = StringListCopier.copy(linkedRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder linkedRegions(String... linkedRegions) {
            linkedRegions(Arrays.asList(linkedRegions));
            return this;
        }

        @Override
        public CreateAggregatorV2Response build() {
            return new CreateAggregatorV2Response(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
