/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAggregatorV2Request extends SecurityHubRequest implements
        ToCopyableBuilder<CreateAggregatorV2Request.Builder, CreateAggregatorV2Request> {
    private static final SdkField<String> REGION_LINKING_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegionLinkingMode").getter(getter(CreateAggregatorV2Request::regionLinkingMode))
            .setter(setter(Builder::regionLinkingMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionLinkingMode").build()).build();

    private static final SdkField<List<String>> LINKED_REGIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("LinkedRegions")
            .getter(getter(CreateAggregatorV2Request::linkedRegions))
            .setter(setter(Builder::linkedRegions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkedRegions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateAggregatorV2Request::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateAggregatorV2Request::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_LINKING_MODE_FIELD,
            LINKED_REGIONS_FIELD, TAGS_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String regionLinkingMode;

    private final List<String> linkedRegions;

    private final Map<String, String> tags;

    private final String clientToken;

    private CreateAggregatorV2Request(BuilderImpl builder) {
        super(builder);
        this.regionLinkingMode = builder.regionLinkingMode;
        this.linkedRegions = builder.linkedRegions;
        this.tags = builder.tags;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * Determines how Regions are linked to an Aggregator V2.
     * </p>
     * 
     * @return Determines how Regions are linked to an Aggregator V2.
     */
    public final String regionLinkingMode() {
        return regionLinkingMode;
    }

    /**
     * For responses, this returns true if the service returned a value for the LinkedRegions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLinkedRegions() {
        return linkedRegions != null && !(linkedRegions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of Regions that are linked to the aggregation Region.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLinkedRegions} method.
     * </p>
     * 
     * @return The list of Regions that are linked to the aggregation Region.
     */
    public final List<String> linkedRegions() {
        return linkedRegions;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of key-value pairs to be applied to the AggregatorV2.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of key-value pairs to be applied to the AggregatorV2.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * A unique identifier used to ensure idempotency.
     * </p>
     * 
     * @return A unique identifier used to ensure idempotency.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(regionLinkingMode());
        hashCode = 31 * hashCode + Objects.hashCode(hasLinkedRegions() ? linkedRegions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAggregatorV2Request)) {
            return false;
        }
        CreateAggregatorV2Request other = (CreateAggregatorV2Request) obj;
        return Objects.equals(regionLinkingMode(), other.regionLinkingMode()) && hasLinkedRegions() == other.hasLinkedRegions()
                && Objects.equals(linkedRegions(), other.linkedRegions()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAggregatorV2Request").add("RegionLinkingMode", regionLinkingMode())
                .add("LinkedRegions", hasLinkedRegions() ? linkedRegions() : null).add("Tags", hasTags() ? tags() : null)
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RegionLinkingMode":
            return Optional.ofNullable(clazz.cast(regionLinkingMode()));
        case "LinkedRegions":
            return Optional.ofNullable(clazz.cast(linkedRegions()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RegionLinkingMode", REGION_LINKING_MODE_FIELD);
        map.put("LinkedRegions", LINKED_REGIONS_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAggregatorV2Request, T> g) {
        return obj -> g.apply((CreateAggregatorV2Request) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SecurityHubRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateAggregatorV2Request> {
        /**
         * <p>
         * Determines how Regions are linked to an Aggregator V2.
         * </p>
         * 
         * @param regionLinkingMode
         *        Determines how Regions are linked to an Aggregator V2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionLinkingMode(String regionLinkingMode);

        /**
         * <p>
         * The list of Regions that are linked to the aggregation Region.
         * </p>
         * 
         * @param linkedRegions
         *        The list of Regions that are linked to the aggregation Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkedRegions(Collection<String> linkedRegions);

        /**
         * <p>
         * The list of Regions that are linked to the aggregation Region.
         * </p>
         * 
         * @param linkedRegions
         *        The list of Regions that are linked to the aggregation Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkedRegions(String... linkedRegions);

        /**
         * <p>
         * A list of key-value pairs to be applied to the AggregatorV2.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs to be applied to the AggregatorV2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * A unique identifier used to ensure idempotency.
         * </p>
         * 
         * @param clientToken
         *        A unique identifier used to ensure idempotency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecurityHubRequest.BuilderImpl implements Builder {
        private String regionLinkingMode;

        private List<String> linkedRegions = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAggregatorV2Request model) {
            super(model);
            regionLinkingMode(model.regionLinkingMode);
            linkedRegions(model.linkedRegions);
            tags(model.tags);
            clientToken(model.clientToken);
        }

        public final String getRegionLinkingMode() {
            return regionLinkingMode;
        }

        public final void setRegionLinkingMode(String regionLinkingMode) {
            this.regionLinkingMode = regionLinkingMode;
        }

        @Override
        public final Builder regionLinkingMode(String regionLinkingMode) {
            this.regionLinkingMode = regionLinkingMode;
            return this;
        }

        public final Collection<String> getLinkedRegions() {
            if (linkedRegions instanceof SdkAutoConstructList) {
                return null;
            }
            return linkedRegions;
        }

        public final void setLinkedRegions(Collection<String> linkedRegions) {
            this.linkedRegions = StringListCopier.copy(linkedRegions);
        }

        @Override
        public final Builder linkedRegions(Collection<String> linkedRegions) {
            this.linkedRegions = StringListCopier.copy(linkedRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder linkedRegions(String... linkedRegions) {
            linkedRegions(Arrays.asList(linkedRegions));
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAggregatorV2Request build() {
            return new CreateAggregatorV2Request(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
