/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Enables the creation of filtering criteria for security findings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CompositeFilter implements SdkPojo, Serializable, ToCopyableBuilder<CompositeFilter.Builder, CompositeFilter> {
    private static final SdkField<List<OcsfStringFilter>> STRING_FILTERS_FIELD = SdkField
            .<List<OcsfStringFilter>> builder(MarshallingType.LIST)
            .memberName("StringFilters")
            .getter(getter(CompositeFilter::stringFilters))
            .setter(setter(Builder::stringFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OcsfStringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(OcsfStringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<OcsfDateFilter>> DATE_FILTERS_FIELD = SdkField
            .<List<OcsfDateFilter>> builder(MarshallingType.LIST)
            .memberName("DateFilters")
            .getter(getter(CompositeFilter::dateFilters))
            .setter(setter(Builder::dateFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OcsfDateFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(OcsfDateFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<OcsfBooleanFilter>> BOOLEAN_FILTERS_FIELD = SdkField
            .<List<OcsfBooleanFilter>> builder(MarshallingType.LIST)
            .memberName("BooleanFilters")
            .getter(getter(CompositeFilter::booleanFilters))
            .setter(setter(Builder::booleanFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BooleanFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OcsfBooleanFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(OcsfBooleanFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<OcsfNumberFilter>> NUMBER_FILTERS_FIELD = SdkField
            .<List<OcsfNumberFilter>> builder(MarshallingType.LIST)
            .memberName("NumberFilters")
            .getter(getter(CompositeFilter::numberFilters))
            .setter(setter(Builder::numberFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OcsfNumberFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(OcsfNumberFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<OcsfMapFilter>> MAP_FILTERS_FIELD = SdkField
            .<List<OcsfMapFilter>> builder(MarshallingType.LIST)
            .memberName("MapFilters")
            .getter(getter(CompositeFilter::mapFilters))
            .setter(setter(Builder::mapFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MapFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OcsfMapFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(OcsfMapFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<OcsfIpFilter>> IP_FILTERS_FIELD = SdkField
            .<List<OcsfIpFilter>> builder(MarshallingType.LIST)
            .memberName("IpFilters")
            .getter(getter(CompositeFilter::ipFilters))
            .setter(setter(Builder::ipFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OcsfIpFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(OcsfIpFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CompositeFilter>> NESTED_COMPOSITE_FILTERS_FIELD = SdkField
            .<List<CompositeFilter>> builder(MarshallingType.LIST)
            .memberName("NestedCompositeFilters")
            .getter(getter(CompositeFilter::nestedCompositeFilters))
            .setter(setter(Builder::nestedCompositeFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NestedCompositeFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CompositeFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CompositeFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Operator").getter(getter(CompositeFilter::operatorAsString)).setter(setter(Builder::operator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operator").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STRING_FILTERS_FIELD,
            DATE_FILTERS_FIELD, BOOLEAN_FILTERS_FIELD, NUMBER_FILTERS_FIELD, MAP_FILTERS_FIELD, IP_FILTERS_FIELD,
            NESTED_COMPOSITE_FILTERS_FIELD, OPERATOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<OcsfStringFilter> stringFilters;

    private final List<OcsfDateFilter> dateFilters;

    private final List<OcsfBooleanFilter> booleanFilters;

    private final List<OcsfNumberFilter> numberFilters;

    private final List<OcsfMapFilter> mapFilters;

    private final List<OcsfIpFilter> ipFilters;

    private final List<CompositeFilter> nestedCompositeFilters;

    private final String operator;

    private CompositeFilter(BuilderImpl builder) {
        this.stringFilters = builder.stringFilters;
        this.dateFilters = builder.dateFilters;
        this.booleanFilters = builder.booleanFilters;
        this.numberFilters = builder.numberFilters;
        this.mapFilters = builder.mapFilters;
        this.ipFilters = builder.ipFilters;
        this.nestedCompositeFilters = builder.nestedCompositeFilters;
        this.operator = builder.operator;
    }

    /**
     * For responses, this returns true if the service returned a value for the StringFilters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStringFilters() {
        return stringFilters != null && !(stringFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Enables filtering based on string field values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStringFilters} method.
     * </p>
     * 
     * @return Enables filtering based on string field values.
     */
    public final List<OcsfStringFilter> stringFilters() {
        return stringFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the DateFilters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDateFilters() {
        return dateFilters != null && !(dateFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Enables filtering based on date and timestamp fields.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDateFilters} method.
     * </p>
     * 
     * @return Enables filtering based on date and timestamp fields.
     */
    public final List<OcsfDateFilter> dateFilters() {
        return dateFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the BooleanFilters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBooleanFilters() {
        return booleanFilters != null && !(booleanFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Enables filtering based on boolean field values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBooleanFilters} method.
     * </p>
     * 
     * @return Enables filtering based on boolean field values.
     */
    public final List<OcsfBooleanFilter> booleanFilters() {
        return booleanFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the NumberFilters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNumberFilters() {
        return numberFilters != null && !(numberFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Enables filtering based on numerical field values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNumberFilters} method.
     * </p>
     * 
     * @return Enables filtering based on numerical field values.
     */
    public final List<OcsfNumberFilter> numberFilters() {
        return numberFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the MapFilters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMapFilters() {
        return mapFilters != null && !(mapFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Enables filtering based on map field values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMapFilters} method.
     * </p>
     * 
     * @return Enables filtering based on map field values.
     */
    public final List<OcsfMapFilter> mapFilters() {
        return mapFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the IpFilters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasIpFilters() {
        return ipFilters != null && !(ipFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of IP address filters that allowing you to filter findings based on IP address properties.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpFilters} method.
     * </p>
     * 
     * @return A list of IP address filters that allowing you to filter findings based on IP address properties.
     */
    public final List<OcsfIpFilter> ipFilters() {
        return ipFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the NestedCompositeFilters property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasNestedCompositeFilters() {
        return nestedCompositeFilters != null && !(nestedCompositeFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides an additional level of filtering, creating a three-layer nested structure. The first layer is a
     * <code>CompositeFilters</code> array with a <code>CompositeOperator</code> (<code>AND</code>/<code>OR</code>). The
     * second layer is a <code>CompositeFilter</code> object that contains direct filters and
     * <code>NestedCompositeFilters</code>. The third layer is <code>NestedCompositeFilters</code>, which contains
     * additional filter conditions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNestedCompositeFilters} method.
     * </p>
     * 
     * @return Provides an additional level of filtering, creating a three-layer nested structure. The first layer is a
     *         <code>CompositeFilters</code> array with a <code>CompositeOperator</code> (<code>AND</code>/
     *         <code>OR</code>). The second layer is a <code>CompositeFilter</code> object that contains direct filters
     *         and <code>NestedCompositeFilters</code>. The third layer is <code>NestedCompositeFilters</code>, which
     *         contains additional filter conditions.
     */
    public final List<CompositeFilter> nestedCompositeFilters() {
        return nestedCompositeFilters;
    }

    /**
     * <p>
     * The logical operator used to combine multiple filter conditions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operator} will
     * return {@link AllowedOperators#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #operatorAsString}.
     * </p>
     * 
     * @return The logical operator used to combine multiple filter conditions.
     * @see AllowedOperators
     */
    public final AllowedOperators operator() {
        return AllowedOperators.fromValue(operator);
    }

    /**
     * <p>
     * The logical operator used to combine multiple filter conditions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operator} will
     * return {@link AllowedOperators#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #operatorAsString}.
     * </p>
     * 
     * @return The logical operator used to combine multiple filter conditions.
     * @see AllowedOperators
     */
    public final String operatorAsString() {
        return operator;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasStringFilters() ? stringFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDateFilters() ? dateFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasBooleanFilters() ? booleanFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNumberFilters() ? numberFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasMapFilters() ? mapFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasIpFilters() ? ipFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNestedCompositeFilters() ? nestedCompositeFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(operatorAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompositeFilter)) {
            return false;
        }
        CompositeFilter other = (CompositeFilter) obj;
        return hasStringFilters() == other.hasStringFilters() && Objects.equals(stringFilters(), other.stringFilters())
                && hasDateFilters() == other.hasDateFilters() && Objects.equals(dateFilters(), other.dateFilters())
                && hasBooleanFilters() == other.hasBooleanFilters() && Objects.equals(booleanFilters(), other.booleanFilters())
                && hasNumberFilters() == other.hasNumberFilters() && Objects.equals(numberFilters(), other.numberFilters())
                && hasMapFilters() == other.hasMapFilters() && Objects.equals(mapFilters(), other.mapFilters())
                && hasIpFilters() == other.hasIpFilters() && Objects.equals(ipFilters(), other.ipFilters())
                && hasNestedCompositeFilters() == other.hasNestedCompositeFilters()
                && Objects.equals(nestedCompositeFilters(), other.nestedCompositeFilters())
                && Objects.equals(operatorAsString(), other.operatorAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CompositeFilter").add("StringFilters", hasStringFilters() ? stringFilters() : null)
                .add("DateFilters", hasDateFilters() ? dateFilters() : null)
                .add("BooleanFilters", hasBooleanFilters() ? booleanFilters() : null)
                .add("NumberFilters", hasNumberFilters() ? numberFilters() : null)
                .add("MapFilters", hasMapFilters() ? mapFilters() : null).add("IpFilters", hasIpFilters() ? ipFilters() : null)
                .add("NestedCompositeFilters", hasNestedCompositeFilters() ? nestedCompositeFilters() : null)
                .add("Operator", operatorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StringFilters":
            return Optional.ofNullable(clazz.cast(stringFilters()));
        case "DateFilters":
            return Optional.ofNullable(clazz.cast(dateFilters()));
        case "BooleanFilters":
            return Optional.ofNullable(clazz.cast(booleanFilters()));
        case "NumberFilters":
            return Optional.ofNullable(clazz.cast(numberFilters()));
        case "MapFilters":
            return Optional.ofNullable(clazz.cast(mapFilters()));
        case "IpFilters":
            return Optional.ofNullable(clazz.cast(ipFilters()));
        case "NestedCompositeFilters":
            return Optional.ofNullable(clazz.cast(nestedCompositeFilters()));
        case "Operator":
            return Optional.ofNullable(clazz.cast(operatorAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StringFilters", STRING_FILTERS_FIELD);
        map.put("DateFilters", DATE_FILTERS_FIELD);
        map.put("BooleanFilters", BOOLEAN_FILTERS_FIELD);
        map.put("NumberFilters", NUMBER_FILTERS_FIELD);
        map.put("MapFilters", MAP_FILTERS_FIELD);
        map.put("IpFilters", IP_FILTERS_FIELD);
        map.put("NestedCompositeFilters", NESTED_COMPOSITE_FILTERS_FIELD);
        map.put("Operator", OPERATOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CompositeFilter, T> g) {
        return obj -> g.apply((CompositeFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CompositeFilter> {
        /**
         * <p>
         * Enables filtering based on string field values.
         * </p>
         * 
         * @param stringFilters
         *        Enables filtering based on string field values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringFilters(Collection<OcsfStringFilter> stringFilters);

        /**
         * <p>
         * Enables filtering based on string field values.
         * </p>
         * 
         * @param stringFilters
         *        Enables filtering based on string field values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringFilters(OcsfStringFilter... stringFilters);

        /**
         * <p>
         * Enables filtering based on string field values.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.OcsfStringFilter.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.securityhub.model.OcsfStringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.OcsfStringFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #stringFilters(List<OcsfStringFilter>)}.
         * 
         * @param stringFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.OcsfStringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stringFilters(java.util.Collection<OcsfStringFilter>)
         */
        Builder stringFilters(Consumer<OcsfStringFilter.Builder>... stringFilters);

        /**
         * <p>
         * Enables filtering based on date and timestamp fields.
         * </p>
         * 
         * @param dateFilters
         *        Enables filtering based on date and timestamp fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateFilters(Collection<OcsfDateFilter> dateFilters);

        /**
         * <p>
         * Enables filtering based on date and timestamp fields.
         * </p>
         * 
         * @param dateFilters
         *        Enables filtering based on date and timestamp fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateFilters(OcsfDateFilter... dateFilters);

        /**
         * <p>
         * Enables filtering based on date and timestamp fields.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.OcsfDateFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.securityhub.model.OcsfDateFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.OcsfDateFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #dateFilters(List<OcsfDateFilter>)}.
         * 
         * @param dateFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.OcsfDateFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dateFilters(java.util.Collection<OcsfDateFilter>)
         */
        Builder dateFilters(Consumer<OcsfDateFilter.Builder>... dateFilters);

        /**
         * <p>
         * Enables filtering based on boolean field values.
         * </p>
         * 
         * @param booleanFilters
         *        Enables filtering based on boolean field values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder booleanFilters(Collection<OcsfBooleanFilter> booleanFilters);

        /**
         * <p>
         * Enables filtering based on boolean field values.
         * </p>
         * 
         * @param booleanFilters
         *        Enables filtering based on boolean field values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder booleanFilters(OcsfBooleanFilter... booleanFilters);

        /**
         * <p>
         * Enables filtering based on boolean field values.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.OcsfBooleanFilter.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.securityhub.model.OcsfBooleanFilter#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.OcsfBooleanFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #booleanFilters(List<OcsfBooleanFilter>)}.
         * 
         * @param booleanFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.OcsfBooleanFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #booleanFilters(java.util.Collection<OcsfBooleanFilter>)
         */
        Builder booleanFilters(Consumer<OcsfBooleanFilter.Builder>... booleanFilters);

        /**
         * <p>
         * Enables filtering based on numerical field values.
         * </p>
         * 
         * @param numberFilters
         *        Enables filtering based on numerical field values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberFilters(Collection<OcsfNumberFilter> numberFilters);

        /**
         * <p>
         * Enables filtering based on numerical field values.
         * </p>
         * 
         * @param numberFilters
         *        Enables filtering based on numerical field values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberFilters(OcsfNumberFilter... numberFilters);

        /**
         * <p>
         * Enables filtering based on numerical field values.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.OcsfNumberFilter.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.securityhub.model.OcsfNumberFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.OcsfNumberFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #numberFilters(List<OcsfNumberFilter>)}.
         * 
         * @param numberFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.OcsfNumberFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #numberFilters(java.util.Collection<OcsfNumberFilter>)
         */
        Builder numberFilters(Consumer<OcsfNumberFilter.Builder>... numberFilters);

        /**
         * <p>
         * Enables filtering based on map field values.
         * </p>
         * 
         * @param mapFilters
         *        Enables filtering based on map field values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapFilters(Collection<OcsfMapFilter> mapFilters);

        /**
         * <p>
         * Enables filtering based on map field values.
         * </p>
         * 
         * @param mapFilters
         *        Enables filtering based on map field values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapFilters(OcsfMapFilter... mapFilters);

        /**
         * <p>
         * Enables filtering based on map field values.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.OcsfMapFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.securityhub.model.OcsfMapFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.OcsfMapFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #mapFilters(List<OcsfMapFilter>)}.
         * 
         * @param mapFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.OcsfMapFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mapFilters(java.util.Collection<OcsfMapFilter>)
         */
        Builder mapFilters(Consumer<OcsfMapFilter.Builder>... mapFilters);

        /**
         * <p>
         * A list of IP address filters that allowing you to filter findings based on IP address properties.
         * </p>
         * 
         * @param ipFilters
         *        A list of IP address filters that allowing you to filter findings based on IP address properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipFilters(Collection<OcsfIpFilter> ipFilters);

        /**
         * <p>
         * A list of IP address filters that allowing you to filter findings based on IP address properties.
         * </p>
         * 
         * @param ipFilters
         *        A list of IP address filters that allowing you to filter findings based on IP address properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipFilters(OcsfIpFilter... ipFilters);

        /**
         * <p>
         * A list of IP address filters that allowing you to filter findings based on IP address properties.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.OcsfIpFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.securityhub.model.OcsfIpFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.OcsfIpFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #ipFilters(List<OcsfIpFilter>)}.
         * 
         * @param ipFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.OcsfIpFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipFilters(java.util.Collection<OcsfIpFilter>)
         */
        Builder ipFilters(Consumer<OcsfIpFilter.Builder>... ipFilters);

        /**
         * <p>
         * Provides an additional level of filtering, creating a three-layer nested structure. The first layer is a
         * <code>CompositeFilters</code> array with a <code>CompositeOperator</code> (<code>AND</code>/<code>OR</code>).
         * The second layer is a <code>CompositeFilter</code> object that contains direct filters and
         * <code>NestedCompositeFilters</code>. The third layer is <code>NestedCompositeFilters</code>, which contains
         * additional filter conditions.
         * </p>
         * 
         * @param nestedCompositeFilters
         *        Provides an additional level of filtering, creating a three-layer nested structure. The first layer is
         *        a <code>CompositeFilters</code> array with a <code>CompositeOperator</code> (<code>AND</code>/
         *        <code>OR</code>). The second layer is a <code>CompositeFilter</code> object that contains direct
         *        filters and <code>NestedCompositeFilters</code>. The third layer is
         *        <code>NestedCompositeFilters</code>, which contains additional filter conditions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nestedCompositeFilters(Collection<CompositeFilter> nestedCompositeFilters);

        /**
         * <p>
         * Provides an additional level of filtering, creating a three-layer nested structure. The first layer is a
         * <code>CompositeFilters</code> array with a <code>CompositeOperator</code> (<code>AND</code>/<code>OR</code>).
         * The second layer is a <code>CompositeFilter</code> object that contains direct filters and
         * <code>NestedCompositeFilters</code>. The third layer is <code>NestedCompositeFilters</code>, which contains
         * additional filter conditions.
         * </p>
         * 
         * @param nestedCompositeFilters
         *        Provides an additional level of filtering, creating a three-layer nested structure. The first layer is
         *        a <code>CompositeFilters</code> array with a <code>CompositeOperator</code> (<code>AND</code>/
         *        <code>OR</code>). The second layer is a <code>CompositeFilter</code> object that contains direct
         *        filters and <code>NestedCompositeFilters</code>. The third layer is
         *        <code>NestedCompositeFilters</code>, which contains additional filter conditions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nestedCompositeFilters(CompositeFilter... nestedCompositeFilters);

        /**
         * <p>
         * Provides an additional level of filtering, creating a three-layer nested structure. The first layer is a
         * <code>CompositeFilters</code> array with a <code>CompositeOperator</code> (<code>AND</code>/<code>OR</code>).
         * The second layer is a <code>CompositeFilter</code> object that contains direct filters and
         * <code>NestedCompositeFilters</code>. The third layer is <code>NestedCompositeFilters</code>, which contains
         * additional filter conditions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.CompositeFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.securityhub.model.CompositeFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.CompositeFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #nestedCompositeFilters(List<CompositeFilter>)}.
         * 
         * @param nestedCompositeFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.CompositeFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nestedCompositeFilters(java.util.Collection<CompositeFilter>)
         */
        Builder nestedCompositeFilters(Consumer<Builder>... nestedCompositeFilters);

        /**
         * <p>
         * The logical operator used to combine multiple filter conditions.
         * </p>
         * 
         * @param operator
         *        The logical operator used to combine multiple filter conditions.
         * @see AllowedOperators
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AllowedOperators
         */
        Builder operator(String operator);

        /**
         * <p>
         * The logical operator used to combine multiple filter conditions.
         * </p>
         * 
         * @param operator
         *        The logical operator used to combine multiple filter conditions.
         * @see AllowedOperators
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AllowedOperators
         */
        Builder operator(AllowedOperators operator);
    }

    static final class BuilderImpl implements Builder {
        private List<OcsfStringFilter> stringFilters = DefaultSdkAutoConstructList.getInstance();

        private List<OcsfDateFilter> dateFilters = DefaultSdkAutoConstructList.getInstance();

        private List<OcsfBooleanFilter> booleanFilters = DefaultSdkAutoConstructList.getInstance();

        private List<OcsfNumberFilter> numberFilters = DefaultSdkAutoConstructList.getInstance();

        private List<OcsfMapFilter> mapFilters = DefaultSdkAutoConstructList.getInstance();

        private List<OcsfIpFilter> ipFilters = DefaultSdkAutoConstructList.getInstance();

        private List<CompositeFilter> nestedCompositeFilters = DefaultSdkAutoConstructList.getInstance();

        private String operator;

        private BuilderImpl() {
        }

        private BuilderImpl(CompositeFilter model) {
            stringFilters(model.stringFilters);
            dateFilters(model.dateFilters);
            booleanFilters(model.booleanFilters);
            numberFilters(model.numberFilters);
            mapFilters(model.mapFilters);
            ipFilters(model.ipFilters);
            nestedCompositeFilters(model.nestedCompositeFilters);
            operator(model.operator);
        }

        public final List<OcsfStringFilter.Builder> getStringFilters() {
            List<OcsfStringFilter.Builder> result = OcsfStringFilterListCopier.copyToBuilder(this.stringFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStringFilters(Collection<OcsfStringFilter.BuilderImpl> stringFilters) {
            this.stringFilters = OcsfStringFilterListCopier.copyFromBuilder(stringFilters);
        }

        @Override
        public final Builder stringFilters(Collection<OcsfStringFilter> stringFilters) {
            this.stringFilters = OcsfStringFilterListCopier.copy(stringFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stringFilters(OcsfStringFilter... stringFilters) {
            stringFilters(Arrays.asList(stringFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stringFilters(Consumer<OcsfStringFilter.Builder>... stringFilters) {
            stringFilters(Stream.of(stringFilters).map(c -> OcsfStringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<OcsfDateFilter.Builder> getDateFilters() {
            List<OcsfDateFilter.Builder> result = OcsfDateFilterListCopier.copyToBuilder(this.dateFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDateFilters(Collection<OcsfDateFilter.BuilderImpl> dateFilters) {
            this.dateFilters = OcsfDateFilterListCopier.copyFromBuilder(dateFilters);
        }

        @Override
        public final Builder dateFilters(Collection<OcsfDateFilter> dateFilters) {
            this.dateFilters = OcsfDateFilterListCopier.copy(dateFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dateFilters(OcsfDateFilter... dateFilters) {
            dateFilters(Arrays.asList(dateFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dateFilters(Consumer<OcsfDateFilter.Builder>... dateFilters) {
            dateFilters(Stream.of(dateFilters).map(c -> OcsfDateFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<OcsfBooleanFilter.Builder> getBooleanFilters() {
            List<OcsfBooleanFilter.Builder> result = OcsfBooleanFilterListCopier.copyToBuilder(this.booleanFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBooleanFilters(Collection<OcsfBooleanFilter.BuilderImpl> booleanFilters) {
            this.booleanFilters = OcsfBooleanFilterListCopier.copyFromBuilder(booleanFilters);
        }

        @Override
        public final Builder booleanFilters(Collection<OcsfBooleanFilter> booleanFilters) {
            this.booleanFilters = OcsfBooleanFilterListCopier.copy(booleanFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder booleanFilters(OcsfBooleanFilter... booleanFilters) {
            booleanFilters(Arrays.asList(booleanFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder booleanFilters(Consumer<OcsfBooleanFilter.Builder>... booleanFilters) {
            booleanFilters(Stream.of(booleanFilters).map(c -> OcsfBooleanFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<OcsfNumberFilter.Builder> getNumberFilters() {
            List<OcsfNumberFilter.Builder> result = OcsfNumberFilterListCopier.copyToBuilder(this.numberFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNumberFilters(Collection<OcsfNumberFilter.BuilderImpl> numberFilters) {
            this.numberFilters = OcsfNumberFilterListCopier.copyFromBuilder(numberFilters);
        }

        @Override
        public final Builder numberFilters(Collection<OcsfNumberFilter> numberFilters) {
            this.numberFilters = OcsfNumberFilterListCopier.copy(numberFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder numberFilters(OcsfNumberFilter... numberFilters) {
            numberFilters(Arrays.asList(numberFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder numberFilters(Consumer<OcsfNumberFilter.Builder>... numberFilters) {
            numberFilters(Stream.of(numberFilters).map(c -> OcsfNumberFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<OcsfMapFilter.Builder> getMapFilters() {
            List<OcsfMapFilter.Builder> result = OcsfMapFilterListCopier.copyToBuilder(this.mapFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMapFilters(Collection<OcsfMapFilter.BuilderImpl> mapFilters) {
            this.mapFilters = OcsfMapFilterListCopier.copyFromBuilder(mapFilters);
        }

        @Override
        public final Builder mapFilters(Collection<OcsfMapFilter> mapFilters) {
            this.mapFilters = OcsfMapFilterListCopier.copy(mapFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mapFilters(OcsfMapFilter... mapFilters) {
            mapFilters(Arrays.asList(mapFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mapFilters(Consumer<OcsfMapFilter.Builder>... mapFilters) {
            mapFilters(Stream.of(mapFilters).map(c -> OcsfMapFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<OcsfIpFilter.Builder> getIpFilters() {
            List<OcsfIpFilter.Builder> result = OcsfIpFilterListCopier.copyToBuilder(this.ipFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpFilters(Collection<OcsfIpFilter.BuilderImpl> ipFilters) {
            this.ipFilters = OcsfIpFilterListCopier.copyFromBuilder(ipFilters);
        }

        @Override
        public final Builder ipFilters(Collection<OcsfIpFilter> ipFilters) {
            this.ipFilters = OcsfIpFilterListCopier.copy(ipFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipFilters(OcsfIpFilter... ipFilters) {
            ipFilters(Arrays.asList(ipFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipFilters(Consumer<OcsfIpFilter.Builder>... ipFilters) {
            ipFilters(Stream.of(ipFilters).map(c -> OcsfIpFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Builder> getNestedCompositeFilters() {
            List<Builder> result = CompositeFilterListCopier.copyToBuilder(this.nestedCompositeFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNestedCompositeFilters(Collection<BuilderImpl> nestedCompositeFilters) {
            this.nestedCompositeFilters = CompositeFilterListCopier.copyFromBuilder(nestedCompositeFilters);
        }

        @Override
        public final Builder nestedCompositeFilters(Collection<CompositeFilter> nestedCompositeFilters) {
            this.nestedCompositeFilters = CompositeFilterListCopier.copy(nestedCompositeFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nestedCompositeFilters(CompositeFilter... nestedCompositeFilters) {
            nestedCompositeFilters(Arrays.asList(nestedCompositeFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nestedCompositeFilters(Consumer<Builder>... nestedCompositeFilters) {
            nestedCompositeFilters(Stream.of(nestedCompositeFilters).map(c -> CompositeFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getOperator() {
            return operator;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        @Override
        public final Builder operator(AllowedOperators operator) {
            this.operator(operator == null ? null : operator.toString());
            return this;
        }

        @Override
        public CompositeFilter build() {
            return new CompositeFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
