/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about an external code repository with which you can connect your Amazon Web Services resources. The
 * connection is established through Amazon Inspector.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CodeRepositoryDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<CodeRepositoryDetails.Builder, CodeRepositoryDetails> {
    private static final SdkField<String> PROVIDER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProviderType").getter(getter(CodeRepositoryDetails::providerType)).setter(setter(Builder::providerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProviderType").build()).build();

    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProjectName").getter(getter(CodeRepositoryDetails::projectName)).setter(setter(Builder::projectName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectName").build()).build();

    private static final SdkField<String> CODE_SECURITY_INTEGRATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CodeSecurityIntegrationArn")
            .getter(getter(CodeRepositoryDetails::codeSecurityIntegrationArn))
            .setter(setter(Builder::codeSecurityIntegrationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeSecurityIntegrationArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVIDER_TYPE_FIELD,
            PROJECT_NAME_FIELD, CODE_SECURITY_INTEGRATION_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String providerType;

    private final String projectName;

    private final String codeSecurityIntegrationArn;

    private CodeRepositoryDetails(BuilderImpl builder) {
        this.providerType = builder.providerType;
        this.projectName = builder.projectName;
        this.codeSecurityIntegrationArn = builder.codeSecurityIntegrationArn;
    }

    /**
     * <p>
     * The type of repository provider.
     * </p>
     * 
     * @return The type of repository provider.
     */
    public final String providerType() {
        return providerType;
    }

    /**
     * <p>
     * The name of the project in the code repository.
     * </p>
     * 
     * @return The name of the project in the code repository.
     */
    public final String projectName() {
        return projectName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the code security integration associated with the repository.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the code security integration associated with the repository.
     */
    public final String codeSecurityIntegrationArn() {
        return codeSecurityIntegrationArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(providerType());
        hashCode = 31 * hashCode + Objects.hashCode(projectName());
        hashCode = 31 * hashCode + Objects.hashCode(codeSecurityIntegrationArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeRepositoryDetails)) {
            return false;
        }
        CodeRepositoryDetails other = (CodeRepositoryDetails) obj;
        return Objects.equals(providerType(), other.providerType()) && Objects.equals(projectName(), other.projectName())
                && Objects.equals(codeSecurityIntegrationArn(), other.codeSecurityIntegrationArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CodeRepositoryDetails").add("ProviderType", providerType()).add("ProjectName", projectName())
                .add("CodeSecurityIntegrationArn", codeSecurityIntegrationArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProviderType":
            return Optional.ofNullable(clazz.cast(providerType()));
        case "ProjectName":
            return Optional.ofNullable(clazz.cast(projectName()));
        case "CodeSecurityIntegrationArn":
            return Optional.ofNullable(clazz.cast(codeSecurityIntegrationArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProviderType", PROVIDER_TYPE_FIELD);
        map.put("ProjectName", PROJECT_NAME_FIELD);
        map.put("CodeSecurityIntegrationArn", CODE_SECURITY_INTEGRATION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CodeRepositoryDetails, T> g) {
        return obj -> g.apply((CodeRepositoryDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CodeRepositoryDetails> {
        /**
         * <p>
         * The type of repository provider.
         * </p>
         * 
         * @param providerType
         *        The type of repository provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerType(String providerType);

        /**
         * <p>
         * The name of the project in the code repository.
         * </p>
         * 
         * @param projectName
         *        The name of the project in the code repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectName(String projectName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the code security integration associated with the repository.
         * </p>
         * 
         * @param codeSecurityIntegrationArn
         *        The Amazon Resource Name (ARN) of the code security integration associated with the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeSecurityIntegrationArn(String codeSecurityIntegrationArn);
    }

    static final class BuilderImpl implements Builder {
        private String providerType;

        private String projectName;

        private String codeSecurityIntegrationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeRepositoryDetails model) {
            providerType(model.providerType);
            projectName(model.projectName);
            codeSecurityIntegrationArn(model.codeSecurityIntegrationArn);
        }

        public final String getProviderType() {
            return providerType;
        }

        public final void setProviderType(String providerType) {
            this.providerType = providerType;
        }

        @Override
        public final Builder providerType(String providerType) {
            this.providerType = providerType;
            return this;
        }

        public final String getProjectName() {
            return projectName;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final String getCodeSecurityIntegrationArn() {
            return codeSecurityIntegrationArn;
        }

        public final void setCodeSecurityIntegrationArn(String codeSecurityIntegrationArn) {
            this.codeSecurityIntegrationArn = codeSecurityIntegrationArn;
        }

        @Override
        public final Builder codeSecurityIntegrationArn(String codeSecurityIntegrationArn) {
            this.codeSecurityIntegrationArn = codeSecurityIntegrationArn;
            return this;
        }

        @Override
        public CodeRepositoryDetails build() {
            return new CodeRepositoryDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
