/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon Resource Name (ARN) and other details of the Amazon CloudWatch Logs log group that Amazon Route 53 is
 * publishing logs to.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CloudWatchLogsLogGroupArnConfigDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<CloudWatchLogsLogGroupArnConfigDetails.Builder, CloudWatchLogsLogGroupArnConfigDetails> {
    private static final SdkField<String> CLOUD_WATCH_LOGS_LOG_GROUP_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING).memberName("CloudWatchLogsLogGroupArn")
            .getter(getter(CloudWatchLogsLogGroupArnConfigDetails::cloudWatchLogsLogGroupArn))
            .setter(setter(Builder::cloudWatchLogsLogGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLogsLogGroupArn").build())
            .build();

    private static final SdkField<String> HOSTED_ZONE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HostedZoneId").getter(getter(CloudWatchLogsLogGroupArnConfigDetails::hostedZoneId))
            .setter(setter(Builder::hostedZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostedZoneId").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(CloudWatchLogsLogGroupArnConfigDetails::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CLOUD_WATCH_LOGS_LOG_GROUP_ARN_FIELD, HOSTED_ZONE_ID_FIELD, ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String cloudWatchLogsLogGroupArn;

    private final String hostedZoneId;

    private final String id;

    private CloudWatchLogsLogGroupArnConfigDetails(BuilderImpl builder) {
        this.cloudWatchLogsLogGroupArn = builder.cloudWatchLogsLogGroupArn;
        this.hostedZoneId = builder.hostedZoneId;
        this.id = builder.id;
    }

    /**
     * <p>
     * The ARN of the CloudWatch Logs log group that Route 53 is publishing logs to.
     * </p>
     * 
     * @return The ARN of the CloudWatch Logs log group that Route 53 is publishing logs to.
     */
    public final String cloudWatchLogsLogGroupArn() {
        return cloudWatchLogsLogGroupArn;
    }

    /**
     * <p>
     * The ID of the hosted zone that CloudWatch Logs is logging queries for.
     * </p>
     * 
     * @return The ID of the hosted zone that CloudWatch Logs is logging queries for.
     */
    public final String hostedZoneId() {
        return hostedZoneId;
    }

    /**
     * <p>
     * The ID for a DNS query logging configuration.
     * </p>
     * 
     * @return The ID for a DNS query logging configuration.
     */
    public final String id() {
        return id;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLogsLogGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(hostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchLogsLogGroupArnConfigDetails)) {
            return false;
        }
        CloudWatchLogsLogGroupArnConfigDetails other = (CloudWatchLogsLogGroupArnConfigDetails) obj;
        return Objects.equals(cloudWatchLogsLogGroupArn(), other.cloudWatchLogsLogGroupArn())
                && Objects.equals(hostedZoneId(), other.hostedZoneId()) && Objects.equals(id(), other.id());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CloudWatchLogsLogGroupArnConfigDetails")
                .add("CloudWatchLogsLogGroupArn", cloudWatchLogsLogGroupArn()).add("HostedZoneId", hostedZoneId())
                .add("Id", id()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CloudWatchLogsLogGroupArn":
            return Optional.ofNullable(clazz.cast(cloudWatchLogsLogGroupArn()));
        case "HostedZoneId":
            return Optional.ofNullable(clazz.cast(hostedZoneId()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CloudWatchLogsLogGroupArn", CLOUD_WATCH_LOGS_LOG_GROUP_ARN_FIELD);
        map.put("HostedZoneId", HOSTED_ZONE_ID_FIELD);
        map.put("Id", ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CloudWatchLogsLogGroupArnConfigDetails, T> g) {
        return obj -> g.apply((CloudWatchLogsLogGroupArnConfigDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CloudWatchLogsLogGroupArnConfigDetails> {
        /**
         * <p>
         * The ARN of the CloudWatch Logs log group that Route 53 is publishing logs to.
         * </p>
         * 
         * @param cloudWatchLogsLogGroupArn
         *        The ARN of the CloudWatch Logs log group that Route 53 is publishing logs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLogsLogGroupArn(String cloudWatchLogsLogGroupArn);

        /**
         * <p>
         * The ID of the hosted zone that CloudWatch Logs is logging queries for.
         * </p>
         * 
         * @param hostedZoneId
         *        The ID of the hosted zone that CloudWatch Logs is logging queries for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZoneId(String hostedZoneId);

        /**
         * <p>
         * The ID for a DNS query logging configuration.
         * </p>
         * 
         * @param id
         *        The ID for a DNS query logging configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);
    }

    static final class BuilderImpl implements Builder {
        private String cloudWatchLogsLogGroupArn;

        private String hostedZoneId;

        private String id;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchLogsLogGroupArnConfigDetails model) {
            cloudWatchLogsLogGroupArn(model.cloudWatchLogsLogGroupArn);
            hostedZoneId(model.hostedZoneId);
            id(model.id);
        }

        public final String getCloudWatchLogsLogGroupArn() {
            return cloudWatchLogsLogGroupArn;
        }

        public final void setCloudWatchLogsLogGroupArn(String cloudWatchLogsLogGroupArn) {
            this.cloudWatchLogsLogGroupArn = cloudWatchLogsLogGroupArn;
        }

        @Override
        public final Builder cloudWatchLogsLogGroupArn(String cloudWatchLogsLogGroupArn) {
            this.cloudWatchLogsLogGroupArn = cloudWatchLogsLogGroupArn;
            return this;
        }

        public final String getHostedZoneId() {
            return hostedZoneId;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public CloudWatchLogsLogGroupArnConfigDetails build() {
            return new CloudWatchLogsLogGroupArnConfigDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
