/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An occurrence of sensitive data detected in a Microsoft Excel workbook, comma-separated value (CSV) file, or
 * tab-separated value (TSV) file.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Cell implements SdkPojo, Serializable, ToCopyableBuilder<Cell.Builder, Cell> {
    private static final SdkField<Long> COLUMN_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Column")
            .getter(getter(Cell::column)).setter(setter(Builder::column))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Column").build()).build();

    private static final SdkField<Long> ROW_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Row")
            .getter(getter(Cell::row)).setter(setter(Builder::row))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Row").build()).build();

    private static final SdkField<String> COLUMN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ColumnName").getter(getter(Cell::columnName)).setter(setter(Builder::columnName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnName").build()).build();

    private static final SdkField<String> CELL_REFERENCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CellReference").getter(getter(Cell::cellReference)).setter(setter(Builder::cellReference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CellReference").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_FIELD, ROW_FIELD,
            COLUMN_NAME_FIELD, CELL_REFERENCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long column;

    private final Long row;

    private final String columnName;

    private final String cellReference;

    private Cell(BuilderImpl builder) {
        this.column = builder.column;
        this.row = builder.row;
        this.columnName = builder.columnName;
        this.cellReference = builder.cellReference;
    }

    /**
     * <p>
     * The column number of the column that contains the data. For a Microsoft Excel workbook, the column number
     * corresponds to the alphabetical column identifiers. For example, a value of 1 for Column corresponds to the A
     * column in the workbook.
     * </p>
     * 
     * @return The column number of the column that contains the data. For a Microsoft Excel workbook, the column number
     *         corresponds to the alphabetical column identifiers. For example, a value of 1 for Column corresponds to
     *         the A column in the workbook.
     */
    public final Long column() {
        return column;
    }

    /**
     * <p>
     * The row number of the row that contains the data.
     * </p>
     * 
     * @return The row number of the row that contains the data.
     */
    public final Long row() {
        return row;
    }

    /**
     * <p>
     * The name of the column that contains the data.
     * </p>
     * 
     * @return The name of the column that contains the data.
     */
    public final String columnName() {
        return columnName;
    }

    /**
     * <p>
     * For a Microsoft Excel workbook, provides the location of the cell, as an absolute cell reference, that contains
     * the data. For example, Sheet2!C5 for cell C5 on Sheet2.
     * </p>
     * 
     * @return For a Microsoft Excel workbook, provides the location of the cell, as an absolute cell reference, that
     *         contains the data. For example, Sheet2!C5 for cell C5 on Sheet2.
     */
    public final String cellReference() {
        return cellReference;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(column());
        hashCode = 31 * hashCode + Objects.hashCode(row());
        hashCode = 31 * hashCode + Objects.hashCode(columnName());
        hashCode = 31 * hashCode + Objects.hashCode(cellReference());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cell)) {
            return false;
        }
        Cell other = (Cell) obj;
        return Objects.equals(column(), other.column()) && Objects.equals(row(), other.row())
                && Objects.equals(columnName(), other.columnName()) && Objects.equals(cellReference(), other.cellReference());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Cell").add("Column", column()).add("Row", row()).add("ColumnName", columnName())
                .add("CellReference", cellReference()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Column":
            return Optional.ofNullable(clazz.cast(column()));
        case "Row":
            return Optional.ofNullable(clazz.cast(row()));
        case "ColumnName":
            return Optional.ofNullable(clazz.cast(columnName()));
        case "CellReference":
            return Optional.ofNullable(clazz.cast(cellReference()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Column", COLUMN_FIELD);
        map.put("Row", ROW_FIELD);
        map.put("ColumnName", COLUMN_NAME_FIELD);
        map.put("CellReference", CELL_REFERENCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Cell, T> g) {
        return obj -> g.apply((Cell) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Cell> {
        /**
         * <p>
         * The column number of the column that contains the data. For a Microsoft Excel workbook, the column number
         * corresponds to the alphabetical column identifiers. For example, a value of 1 for Column corresponds to the A
         * column in the workbook.
         * </p>
         * 
         * @param column
         *        The column number of the column that contains the data. For a Microsoft Excel workbook, the column
         *        number corresponds to the alphabetical column identifiers. For example, a value of 1 for Column
         *        corresponds to the A column in the workbook.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder column(Long column);

        /**
         * <p>
         * The row number of the row that contains the data.
         * </p>
         * 
         * @param row
         *        The row number of the row that contains the data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder row(Long row);

        /**
         * <p>
         * The name of the column that contains the data.
         * </p>
         * 
         * @param columnName
         *        The name of the column that contains the data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnName(String columnName);

        /**
         * <p>
         * For a Microsoft Excel workbook, provides the location of the cell, as an absolute cell reference, that
         * contains the data. For example, Sheet2!C5 for cell C5 on Sheet2.
         * </p>
         * 
         * @param cellReference
         *        For a Microsoft Excel workbook, provides the location of the cell, as an absolute cell reference, that
         *        contains the data. For example, Sheet2!C5 for cell C5 on Sheet2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cellReference(String cellReference);
    }

    static final class BuilderImpl implements Builder {
        private Long column;

        private Long row;

        private String columnName;

        private String cellReference;

        private BuilderImpl() {
        }

        private BuilderImpl(Cell model) {
            column(model.column);
            row(model.row);
            columnName(model.columnName);
            cellReference(model.cellReference);
        }

        public final Long getColumn() {
            return column;
        }

        public final void setColumn(Long column) {
            this.column = column;
        }

        @Override
        public final Builder column(Long column) {
            this.column = column;
            return this;
        }

        public final Long getRow() {
            return row;
        }

        public final void setRow(Long row) {
            this.row = row;
        }

        @Override
        public final Builder row(Long row) {
            this.row = row;
            return this;
        }

        public final String getColumnName() {
            return columnName;
        }

        public final void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        @Override
        public final Builder columnName(String columnName) {
            this.columnName = columnName;
            return this;
        }

        public final String getCellReference() {
            return cellReference;
        }

        public final void setCellReference(String cellReference) {
            this.cellReference = cellReference;
        }

        @Override
        public final Builder cellReference(String cellReference) {
            this.cellReference = cellReference;
            return this;
        }

        @Override
        public Cell build() {
            return new Cell(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
