/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class BatchUpdateFindingsV2UnprocessedFindingsListCopier {
    static List<BatchUpdateFindingsV2UnprocessedFinding> copy(
            Collection<? extends BatchUpdateFindingsV2UnprocessedFinding> batchUpdateFindingsV2UnprocessedFindingsListParam) {
        List<BatchUpdateFindingsV2UnprocessedFinding> list;
        if (batchUpdateFindingsV2UnprocessedFindingsListParam == null
                || batchUpdateFindingsV2UnprocessedFindingsListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<BatchUpdateFindingsV2UnprocessedFinding> modifiableList = new ArrayList<>(
                    batchUpdateFindingsV2UnprocessedFindingsListParam.size());
            batchUpdateFindingsV2UnprocessedFindingsListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<BatchUpdateFindingsV2UnprocessedFinding> copyFromBuilder(
            Collection<? extends BatchUpdateFindingsV2UnprocessedFinding.Builder> batchUpdateFindingsV2UnprocessedFindingsListParam) {
        List<BatchUpdateFindingsV2UnprocessedFinding> list;
        if (batchUpdateFindingsV2UnprocessedFindingsListParam == null
                || batchUpdateFindingsV2UnprocessedFindingsListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<BatchUpdateFindingsV2UnprocessedFinding> modifiableList = new ArrayList<>(
                    batchUpdateFindingsV2UnprocessedFindingsListParam.size());
            batchUpdateFindingsV2UnprocessedFindingsListParam.forEach(entry -> {
                BatchUpdateFindingsV2UnprocessedFinding member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<BatchUpdateFindingsV2UnprocessedFinding.Builder> copyToBuilder(
            Collection<? extends BatchUpdateFindingsV2UnprocessedFinding> batchUpdateFindingsV2UnprocessedFindingsListParam) {
        List<BatchUpdateFindingsV2UnprocessedFinding.Builder> list;
        if (batchUpdateFindingsV2UnprocessedFindingsListParam == null
                || batchUpdateFindingsV2UnprocessedFindingsListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<BatchUpdateFindingsV2UnprocessedFinding.Builder> modifiableList = new ArrayList<>(
                    batchUpdateFindingsV2UnprocessedFindingsListParam.size());
            batchUpdateFindingsV2UnprocessedFindingsListParam.forEach(entry -> {
                BatchUpdateFindingsV2UnprocessedFinding.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
