/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchUpdateFindingsV2Response extends SecurityHubResponse implements
        ToCopyableBuilder<BatchUpdateFindingsV2Response.Builder, BatchUpdateFindingsV2Response> {
    private static final SdkField<List<BatchUpdateFindingsV2ProcessedFinding>> PROCESSED_FINDINGS_FIELD = SdkField
            .<List<BatchUpdateFindingsV2ProcessedFinding>> builder(MarshallingType.LIST)
            .memberName("ProcessedFindings")
            .getter(getter(BatchUpdateFindingsV2Response::processedFindings))
            .setter(setter(Builder::processedFindings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessedFindings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchUpdateFindingsV2ProcessedFinding> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchUpdateFindingsV2ProcessedFinding::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<BatchUpdateFindingsV2UnprocessedFinding>> UNPROCESSED_FINDINGS_FIELD = SdkField
            .<List<BatchUpdateFindingsV2UnprocessedFinding>> builder(MarshallingType.LIST)
            .memberName("UnprocessedFindings")
            .getter(getter(BatchUpdateFindingsV2Response::unprocessedFindings))
            .setter(setter(Builder::unprocessedFindings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnprocessedFindings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchUpdateFindingsV2UnprocessedFinding> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchUpdateFindingsV2UnprocessedFinding::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROCESSED_FINDINGS_FIELD,
            UNPROCESSED_FINDINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<BatchUpdateFindingsV2ProcessedFinding> processedFindings;

    private final List<BatchUpdateFindingsV2UnprocessedFinding> unprocessedFindings;

    private BatchUpdateFindingsV2Response(BuilderImpl builder) {
        super(builder);
        this.processedFindings = builder.processedFindings;
        this.unprocessedFindings = builder.unprocessedFindings;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProcessedFindings property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasProcessedFindings() {
        return processedFindings != null && !(processedFindings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of findings that were updated successfully.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProcessedFindings} method.
     * </p>
     * 
     * @return The list of findings that were updated successfully.
     */
    public final List<BatchUpdateFindingsV2ProcessedFinding> processedFindings() {
        return processedFindings;
    }

    /**
     * For responses, this returns true if the service returned a value for the UnprocessedFindings property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUnprocessedFindings() {
        return unprocessedFindings != null && !(unprocessedFindings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of V2 findings that were not updated.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUnprocessedFindings} method.
     * </p>
     * 
     * @return The list of V2 findings that were not updated.
     */
    public final List<BatchUpdateFindingsV2UnprocessedFinding> unprocessedFindings() {
        return unprocessedFindings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasProcessedFindings() ? processedFindings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUnprocessedFindings() ? unprocessedFindings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateFindingsV2Response)) {
            return false;
        }
        BatchUpdateFindingsV2Response other = (BatchUpdateFindingsV2Response) obj;
        return hasProcessedFindings() == other.hasProcessedFindings()
                && Objects.equals(processedFindings(), other.processedFindings())
                && hasUnprocessedFindings() == other.hasUnprocessedFindings()
                && Objects.equals(unprocessedFindings(), other.unprocessedFindings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchUpdateFindingsV2Response")
                .add("ProcessedFindings", hasProcessedFindings() ? processedFindings() : null)
                .add("UnprocessedFindings", hasUnprocessedFindings() ? unprocessedFindings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProcessedFindings":
            return Optional.ofNullable(clazz.cast(processedFindings()));
        case "UnprocessedFindings":
            return Optional.ofNullable(clazz.cast(unprocessedFindings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProcessedFindings", PROCESSED_FINDINGS_FIELD);
        map.put("UnprocessedFindings", UNPROCESSED_FINDINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateFindingsV2Response, T> g) {
        return obj -> g.apply((BatchUpdateFindingsV2Response) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SecurityHubResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchUpdateFindingsV2Response> {
        /**
         * <p>
         * The list of findings that were updated successfully.
         * </p>
         * 
         * @param processedFindings
         *        The list of findings that were updated successfully.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processedFindings(Collection<BatchUpdateFindingsV2ProcessedFinding> processedFindings);

        /**
         * <p>
         * The list of findings that were updated successfully.
         * </p>
         * 
         * @param processedFindings
         *        The list of findings that were updated successfully.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processedFindings(BatchUpdateFindingsV2ProcessedFinding... processedFindings);

        /**
         * <p>
         * The list of findings that were updated successfully.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.BatchUpdateFindingsV2ProcessedFinding.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.BatchUpdateFindingsV2ProcessedFinding#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.BatchUpdateFindingsV2ProcessedFinding.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #processedFindings(List<BatchUpdateFindingsV2ProcessedFinding>)}.
         * 
         * @param processedFindings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.BatchUpdateFindingsV2ProcessedFinding.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #processedFindings(java.util.Collection<BatchUpdateFindingsV2ProcessedFinding>)
         */
        Builder processedFindings(Consumer<BatchUpdateFindingsV2ProcessedFinding.Builder>... processedFindings);

        /**
         * <p>
         * The list of V2 findings that were not updated.
         * </p>
         * 
         * @param unprocessedFindings
         *        The list of V2 findings that were not updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedFindings(Collection<BatchUpdateFindingsV2UnprocessedFinding> unprocessedFindings);

        /**
         * <p>
         * The list of V2 findings that were not updated.
         * </p>
         * 
         * @param unprocessedFindings
         *        The list of V2 findings that were not updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedFindings(BatchUpdateFindingsV2UnprocessedFinding... unprocessedFindings);

        /**
         * <p>
         * The list of V2 findings that were not updated.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.BatchUpdateFindingsV2UnprocessedFinding.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.BatchUpdateFindingsV2UnprocessedFinding#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.BatchUpdateFindingsV2UnprocessedFinding.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #unprocessedFindings(List<BatchUpdateFindingsV2UnprocessedFinding>)}.
         * 
         * @param unprocessedFindings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.BatchUpdateFindingsV2UnprocessedFinding.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unprocessedFindings(java.util.Collection<BatchUpdateFindingsV2UnprocessedFinding>)
         */
        Builder unprocessedFindings(Consumer<BatchUpdateFindingsV2UnprocessedFinding.Builder>... unprocessedFindings);
    }

    static final class BuilderImpl extends SecurityHubResponse.BuilderImpl implements Builder {
        private List<BatchUpdateFindingsV2ProcessedFinding> processedFindings = DefaultSdkAutoConstructList.getInstance();

        private List<BatchUpdateFindingsV2UnprocessedFinding> unprocessedFindings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateFindingsV2Response model) {
            super(model);
            processedFindings(model.processedFindings);
            unprocessedFindings(model.unprocessedFindings);
        }

        public final List<BatchUpdateFindingsV2ProcessedFinding.Builder> getProcessedFindings() {
            List<BatchUpdateFindingsV2ProcessedFinding.Builder> result = BatchUpdateFindingsV2ProcessedFindingsListCopier
                    .copyToBuilder(this.processedFindings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProcessedFindings(Collection<BatchUpdateFindingsV2ProcessedFinding.BuilderImpl> processedFindings) {
            this.processedFindings = BatchUpdateFindingsV2ProcessedFindingsListCopier.copyFromBuilder(processedFindings);
        }

        @Override
        public final Builder processedFindings(Collection<BatchUpdateFindingsV2ProcessedFinding> processedFindings) {
            this.processedFindings = BatchUpdateFindingsV2ProcessedFindingsListCopier.copy(processedFindings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processedFindings(BatchUpdateFindingsV2ProcessedFinding... processedFindings) {
            processedFindings(Arrays.asList(processedFindings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processedFindings(Consumer<BatchUpdateFindingsV2ProcessedFinding.Builder>... processedFindings) {
            processedFindings(Stream.of(processedFindings)
                    .map(c -> BatchUpdateFindingsV2ProcessedFinding.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<BatchUpdateFindingsV2UnprocessedFinding.Builder> getUnprocessedFindings() {
            List<BatchUpdateFindingsV2UnprocessedFinding.Builder> result = BatchUpdateFindingsV2UnprocessedFindingsListCopier
                    .copyToBuilder(this.unprocessedFindings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnprocessedFindings(
                Collection<BatchUpdateFindingsV2UnprocessedFinding.BuilderImpl> unprocessedFindings) {
            this.unprocessedFindings = BatchUpdateFindingsV2UnprocessedFindingsListCopier.copyFromBuilder(unprocessedFindings);
        }

        @Override
        public final Builder unprocessedFindings(Collection<BatchUpdateFindingsV2UnprocessedFinding> unprocessedFindings) {
            this.unprocessedFindings = BatchUpdateFindingsV2UnprocessedFindingsListCopier.copy(unprocessedFindings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedFindings(BatchUpdateFindingsV2UnprocessedFinding... unprocessedFindings) {
            unprocessedFindings(Arrays.asList(unprocessedFindings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedFindings(Consumer<BatchUpdateFindingsV2UnprocessedFinding.Builder>... unprocessedFindings) {
            unprocessedFindings(Stream.of(unprocessedFindings)
                    .map(c -> BatchUpdateFindingsV2UnprocessedFinding.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchUpdateFindingsV2Response build() {
            return new BatchUpdateFindingsV2Response(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
