/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The list of findings that were updated.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchUpdateFindingsV2ProcessedFinding implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchUpdateFindingsV2ProcessedFinding.Builder, BatchUpdateFindingsV2ProcessedFinding> {
    private static final SdkField<OcsfFindingIdentifier> FINDING_IDENTIFIER_FIELD = SdkField
            .<OcsfFindingIdentifier> builder(MarshallingType.SDK_POJO).memberName("FindingIdentifier")
            .getter(getter(BatchUpdateFindingsV2ProcessedFinding::findingIdentifier)).setter(setter(Builder::findingIdentifier))
            .constructor(OcsfFindingIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FindingIdentifier").build()).build();

    private static final SdkField<String> METADATA_UID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetadataUid").getter(getter(BatchUpdateFindingsV2ProcessedFinding::metadataUid))
            .setter(setter(Builder::metadataUid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataUid").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINDING_IDENTIFIER_FIELD,
            METADATA_UID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final OcsfFindingIdentifier findingIdentifier;

    private final String metadataUid;

    private BatchUpdateFindingsV2ProcessedFinding(BuilderImpl builder) {
        this.findingIdentifier = builder.findingIdentifier;
        this.metadataUid = builder.metadataUid;
    }

    /**
     * <p>
     * The finding identifier of a processed finding.
     * </p>
     * 
     * @return The finding identifier of a processed finding.
     */
    public final OcsfFindingIdentifier findingIdentifier() {
        return findingIdentifier;
    }

    /**
     * <p>
     * The metadata.uid of a processed finding.
     * </p>
     * 
     * @return The metadata.uid of a processed finding.
     */
    public final String metadataUid() {
        return metadataUid;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(findingIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(metadataUid());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateFindingsV2ProcessedFinding)) {
            return false;
        }
        BatchUpdateFindingsV2ProcessedFinding other = (BatchUpdateFindingsV2ProcessedFinding) obj;
        return Objects.equals(findingIdentifier(), other.findingIdentifier())
                && Objects.equals(metadataUid(), other.metadataUid());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchUpdateFindingsV2ProcessedFinding").add("FindingIdentifier", findingIdentifier())
                .add("MetadataUid", metadataUid()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FindingIdentifier":
            return Optional.ofNullable(clazz.cast(findingIdentifier()));
        case "MetadataUid":
            return Optional.ofNullable(clazz.cast(metadataUid()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FindingIdentifier", FINDING_IDENTIFIER_FIELD);
        map.put("MetadataUid", METADATA_UID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateFindingsV2ProcessedFinding, T> g) {
        return obj -> g.apply((BatchUpdateFindingsV2ProcessedFinding) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchUpdateFindingsV2ProcessedFinding> {
        /**
         * <p>
         * The finding identifier of a processed finding.
         * </p>
         * 
         * @param findingIdentifier
         *        The finding identifier of a processed finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingIdentifier(OcsfFindingIdentifier findingIdentifier);

        /**
         * <p>
         * The finding identifier of a processed finding.
         * </p>
         * This is a convenience method that creates an instance of the {@link OcsfFindingIdentifier.Builder} avoiding
         * the need to create one manually via {@link OcsfFindingIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OcsfFindingIdentifier.Builder#build()} is called immediately and
         * its result is passed to {@link #findingIdentifier(OcsfFindingIdentifier)}.
         * 
         * @param findingIdentifier
         *        a consumer that will call methods on {@link OcsfFindingIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #findingIdentifier(OcsfFindingIdentifier)
         */
        default Builder findingIdentifier(Consumer<OcsfFindingIdentifier.Builder> findingIdentifier) {
            return findingIdentifier(OcsfFindingIdentifier.builder().applyMutation(findingIdentifier).build());
        }

        /**
         * <p>
         * The metadata.uid of a processed finding.
         * </p>
         * 
         * @param metadataUid
         *        The metadata.uid of a processed finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataUid(String metadataUid);
    }

    static final class BuilderImpl implements Builder {
        private OcsfFindingIdentifier findingIdentifier;

        private String metadataUid;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateFindingsV2ProcessedFinding model) {
            findingIdentifier(model.findingIdentifier);
            metadataUid(model.metadataUid);
        }

        public final OcsfFindingIdentifier.Builder getFindingIdentifier() {
            return findingIdentifier != null ? findingIdentifier.toBuilder() : null;
        }

        public final void setFindingIdentifier(OcsfFindingIdentifier.BuilderImpl findingIdentifier) {
            this.findingIdentifier = findingIdentifier != null ? findingIdentifier.build() : null;
        }

        @Override
        public final Builder findingIdentifier(OcsfFindingIdentifier findingIdentifier) {
            this.findingIdentifier = findingIdentifier;
            return this;
        }

        public final String getMetadataUid() {
            return metadataUid;
        }

        public final void setMetadataUid(String metadataUid) {
            this.metadataUid = metadataUid;
        }

        @Override
        public final Builder metadataUid(String metadataUid) {
            this.metadataUid = metadataUid;
            return this;
        }

        @Override
        public BatchUpdateFindingsV2ProcessedFinding build() {
            return new BatchUpdateFindingsV2ProcessedFinding(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
