/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetStandardsControlAssociationsRequest extends SecurityHubRequest implements
        ToCopyableBuilder<BatchGetStandardsControlAssociationsRequest.Builder, BatchGetStandardsControlAssociationsRequest> {
    private static final SdkField<List<StandardsControlAssociationId>> STANDARDS_CONTROL_ASSOCIATION_IDS_FIELD = SdkField
            .<List<StandardsControlAssociationId>> builder(MarshallingType.LIST)
            .memberName("StandardsControlAssociationIds")
            .getter(getter(BatchGetStandardsControlAssociationsRequest::standardsControlAssociationIds))
            .setter(setter(Builder::standardsControlAssociationIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardsControlAssociationIds")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StandardsControlAssociationId> builder(MarshallingType.SDK_POJO)
                                            .constructor(StandardsControlAssociationId::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(STANDARDS_CONTROL_ASSOCIATION_IDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<StandardsControlAssociationId> standardsControlAssociationIds;

    private BatchGetStandardsControlAssociationsRequest(BuilderImpl builder) {
        super(builder);
        this.standardsControlAssociationIds = builder.standardsControlAssociationIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the StandardsControlAssociationIds property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasStandardsControlAssociationIds() {
        return standardsControlAssociationIds != null && !(standardsControlAssociationIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array with one or more objects that includes a security control (identified with
     * <code>SecurityControlId</code>, <code>SecurityControlArn</code>, or a mix of both parameters) and the Amazon
     * Resource Name (ARN) of a standard. This field is used to query the enablement status of a control in a specified
     * standard. The security control ID or ARN is the same across standards.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStandardsControlAssociationIds} method.
     * </p>
     * 
     * @return An array with one or more objects that includes a security control (identified with
     *         <code>SecurityControlId</code>, <code>SecurityControlArn</code>, or a mix of both parameters) and the
     *         Amazon Resource Name (ARN) of a standard. This field is used to query the enablement status of a control
     *         in a specified standard. The security control ID or ARN is the same across standards.
     */
    public final List<StandardsControlAssociationId> standardsControlAssociationIds() {
        return standardsControlAssociationIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasStandardsControlAssociationIds() ? standardsControlAssociationIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetStandardsControlAssociationsRequest)) {
            return false;
        }
        BatchGetStandardsControlAssociationsRequest other = (BatchGetStandardsControlAssociationsRequest) obj;
        return hasStandardsControlAssociationIds() == other.hasStandardsControlAssociationIds()
                && Objects.equals(standardsControlAssociationIds(), other.standardsControlAssociationIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("BatchGetStandardsControlAssociationsRequest")
                .add("StandardsControlAssociationIds",
                        hasStandardsControlAssociationIds() ? standardsControlAssociationIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StandardsControlAssociationIds":
            return Optional.ofNullable(clazz.cast(standardsControlAssociationIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StandardsControlAssociationIds", STANDARDS_CONTROL_ASSOCIATION_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetStandardsControlAssociationsRequest, T> g) {
        return obj -> g.apply((BatchGetStandardsControlAssociationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SecurityHubRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchGetStandardsControlAssociationsRequest> {
        /**
         * <p>
         * An array with one or more objects that includes a security control (identified with
         * <code>SecurityControlId</code>, <code>SecurityControlArn</code>, or a mix of both parameters) and the Amazon
         * Resource Name (ARN) of a standard. This field is used to query the enablement status of a control in a
         * specified standard. The security control ID or ARN is the same across standards.
         * </p>
         * 
         * @param standardsControlAssociationIds
         *        An array with one or more objects that includes a security control (identified with
         *        <code>SecurityControlId</code>, <code>SecurityControlArn</code>, or a mix of both parameters) and the
         *        Amazon Resource Name (ARN) of a standard. This field is used to query the enablement status of a
         *        control in a specified standard. The security control ID or ARN is the same across standards.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standardsControlAssociationIds(Collection<StandardsControlAssociationId> standardsControlAssociationIds);

        /**
         * <p>
         * An array with one or more objects that includes a security control (identified with
         * <code>SecurityControlId</code>, <code>SecurityControlArn</code>, or a mix of both parameters) and the Amazon
         * Resource Name (ARN) of a standard. This field is used to query the enablement status of a control in a
         * specified standard. The security control ID or ARN is the same across standards.
         * </p>
         * 
         * @param standardsControlAssociationIds
         *        An array with one or more objects that includes a security control (identified with
         *        <code>SecurityControlId</code>, <code>SecurityControlArn</code>, or a mix of both parameters) and the
         *        Amazon Resource Name (ARN) of a standard. This field is used to query the enablement status of a
         *        control in a specified standard. The security control ID or ARN is the same across standards.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standardsControlAssociationIds(StandardsControlAssociationId... standardsControlAssociationIds);

        /**
         * <p>
         * An array with one or more objects that includes a security control (identified with
         * <code>SecurityControlId</code>, <code>SecurityControlArn</code>, or a mix of both parameters) and the Amazon
         * Resource Name (ARN) of a standard. This field is used to query the enablement status of a control in a
         * specified standard. The security control ID or ARN is the same across standards.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.StandardsControlAssociationId.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.StandardsControlAssociationId#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.StandardsControlAssociationId.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #standardsControlAssociationIds(List<StandardsControlAssociationId>)}.
         * 
         * @param standardsControlAssociationIds
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.StandardsControlAssociationId.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #standardsControlAssociationIds(java.util.Collection<StandardsControlAssociationId>)
         */
        Builder standardsControlAssociationIds(Consumer<StandardsControlAssociationId.Builder>... standardsControlAssociationIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecurityHubRequest.BuilderImpl implements Builder {
        private List<StandardsControlAssociationId> standardsControlAssociationIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetStandardsControlAssociationsRequest model) {
            super(model);
            standardsControlAssociationIds(model.standardsControlAssociationIds);
        }

        public final List<StandardsControlAssociationId.Builder> getStandardsControlAssociationIds() {
            List<StandardsControlAssociationId.Builder> result = StandardsControlAssociationIdsCopier
                    .copyToBuilder(this.standardsControlAssociationIds);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStandardsControlAssociationIds(
                Collection<StandardsControlAssociationId.BuilderImpl> standardsControlAssociationIds) {
            this.standardsControlAssociationIds = StandardsControlAssociationIdsCopier
                    .copyFromBuilder(standardsControlAssociationIds);
        }

        @Override
        public final Builder standardsControlAssociationIds(
                Collection<StandardsControlAssociationId> standardsControlAssociationIds) {
            this.standardsControlAssociationIds = StandardsControlAssociationIdsCopier.copy(standardsControlAssociationIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder standardsControlAssociationIds(StandardsControlAssociationId... standardsControlAssociationIds) {
            standardsControlAssociationIds(Arrays.asList(standardsControlAssociationIds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder standardsControlAssociationIds(
                Consumer<StandardsControlAssociationId.Builder>... standardsControlAssociationIds) {
            standardsControlAssociationIds(Stream.of(standardsControlAssociationIds)
                    .map(c -> StandardsControlAssociationId.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetStandardsControlAssociationsRequest build() {
            return new BatchGetStandardsControlAssociationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
