/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Used for CAPTCHA and challenge token settings. Determines how long a CAPTCHA or challenge timestamp remains valid
 * after WAF updates it for a successful CAPTCHA or challenge response.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsWafv2WebAclCaptchaConfigImmunityTimePropertyDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsWafv2WebAclCaptchaConfigImmunityTimePropertyDetails.Builder, AwsWafv2WebAclCaptchaConfigImmunityTimePropertyDetails> {
    private static final SdkField<Long> IMMUNITY_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ImmunityTime").getter(getter(AwsWafv2WebAclCaptchaConfigImmunityTimePropertyDetails::immunityTime))
            .setter(setter(Builder::immunityTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImmunityTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMMUNITY_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long immunityTime;

    private AwsWafv2WebAclCaptchaConfigImmunityTimePropertyDetails(BuilderImpl builder) {
        this.immunityTime = builder.immunityTime;
    }

    /**
     * <p>
     * The amount of time, in seconds, that a CAPTCHA or challenge timestamp is considered valid by WAF.
     * </p>
     * 
     * @return The amount of time, in seconds, that a CAPTCHA or challenge timestamp is considered valid by WAF.
     */
    public final Long immunityTime() {
        return immunityTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(immunityTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsWafv2WebAclCaptchaConfigImmunityTimePropertyDetails)) {
            return false;
        }
        AwsWafv2WebAclCaptchaConfigImmunityTimePropertyDetails other = (AwsWafv2WebAclCaptchaConfigImmunityTimePropertyDetails) obj;
        return Objects.equals(immunityTime(), other.immunityTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsWafv2WebAclCaptchaConfigImmunityTimePropertyDetails").add("ImmunityTime", immunityTime())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImmunityTime":
            return Optional.ofNullable(clazz.cast(immunityTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ImmunityTime", IMMUNITY_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsWafv2WebAclCaptchaConfigImmunityTimePropertyDetails, T> g) {
        return obj -> g.apply((AwsWafv2WebAclCaptchaConfigImmunityTimePropertyDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsWafv2WebAclCaptchaConfigImmunityTimePropertyDetails> {
        /**
         * <p>
         * The amount of time, in seconds, that a CAPTCHA or challenge timestamp is considered valid by WAF.
         * </p>
         * 
         * @param immunityTime
         *        The amount of time, in seconds, that a CAPTCHA or challenge timestamp is considered valid by WAF.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder immunityTime(Long immunityTime);
    }

    static final class BuilderImpl implements Builder {
        private Long immunityTime;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsWafv2WebAclCaptchaConfigImmunityTimePropertyDetails model) {
            immunityTime(model.immunityTime);
        }

        public final Long getImmunityTime() {
            return immunityTime;
        }

        public final void setImmunityTime(Long immunityTime) {
            this.immunityTime = immunityTime;
        }

        @Override
        public final Builder immunityTime(Long immunityTime) {
            this.immunityTime = immunityTime;
            return this;
        }

        @Override
        public AwsWafv2WebAclCaptchaConfigImmunityTimePropertyDetails build() {
            return new AwsWafv2WebAclCaptchaConfigImmunityTimePropertyDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
