/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines and enables Amazon CloudWatch metrics and web request sample collection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsWafv2VisibilityConfigDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsWafv2VisibilityConfigDetails.Builder, AwsWafv2VisibilityConfigDetails> {
    private static final SdkField<Boolean> CLOUD_WATCH_METRICS_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("CloudWatchMetricsEnabled")
            .getter(getter(AwsWafv2VisibilityConfigDetails::cloudWatchMetricsEnabled))
            .setter(setter(Builder::cloudWatchMetricsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchMetricsEnabled").build())
            .build();

    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricName").getter(getter(AwsWafv2VisibilityConfigDetails::metricName))
            .setter(setter(Builder::metricName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()).build();

    private static final SdkField<Boolean> SAMPLED_REQUESTS_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SampledRequestsEnabled").getter(getter(AwsWafv2VisibilityConfigDetails::sampledRequestsEnabled))
            .setter(setter(Builder::sampledRequestsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SampledRequestsEnabled").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CLOUD_WATCH_METRICS_ENABLED_FIELD, METRIC_NAME_FIELD, SAMPLED_REQUESTS_ENABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean cloudWatchMetricsEnabled;

    private final String metricName;

    private final Boolean sampledRequestsEnabled;

    private AwsWafv2VisibilityConfigDetails(BuilderImpl builder) {
        this.cloudWatchMetricsEnabled = builder.cloudWatchMetricsEnabled;
        this.metricName = builder.metricName;
        this.sampledRequestsEnabled = builder.sampledRequestsEnabled;
    }

    /**
     * <p>
     * A boolean indicating whether the associated resource sends metrics to Amazon CloudWatch. For the list of
     * available metrics, see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/monitoring-cloudwatch.html#waf-metrics">WAF metrics
     * and dimensions</a> in the <i>WAF Developer Guide</i>.
     * </p>
     * 
     * @return A boolean indicating whether the associated resource sends metrics to Amazon CloudWatch. For the list of
     *         available metrics, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/monitoring-cloudwatch.html#waf-metrics">WAF
     *         metrics and dimensions</a> in the <i>WAF Developer Guide</i>.
     */
    public final Boolean cloudWatchMetricsEnabled() {
        return cloudWatchMetricsEnabled;
    }

    /**
     * <p>
     * A name of the Amazon CloudWatch metric.
     * </p>
     * 
     * @return A name of the Amazon CloudWatch metric.
     */
    public final String metricName() {
        return metricName;
    }

    /**
     * <p>
     * A boolean indicating whether WAF should store a sampling of the web requests that match the rules. You can view
     * the sampled requests through the WAF console.
     * </p>
     * 
     * @return A boolean indicating whether WAF should store a sampling of the web requests that match the rules. You
     *         can view the sampled requests through the WAF console.
     */
    public final Boolean sampledRequestsEnabled() {
        return sampledRequestsEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchMetricsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(metricName());
        hashCode = 31 * hashCode + Objects.hashCode(sampledRequestsEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsWafv2VisibilityConfigDetails)) {
            return false;
        }
        AwsWafv2VisibilityConfigDetails other = (AwsWafv2VisibilityConfigDetails) obj;
        return Objects.equals(cloudWatchMetricsEnabled(), other.cloudWatchMetricsEnabled())
                && Objects.equals(metricName(), other.metricName())
                && Objects.equals(sampledRequestsEnabled(), other.sampledRequestsEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsWafv2VisibilityConfigDetails").add("CloudWatchMetricsEnabled", cloudWatchMetricsEnabled())
                .add("MetricName", metricName()).add("SampledRequestsEnabled", sampledRequestsEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CloudWatchMetricsEnabled":
            return Optional.ofNullable(clazz.cast(cloudWatchMetricsEnabled()));
        case "MetricName":
            return Optional.ofNullable(clazz.cast(metricName()));
        case "SampledRequestsEnabled":
            return Optional.ofNullable(clazz.cast(sampledRequestsEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CloudWatchMetricsEnabled", CLOUD_WATCH_METRICS_ENABLED_FIELD);
        map.put("MetricName", METRIC_NAME_FIELD);
        map.put("SampledRequestsEnabled", SAMPLED_REQUESTS_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsWafv2VisibilityConfigDetails, T> g) {
        return obj -> g.apply((AwsWafv2VisibilityConfigDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsWafv2VisibilityConfigDetails> {
        /**
         * <p>
         * A boolean indicating whether the associated resource sends metrics to Amazon CloudWatch. For the list of
         * available metrics, see <a
         * href="https://docs.aws.amazon.com/waf/latest/developerguide/monitoring-cloudwatch.html#waf-metrics">WAF
         * metrics and dimensions</a> in the <i>WAF Developer Guide</i>.
         * </p>
         * 
         * @param cloudWatchMetricsEnabled
         *        A boolean indicating whether the associated resource sends metrics to Amazon CloudWatch. For the list
         *        of available metrics, see <a
         *        href="https://docs.aws.amazon.com/waf/latest/developerguide/monitoring-cloudwatch.html#waf-metrics"
         *        >WAF metrics and dimensions</a> in the <i>WAF Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchMetricsEnabled(Boolean cloudWatchMetricsEnabled);

        /**
         * <p>
         * A name of the Amazon CloudWatch metric.
         * </p>
         * 
         * @param metricName
         *        A name of the Amazon CloudWatch metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * A boolean indicating whether WAF should store a sampling of the web requests that match the rules. You can
         * view the sampled requests through the WAF console.
         * </p>
         * 
         * @param sampledRequestsEnabled
         *        A boolean indicating whether WAF should store a sampling of the web requests that match the rules. You
         *        can view the sampled requests through the WAF console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampledRequestsEnabled(Boolean sampledRequestsEnabled);
    }

    static final class BuilderImpl implements Builder {
        private Boolean cloudWatchMetricsEnabled;

        private String metricName;

        private Boolean sampledRequestsEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsWafv2VisibilityConfigDetails model) {
            cloudWatchMetricsEnabled(model.cloudWatchMetricsEnabled);
            metricName(model.metricName);
            sampledRequestsEnabled(model.sampledRequestsEnabled);
        }

        public final Boolean getCloudWatchMetricsEnabled() {
            return cloudWatchMetricsEnabled;
        }

        public final void setCloudWatchMetricsEnabled(Boolean cloudWatchMetricsEnabled) {
            this.cloudWatchMetricsEnabled = cloudWatchMetricsEnabled;
        }

        @Override
        public final Builder cloudWatchMetricsEnabled(Boolean cloudWatchMetricsEnabled) {
            this.cloudWatchMetricsEnabled = cloudWatchMetricsEnabled;
            return this;
        }

        public final String getMetricName() {
            return metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final Boolean getSampledRequestsEnabled() {
            return sampledRequestsEnabled;
        }

        public final void setSampledRequestsEnabled(Boolean sampledRequestsEnabled) {
            this.sampledRequestsEnabled = sampledRequestsEnabled;
        }

        @Override
        public final Builder sampledRequestsEnabled(Boolean sampledRequestsEnabled) {
            this.sampledRequestsEnabled = sampledRequestsEnabled;
            return this;
        }

        @Override
        public AwsWafv2VisibilityConfigDetails build() {
            return new AwsWafv2VisibilityConfigDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
