/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies that WAF should run a CAPTCHA check against the request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsWafv2RulesActionCaptchaDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsWafv2RulesActionCaptchaDetails.Builder, AwsWafv2RulesActionCaptchaDetails> {
    private static final SdkField<AwsWafv2CustomRequestHandlingDetails> CUSTOM_REQUEST_HANDLING_FIELD = SdkField
            .<AwsWafv2CustomRequestHandlingDetails> builder(MarshallingType.SDK_POJO).memberName("CustomRequestHandling")
            .getter(getter(AwsWafv2RulesActionCaptchaDetails::customRequestHandling))
            .setter(setter(Builder::customRequestHandling)).constructor(AwsWafv2CustomRequestHandlingDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomRequestHandling").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(CUSTOM_REQUEST_HANDLING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AwsWafv2CustomRequestHandlingDetails customRequestHandling;

    private AwsWafv2RulesActionCaptchaDetails(BuilderImpl builder) {
        this.customRequestHandling = builder.customRequestHandling;
    }

    /**
     * <p>
     * Defines custom handling for the web request, used when the CAPTCHA inspection determines that the request's token
     * is valid and unexpired. For more information, see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web
     * requests and responses in WAF</a> in the <i>WAF Developer Guide.</i>.
     * </p>
     * 
     * @return Defines custom handling for the web request, used when the CAPTCHA inspection determines that the
     *         request's token is valid and unexpired. For more information, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing
     *         web requests and responses in WAF</a> in the <i>WAF Developer Guide.</i>.
     */
    public final AwsWafv2CustomRequestHandlingDetails customRequestHandling() {
        return customRequestHandling;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(customRequestHandling());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsWafv2RulesActionCaptchaDetails)) {
            return false;
        }
        AwsWafv2RulesActionCaptchaDetails other = (AwsWafv2RulesActionCaptchaDetails) obj;
        return Objects.equals(customRequestHandling(), other.customRequestHandling());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsWafv2RulesActionCaptchaDetails").add("CustomRequestHandling", customRequestHandling())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CustomRequestHandling":
            return Optional.ofNullable(clazz.cast(customRequestHandling()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CustomRequestHandling", CUSTOM_REQUEST_HANDLING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsWafv2RulesActionCaptchaDetails, T> g) {
        return obj -> g.apply((AwsWafv2RulesActionCaptchaDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsWafv2RulesActionCaptchaDetails> {
        /**
         * <p>
         * Defines custom handling for the web request, used when the CAPTCHA inspection determines that the request's
         * token is valid and unexpired. For more information, see <a
         * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web
         * requests and responses in WAF</a> in the <i>WAF Developer Guide.</i>.
         * </p>
         * 
         * @param customRequestHandling
         *        Defines custom handling for the web request, used when the CAPTCHA inspection determines that the
         *        request's token is valid and unexpired. For more information, see <a
         *        href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html"
         *        >Customizing web requests and responses in WAF</a> in the <i>WAF Developer Guide.</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customRequestHandling(AwsWafv2CustomRequestHandlingDetails customRequestHandling);

        /**
         * <p>
         * Defines custom handling for the web request, used when the CAPTCHA inspection determines that the request's
         * token is valid and unexpired. For more information, see <a
         * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web
         * requests and responses in WAF</a> in the <i>WAF Developer Guide.</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsWafv2CustomRequestHandlingDetails.Builder} avoiding the need to create one manually via
         * {@link AwsWafv2CustomRequestHandlingDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsWafv2CustomRequestHandlingDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #customRequestHandling(AwsWafv2CustomRequestHandlingDetails)}.
         * 
         * @param customRequestHandling
         *        a consumer that will call methods on {@link AwsWafv2CustomRequestHandlingDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customRequestHandling(AwsWafv2CustomRequestHandlingDetails)
         */
        default Builder customRequestHandling(Consumer<AwsWafv2CustomRequestHandlingDetails.Builder> customRequestHandling) {
            return customRequestHandling(AwsWafv2CustomRequestHandlingDetails.builder().applyMutation(customRequestHandling)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AwsWafv2CustomRequestHandlingDetails customRequestHandling;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsWafv2RulesActionCaptchaDetails model) {
            customRequestHandling(model.customRequestHandling);
        }

        public final AwsWafv2CustomRequestHandlingDetails.Builder getCustomRequestHandling() {
            return customRequestHandling != null ? customRequestHandling.toBuilder() : null;
        }

        public final void setCustomRequestHandling(AwsWafv2CustomRequestHandlingDetails.BuilderImpl customRequestHandling) {
            this.customRequestHandling = customRequestHandling != null ? customRequestHandling.build() : null;
        }

        @Override
        public final Builder customRequestHandling(AwsWafv2CustomRequestHandlingDetails customRequestHandling) {
            this.customRequestHandling = customRequestHandling;
            return this;
        }

        @Override
        public AwsWafv2RulesActionCaptchaDetails build() {
            return new AwsWafv2RulesActionCaptchaDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
