/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Custom request handling behavior that inserts custom headers into a web request. WAF uses custom request handling
 * when the rule action doesn't block the request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsWafv2CustomRequestHandlingDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsWafv2CustomRequestHandlingDetails.Builder, AwsWafv2CustomRequestHandlingDetails> {
    private static final SdkField<List<AwsWafv2CustomHttpHeader>> INSERT_HEADERS_FIELD = SdkField
            .<List<AwsWafv2CustomHttpHeader>> builder(MarshallingType.LIST)
            .memberName("InsertHeaders")
            .getter(getter(AwsWafv2CustomRequestHandlingDetails::insertHeaders))
            .setter(setter(Builder::insertHeaders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsertHeaders").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsWafv2CustomHttpHeader> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsWafv2CustomHttpHeader::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSERT_HEADERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<AwsWafv2CustomHttpHeader> insertHeaders;

    private AwsWafv2CustomRequestHandlingDetails(BuilderImpl builder) {
        this.insertHeaders = builder.insertHeaders;
    }

    /**
     * For responses, this returns true if the service returned a value for the InsertHeaders property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInsertHeaders() {
        return insertHeaders != null && !(insertHeaders instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The HTTP headers to insert into the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInsertHeaders} method.
     * </p>
     * 
     * @return The HTTP headers to insert into the request.
     */
    public final List<AwsWafv2CustomHttpHeader> insertHeaders() {
        return insertHeaders;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasInsertHeaders() ? insertHeaders() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsWafv2CustomRequestHandlingDetails)) {
            return false;
        }
        AwsWafv2CustomRequestHandlingDetails other = (AwsWafv2CustomRequestHandlingDetails) obj;
        return hasInsertHeaders() == other.hasInsertHeaders() && Objects.equals(insertHeaders(), other.insertHeaders());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsWafv2CustomRequestHandlingDetails")
                .add("InsertHeaders", hasInsertHeaders() ? insertHeaders() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InsertHeaders":
            return Optional.ofNullable(clazz.cast(insertHeaders()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InsertHeaders", INSERT_HEADERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsWafv2CustomRequestHandlingDetails, T> g) {
        return obj -> g.apply((AwsWafv2CustomRequestHandlingDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsWafv2CustomRequestHandlingDetails> {
        /**
         * <p>
         * The HTTP headers to insert into the request.
         * </p>
         * 
         * @param insertHeaders
         *        The HTTP headers to insert into the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insertHeaders(Collection<AwsWafv2CustomHttpHeader> insertHeaders);

        /**
         * <p>
         * The HTTP headers to insert into the request.
         * </p>
         * 
         * @param insertHeaders
         *        The HTTP headers to insert into the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insertHeaders(AwsWafv2CustomHttpHeader... insertHeaders);

        /**
         * <p>
         * The HTTP headers to insert into the request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsWafv2CustomHttpHeader.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsWafv2CustomHttpHeader#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsWafv2CustomHttpHeader.Builder#build()} is called
         * immediately and its result is passed to {@link #insertHeaders(List<AwsWafv2CustomHttpHeader>)}.
         * 
         * @param insertHeaders
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsWafv2CustomHttpHeader.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #insertHeaders(java.util.Collection<AwsWafv2CustomHttpHeader>)
         */
        Builder insertHeaders(Consumer<AwsWafv2CustomHttpHeader.Builder>... insertHeaders);
    }

    static final class BuilderImpl implements Builder {
        private List<AwsWafv2CustomHttpHeader> insertHeaders = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsWafv2CustomRequestHandlingDetails model) {
            insertHeaders(model.insertHeaders);
        }

        public final List<AwsWafv2CustomHttpHeader.Builder> getInsertHeaders() {
            List<AwsWafv2CustomHttpHeader.Builder> result = AwsWafv2InsertHeadersListCopier.copyToBuilder(this.insertHeaders);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInsertHeaders(Collection<AwsWafv2CustomHttpHeader.BuilderImpl> insertHeaders) {
            this.insertHeaders = AwsWafv2InsertHeadersListCopier.copyFromBuilder(insertHeaders);
        }

        @Override
        public final Builder insertHeaders(Collection<AwsWafv2CustomHttpHeader> insertHeaders) {
            this.insertHeaders = AwsWafv2InsertHeadersListCopier.copy(insertHeaders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insertHeaders(AwsWafv2CustomHttpHeader... insertHeaders) {
            insertHeaders(Arrays.asList(insertHeaders));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insertHeaders(Consumer<AwsWafv2CustomHttpHeader.Builder>... insertHeaders) {
            insertHeaders(Stream.of(insertHeaders).map(c -> AwsWafv2CustomHttpHeader.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AwsWafv2CustomRequestHandlingDetails build() {
            return new AwsWafv2CustomRequestHandlingDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
