/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the web access control list (web ACL). The web ACL contains the rules that identify the
 * requests that you want to allow, block, or count.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsWafRegionalWebAclDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsWafRegionalWebAclDetails.Builder, AwsWafRegionalWebAclDetails> {
    private static final SdkField<String> DEFAULT_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultAction").getter(getter(AwsWafRegionalWebAclDetails::defaultAction))
            .setter(setter(Builder::defaultAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultAction").build()).build();

    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricName").getter(getter(AwsWafRegionalWebAclDetails::metricName)).setter(setter(Builder::metricName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AwsWafRegionalWebAclDetails::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<AwsWafRegionalWebAclRulesListDetails>> RULES_LIST_FIELD = SdkField
            .<List<AwsWafRegionalWebAclRulesListDetails>> builder(MarshallingType.LIST)
            .memberName("RulesList")
            .getter(getter(AwsWafRegionalWebAclDetails::rulesList))
            .setter(setter(Builder::rulesList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RulesList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsWafRegionalWebAclRulesListDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsWafRegionalWebAclRulesListDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> WEB_ACL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WebAclId").getter(getter(AwsWafRegionalWebAclDetails::webAclId)).setter(setter(Builder::webAclId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebAclId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_ACTION_FIELD,
            METRIC_NAME_FIELD, NAME_FIELD, RULES_LIST_FIELD, WEB_ACL_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String defaultAction;

    private final String metricName;

    private final String name;

    private final List<AwsWafRegionalWebAclRulesListDetails> rulesList;

    private final String webAclId;

    private AwsWafRegionalWebAclDetails(BuilderImpl builder) {
        this.defaultAction = builder.defaultAction;
        this.metricName = builder.metricName;
        this.name = builder.name;
        this.rulesList = builder.rulesList;
        this.webAclId = builder.webAclId;
    }

    /**
     * <p>
     * The action to perform if none of the rules contained in the web ACL match.
     * </p>
     * 
     * @return The action to perform if none of the rules contained in the web ACL match.
     */
    public final String defaultAction() {
        return defaultAction;
    }

    /**
     * <p>
     * A name for the metrics for this web ACL.
     * </p>
     * 
     * @return A name for the metrics for this web ACL.
     */
    public final String metricName() {
        return metricName;
    }

    /**
     * <p>
     * A descriptive name for the web ACL.
     * </p>
     * 
     * @return A descriptive name for the web ACL.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the RulesList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRulesList() {
        return rulesList != null && !(rulesList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array that contains the action for each rule in a web ACL, the priority of the rule, and the ID of the rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRulesList} method.
     * </p>
     * 
     * @return An array that contains the action for each rule in a web ACL, the priority of the rule, and the ID of the
     *         rule.
     */
    public final List<AwsWafRegionalWebAclRulesListDetails> rulesList() {
        return rulesList;
    }

    /**
     * <p>
     * The ID of the web ACL.
     * </p>
     * 
     * @return The ID of the web ACL.
     */
    public final String webAclId() {
        return webAclId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(defaultAction());
        hashCode = 31 * hashCode + Objects.hashCode(metricName());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasRulesList() ? rulesList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(webAclId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsWafRegionalWebAclDetails)) {
            return false;
        }
        AwsWafRegionalWebAclDetails other = (AwsWafRegionalWebAclDetails) obj;
        return Objects.equals(defaultAction(), other.defaultAction()) && Objects.equals(metricName(), other.metricName())
                && Objects.equals(name(), other.name()) && hasRulesList() == other.hasRulesList()
                && Objects.equals(rulesList(), other.rulesList()) && Objects.equals(webAclId(), other.webAclId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsWafRegionalWebAclDetails").add("DefaultAction", defaultAction())
                .add("MetricName", metricName()).add("Name", name()).add("RulesList", hasRulesList() ? rulesList() : null)
                .add("WebAclId", webAclId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DefaultAction":
            return Optional.ofNullable(clazz.cast(defaultAction()));
        case "MetricName":
            return Optional.ofNullable(clazz.cast(metricName()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "RulesList":
            return Optional.ofNullable(clazz.cast(rulesList()));
        case "WebAclId":
            return Optional.ofNullable(clazz.cast(webAclId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DefaultAction", DEFAULT_ACTION_FIELD);
        map.put("MetricName", METRIC_NAME_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("RulesList", RULES_LIST_FIELD);
        map.put("WebAclId", WEB_ACL_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsWafRegionalWebAclDetails, T> g) {
        return obj -> g.apply((AwsWafRegionalWebAclDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsWafRegionalWebAclDetails> {
        /**
         * <p>
         * The action to perform if none of the rules contained in the web ACL match.
         * </p>
         * 
         * @param defaultAction
         *        The action to perform if none of the rules contained in the web ACL match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultAction(String defaultAction);

        /**
         * <p>
         * A name for the metrics for this web ACL.
         * </p>
         * 
         * @param metricName
         *        A name for the metrics for this web ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * A descriptive name for the web ACL.
         * </p>
         * 
         * @param name
         *        A descriptive name for the web ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * An array that contains the action for each rule in a web ACL, the priority of the rule, and the ID of the
         * rule.
         * </p>
         * 
         * @param rulesList
         *        An array that contains the action for each rule in a web ACL, the priority of the rule, and the ID of
         *        the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rulesList(Collection<AwsWafRegionalWebAclRulesListDetails> rulesList);

        /**
         * <p>
         * An array that contains the action for each rule in a web ACL, the priority of the rule, and the ID of the
         * rule.
         * </p>
         * 
         * @param rulesList
         *        An array that contains the action for each rule in a web ACL, the priority of the rule, and the ID of
         *        the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rulesList(AwsWafRegionalWebAclRulesListDetails... rulesList);

        /**
         * <p>
         * An array that contains the action for each rule in a web ACL, the priority of the rule, and the ID of the
         * rule.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsWafRegionalWebAclRulesListDetails.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsWafRegionalWebAclRulesListDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsWafRegionalWebAclRulesListDetails.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #rulesList(List<AwsWafRegionalWebAclRulesListDetails>)}.
         * 
         * @param rulesList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsWafRegionalWebAclRulesListDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rulesList(java.util.Collection<AwsWafRegionalWebAclRulesListDetails>)
         */
        Builder rulesList(Consumer<AwsWafRegionalWebAclRulesListDetails.Builder>... rulesList);

        /**
         * <p>
         * The ID of the web ACL.
         * </p>
         * 
         * @param webAclId
         *        The ID of the web ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webAclId(String webAclId);
    }

    static final class BuilderImpl implements Builder {
        private String defaultAction;

        private String metricName;

        private String name;

        private List<AwsWafRegionalWebAclRulesListDetails> rulesList = DefaultSdkAutoConstructList.getInstance();

        private String webAclId;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsWafRegionalWebAclDetails model) {
            defaultAction(model.defaultAction);
            metricName(model.metricName);
            name(model.name);
            rulesList(model.rulesList);
            webAclId(model.webAclId);
        }

        public final String getDefaultAction() {
            return defaultAction;
        }

        public final void setDefaultAction(String defaultAction) {
            this.defaultAction = defaultAction;
        }

        @Override
        public final Builder defaultAction(String defaultAction) {
            this.defaultAction = defaultAction;
            return this;
        }

        public final String getMetricName() {
            return metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<AwsWafRegionalWebAclRulesListDetails.Builder> getRulesList() {
            List<AwsWafRegionalWebAclRulesListDetails.Builder> result = AwsWafRegionalWebAclRulesListCopier
                    .copyToBuilder(this.rulesList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRulesList(Collection<AwsWafRegionalWebAclRulesListDetails.BuilderImpl> rulesList) {
            this.rulesList = AwsWafRegionalWebAclRulesListCopier.copyFromBuilder(rulesList);
        }

        @Override
        public final Builder rulesList(Collection<AwsWafRegionalWebAclRulesListDetails> rulesList) {
            this.rulesList = AwsWafRegionalWebAclRulesListCopier.copy(rulesList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rulesList(AwsWafRegionalWebAclRulesListDetails... rulesList) {
            rulesList(Arrays.asList(rulesList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rulesList(Consumer<AwsWafRegionalWebAclRulesListDetails.Builder>... rulesList) {
            rulesList(Stream.of(rulesList).map(c -> AwsWafRegionalWebAclRulesListDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getWebAclId() {
            return webAclId;
        }

        public final void setWebAclId(String webAclId) {
            this.webAclId = webAclId;
        }

        @Override
        public final Builder webAclId(String webAclId) {
            this.webAclId = webAclId;
            return this;
        }

        @Override
        public AwsWafRegionalWebAclDetails build() {
            return new AwsWafRegionalWebAclDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
