/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the rules attached to a rule group
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsWafRegionalRuleGroupRulesDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsWafRegionalRuleGroupRulesDetails.Builder, AwsWafRegionalRuleGroupRulesDetails> {
    private static final SdkField<AwsWafRegionalRuleGroupRulesActionDetails> ACTION_FIELD = SdkField
            .<AwsWafRegionalRuleGroupRulesActionDetails> builder(MarshallingType.SDK_POJO).memberName("Action")
            .getter(getter(AwsWafRegionalRuleGroupRulesDetails::action)).setter(setter(Builder::action))
            .constructor(AwsWafRegionalRuleGroupRulesActionDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Priority").getter(getter(AwsWafRegionalRuleGroupRulesDetails::priority))
            .setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").build()).build();

    private static final SdkField<String> RULE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("RuleId")
            .getter(getter(AwsWafRegionalRuleGroupRulesDetails::ruleId)).setter(setter(Builder::ruleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleId").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(AwsWafRegionalRuleGroupRulesDetails::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, PRIORITY_FIELD,
            RULE_ID_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AwsWafRegionalRuleGroupRulesActionDetails action;

    private final Integer priority;

    private final String ruleId;

    private final String type;

    private AwsWafRegionalRuleGroupRulesDetails(BuilderImpl builder) {
        this.action = builder.action;
        this.priority = builder.priority;
        this.ruleId = builder.ruleId;
        this.type = builder.type;
    }

    /**
     * <p>
     * The action that WAF should take on a web request when it matches the criteria defined in the rule.
     * </p>
     * 
     * @return The action that WAF should take on a web request when it matches the criteria defined in the rule.
     */
    public final AwsWafRegionalRuleGroupRulesActionDetails action() {
        return action;
    }

    /**
     * <p>
     * If you define more than one rule in a web ACL, WAF evaluates each request against the rules in order based on the
     * value of <code>Priority</code>.
     * </p>
     * 
     * @return If you define more than one rule in a web ACL, WAF evaluates each request against the rules in order
     *         based on the value of <code>Priority</code>.
     */
    public final Integer priority() {
        return priority;
    }

    /**
     * <p>
     * The ID for a rule.
     * </p>
     * 
     * @return The ID for a rule.
     */
    public final String ruleId() {
        return ruleId;
    }

    /**
     * <p>
     * The type of rule in the rule group.
     * </p>
     * 
     * @return The type of rule in the rule group.
     */
    public final String type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(action());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        hashCode = 31 * hashCode + Objects.hashCode(ruleId());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsWafRegionalRuleGroupRulesDetails)) {
            return false;
        }
        AwsWafRegionalRuleGroupRulesDetails other = (AwsWafRegionalRuleGroupRulesDetails) obj;
        return Objects.equals(action(), other.action()) && Objects.equals(priority(), other.priority())
                && Objects.equals(ruleId(), other.ruleId()) && Objects.equals(type(), other.type());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsWafRegionalRuleGroupRulesDetails").add("Action", action()).add("Priority", priority())
                .add("RuleId", ruleId()).add("Type", type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Action":
            return Optional.ofNullable(clazz.cast(action()));
        case "Priority":
            return Optional.ofNullable(clazz.cast(priority()));
        case "RuleId":
            return Optional.ofNullable(clazz.cast(ruleId()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Action", ACTION_FIELD);
        map.put("Priority", PRIORITY_FIELD);
        map.put("RuleId", RULE_ID_FIELD);
        map.put("Type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsWafRegionalRuleGroupRulesDetails, T> g) {
        return obj -> g.apply((AwsWafRegionalRuleGroupRulesDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsWafRegionalRuleGroupRulesDetails> {
        /**
         * <p>
         * The action that WAF should take on a web request when it matches the criteria defined in the rule.
         * </p>
         * 
         * @param action
         *        The action that WAF should take on a web request when it matches the criteria defined in the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(AwsWafRegionalRuleGroupRulesActionDetails action);

        /**
         * <p>
         * The action that WAF should take on a web request when it matches the criteria defined in the rule.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsWafRegionalRuleGroupRulesActionDetails.Builder} avoiding the need to create one manually via
         * {@link AwsWafRegionalRuleGroupRulesActionDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsWafRegionalRuleGroupRulesActionDetails.Builder#build()} is
         * called immediately and its result is passed to {@link #action(AwsWafRegionalRuleGroupRulesActionDetails)}.
         * 
         * @param action
         *        a consumer that will call methods on {@link AwsWafRegionalRuleGroupRulesActionDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #action(AwsWafRegionalRuleGroupRulesActionDetails)
         */
        default Builder action(Consumer<AwsWafRegionalRuleGroupRulesActionDetails.Builder> action) {
            return action(AwsWafRegionalRuleGroupRulesActionDetails.builder().applyMutation(action).build());
        }

        /**
         * <p>
         * If you define more than one rule in a web ACL, WAF evaluates each request against the rules in order based on
         * the value of <code>Priority</code>.
         * </p>
         * 
         * @param priority
         *        If you define more than one rule in a web ACL, WAF evaluates each request against the rules in order
         *        based on the value of <code>Priority</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);

        /**
         * <p>
         * The ID for a rule.
         * </p>
         * 
         * @param ruleId
         *        The ID for a rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleId(String ruleId);

        /**
         * <p>
         * The type of rule in the rule group.
         * </p>
         * 
         * @param type
         *        The type of rule in the rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);
    }

    static final class BuilderImpl implements Builder {
        private AwsWafRegionalRuleGroupRulesActionDetails action;

        private Integer priority;

        private String ruleId;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsWafRegionalRuleGroupRulesDetails model) {
            action(model.action);
            priority(model.priority);
            ruleId(model.ruleId);
            type(model.type);
        }

        public final AwsWafRegionalRuleGroupRulesActionDetails.Builder getAction() {
            return action != null ? action.toBuilder() : null;
        }

        public final void setAction(AwsWafRegionalRuleGroupRulesActionDetails.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        @Override
        public final Builder action(AwsWafRegionalRuleGroupRulesActionDetails action) {
            this.action = action;
            return this;
        }

        public final Integer getPriority() {
            return priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final String getRuleId() {
            return ruleId;
        }

        public final void setRuleId(String ruleId) {
            this.ruleId = ruleId;
        }

        @Override
        public final Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public AwsWafRegionalRuleGroupRulesDetails build() {
            return new AwsWafRegionalRuleGroupRulesDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
