/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about an Secrets Manager secret.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsSecretsManagerSecretDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsSecretsManagerSecretDetails.Builder, AwsSecretsManagerSecretDetails> {
    private static final SdkField<AwsSecretsManagerSecretRotationRules> ROTATION_RULES_FIELD = SdkField
            .<AwsSecretsManagerSecretRotationRules> builder(MarshallingType.SDK_POJO).memberName("RotationRules")
            .getter(getter(AwsSecretsManagerSecretDetails::rotationRules)).setter(setter(Builder::rotationRules))
            .constructor(AwsSecretsManagerSecretRotationRules::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RotationRules").build()).build();

    private static final SdkField<Boolean> ROTATION_OCCURRED_WITHIN_FREQUENCY_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RotationOccurredWithinFrequency")
            .getter(getter(AwsSecretsManagerSecretDetails::rotationOccurredWithinFrequency))
            .setter(setter(Builder::rotationOccurredWithinFrequency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RotationOccurredWithinFrequency")
                    .build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(AwsSecretsManagerSecretDetails::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<Boolean> ROTATION_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RotationEnabled").getter(getter(AwsSecretsManagerSecretDetails::rotationEnabled))
            .setter(setter(Builder::rotationEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RotationEnabled").build()).build();

    private static final SdkField<String> ROTATION_LAMBDA_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RotationLambdaArn").getter(getter(AwsSecretsManagerSecretDetails::rotationLambdaArn))
            .setter(setter(Builder::rotationLambdaArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RotationLambdaArn").build()).build();

    private static final SdkField<Boolean> DELETED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Deleted").getter(getter(AwsSecretsManagerSecretDetails::deleted)).setter(setter(Builder::deleted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Deleted").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AwsSecretsManagerSecretDetails::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(AwsSecretsManagerSecretDetails::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROTATION_RULES_FIELD,
            ROTATION_OCCURRED_WITHIN_FREQUENCY_FIELD, KMS_KEY_ID_FIELD, ROTATION_ENABLED_FIELD, ROTATION_LAMBDA_ARN_FIELD,
            DELETED_FIELD, NAME_FIELD, DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AwsSecretsManagerSecretRotationRules rotationRules;

    private final Boolean rotationOccurredWithinFrequency;

    private final String kmsKeyId;

    private final Boolean rotationEnabled;

    private final String rotationLambdaArn;

    private final Boolean deleted;

    private final String name;

    private final String description;

    private AwsSecretsManagerSecretDetails(BuilderImpl builder) {
        this.rotationRules = builder.rotationRules;
        this.rotationOccurredWithinFrequency = builder.rotationOccurredWithinFrequency;
        this.kmsKeyId = builder.kmsKeyId;
        this.rotationEnabled = builder.rotationEnabled;
        this.rotationLambdaArn = builder.rotationLambdaArn;
        this.deleted = builder.deleted;
        this.name = builder.name;
        this.description = builder.description;
    }

    /**
     * <p>
     * Defines the rotation schedule for the secret.
     * </p>
     * 
     * @return Defines the rotation schedule for the secret.
     */
    public final AwsSecretsManagerSecretRotationRules rotationRules() {
        return rotationRules;
    }

    /**
     * <p>
     * Whether the rotation occurred within the specified rotation frequency.
     * </p>
     * 
     * @return Whether the rotation occurred within the specified rotation frequency.
     */
    public final Boolean rotationOccurredWithinFrequency() {
        return rotationOccurredWithinFrequency;
    }

    /**
     * <p>
     * The ARN, Key ID, or alias of the KMS key used to encrypt the <code>SecretString</code> or
     * <code>SecretBinary</code> values for versions of this secret.
     * </p>
     * 
     * @return The ARN, Key ID, or alias of the KMS key used to encrypt the <code>SecretString</code> or
     *         <code>SecretBinary</code> values for versions of this secret.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * Whether rotation is enabled.
     * </p>
     * 
     * @return Whether rotation is enabled.
     */
    public final Boolean rotationEnabled() {
        return rotationEnabled;
    }

    /**
     * <p>
     * The ARN of the Lambda function that rotates the secret.
     * </p>
     * 
     * @return The ARN of the Lambda function that rotates the secret.
     */
    public final String rotationLambdaArn() {
        return rotationLambdaArn;
    }

    /**
     * <p>
     * Whether the secret is deleted.
     * </p>
     * 
     * @return Whether the secret is deleted.
     */
    public final Boolean deleted() {
        return deleted;
    }

    /**
     * <p>
     * The name of the secret.
     * </p>
     * 
     * @return The name of the secret.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The user-provided description of the secret.
     * </p>
     * 
     * @return The user-provided description of the secret.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(rotationRules());
        hashCode = 31 * hashCode + Objects.hashCode(rotationOccurredWithinFrequency());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(rotationEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(rotationLambdaArn());
        hashCode = 31 * hashCode + Objects.hashCode(deleted());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsSecretsManagerSecretDetails)) {
            return false;
        }
        AwsSecretsManagerSecretDetails other = (AwsSecretsManagerSecretDetails) obj;
        return Objects.equals(rotationRules(), other.rotationRules())
                && Objects.equals(rotationOccurredWithinFrequency(), other.rotationOccurredWithinFrequency())
                && Objects.equals(kmsKeyId(), other.kmsKeyId()) && Objects.equals(rotationEnabled(), other.rotationEnabled())
                && Objects.equals(rotationLambdaArn(), other.rotationLambdaArn()) && Objects.equals(deleted(), other.deleted())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsSecretsManagerSecretDetails").add("RotationRules", rotationRules())
                .add("RotationOccurredWithinFrequency", rotationOccurredWithinFrequency()).add("KmsKeyId", kmsKeyId())
                .add("RotationEnabled", rotationEnabled()).add("RotationLambdaArn", rotationLambdaArn())
                .add("Deleted", deleted()).add("Name", name()).add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RotationRules":
            return Optional.ofNullable(clazz.cast(rotationRules()));
        case "RotationOccurredWithinFrequency":
            return Optional.ofNullable(clazz.cast(rotationOccurredWithinFrequency()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "RotationEnabled":
            return Optional.ofNullable(clazz.cast(rotationEnabled()));
        case "RotationLambdaArn":
            return Optional.ofNullable(clazz.cast(rotationLambdaArn()));
        case "Deleted":
            return Optional.ofNullable(clazz.cast(deleted()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RotationRules", ROTATION_RULES_FIELD);
        map.put("RotationOccurredWithinFrequency", ROTATION_OCCURRED_WITHIN_FREQUENCY_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("RotationEnabled", ROTATION_ENABLED_FIELD);
        map.put("RotationLambdaArn", ROTATION_LAMBDA_ARN_FIELD);
        map.put("Deleted", DELETED_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsSecretsManagerSecretDetails, T> g) {
        return obj -> g.apply((AwsSecretsManagerSecretDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsSecretsManagerSecretDetails> {
        /**
         * <p>
         * Defines the rotation schedule for the secret.
         * </p>
         * 
         * @param rotationRules
         *        Defines the rotation schedule for the secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rotationRules(AwsSecretsManagerSecretRotationRules rotationRules);

        /**
         * <p>
         * Defines the rotation schedule for the secret.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsSecretsManagerSecretRotationRules.Builder} avoiding the need to create one manually via
         * {@link AwsSecretsManagerSecretRotationRules#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsSecretsManagerSecretRotationRules.Builder#build()} is called
         * immediately and its result is passed to {@link #rotationRules(AwsSecretsManagerSecretRotationRules)}.
         * 
         * @param rotationRules
         *        a consumer that will call methods on {@link AwsSecretsManagerSecretRotationRules.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rotationRules(AwsSecretsManagerSecretRotationRules)
         */
        default Builder rotationRules(Consumer<AwsSecretsManagerSecretRotationRules.Builder> rotationRules) {
            return rotationRules(AwsSecretsManagerSecretRotationRules.builder().applyMutation(rotationRules).build());
        }

        /**
         * <p>
         * Whether the rotation occurred within the specified rotation frequency.
         * </p>
         * 
         * @param rotationOccurredWithinFrequency
         *        Whether the rotation occurred within the specified rotation frequency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rotationOccurredWithinFrequency(Boolean rotationOccurredWithinFrequency);

        /**
         * <p>
         * The ARN, Key ID, or alias of the KMS key used to encrypt the <code>SecretString</code> or
         * <code>SecretBinary</code> values for versions of this secret.
         * </p>
         * 
         * @param kmsKeyId
         *        The ARN, Key ID, or alias of the KMS key used to encrypt the <code>SecretString</code> or
         *        <code>SecretBinary</code> values for versions of this secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * Whether rotation is enabled.
         * </p>
         * 
         * @param rotationEnabled
         *        Whether rotation is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rotationEnabled(Boolean rotationEnabled);

        /**
         * <p>
         * The ARN of the Lambda function that rotates the secret.
         * </p>
         * 
         * @param rotationLambdaArn
         *        The ARN of the Lambda function that rotates the secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rotationLambdaArn(String rotationLambdaArn);

        /**
         * <p>
         * Whether the secret is deleted.
         * </p>
         * 
         * @param deleted
         *        Whether the secret is deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleted(Boolean deleted);

        /**
         * <p>
         * The name of the secret.
         * </p>
         * 
         * @param name
         *        The name of the secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The user-provided description of the secret.
         * </p>
         * 
         * @param description
         *        The user-provided description of the secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private AwsSecretsManagerSecretRotationRules rotationRules;

        private Boolean rotationOccurredWithinFrequency;

        private String kmsKeyId;

        private Boolean rotationEnabled;

        private String rotationLambdaArn;

        private Boolean deleted;

        private String name;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsSecretsManagerSecretDetails model) {
            rotationRules(model.rotationRules);
            rotationOccurredWithinFrequency(model.rotationOccurredWithinFrequency);
            kmsKeyId(model.kmsKeyId);
            rotationEnabled(model.rotationEnabled);
            rotationLambdaArn(model.rotationLambdaArn);
            deleted(model.deleted);
            name(model.name);
            description(model.description);
        }

        public final AwsSecretsManagerSecretRotationRules.Builder getRotationRules() {
            return rotationRules != null ? rotationRules.toBuilder() : null;
        }

        public final void setRotationRules(AwsSecretsManagerSecretRotationRules.BuilderImpl rotationRules) {
            this.rotationRules = rotationRules != null ? rotationRules.build() : null;
        }

        @Override
        public final Builder rotationRules(AwsSecretsManagerSecretRotationRules rotationRules) {
            this.rotationRules = rotationRules;
            return this;
        }

        public final Boolean getRotationOccurredWithinFrequency() {
            return rotationOccurredWithinFrequency;
        }

        public final void setRotationOccurredWithinFrequency(Boolean rotationOccurredWithinFrequency) {
            this.rotationOccurredWithinFrequency = rotationOccurredWithinFrequency;
        }

        @Override
        public final Builder rotationOccurredWithinFrequency(Boolean rotationOccurredWithinFrequency) {
            this.rotationOccurredWithinFrequency = rotationOccurredWithinFrequency;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Boolean getRotationEnabled() {
            return rotationEnabled;
        }

        public final void setRotationEnabled(Boolean rotationEnabled) {
            this.rotationEnabled = rotationEnabled;
        }

        @Override
        public final Builder rotationEnabled(Boolean rotationEnabled) {
            this.rotationEnabled = rotationEnabled;
            return this;
        }

        public final String getRotationLambdaArn() {
            return rotationLambdaArn;
        }

        public final void setRotationLambdaArn(String rotationLambdaArn) {
            this.rotationLambdaArn = rotationLambdaArn;
        }

        @Override
        public final Builder rotationLambdaArn(String rotationLambdaArn) {
            this.rotationLambdaArn = rotationLambdaArn;
            return this;
        }

        public final Boolean getDeleted() {
            return deleted;
        }

        public final void setDeleted(Boolean deleted) {
            this.deleted = deleted;
        }

        @Override
        public final Builder deleted(Boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public AwsSecretsManagerSecretDetails build() {
            return new AwsSecretsManagerSecretDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
