/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details about an Amazon SageMaker AI notebook instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsSageMakerNotebookInstanceDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsSageMakerNotebookInstanceDetails.Builder, AwsSageMakerNotebookInstanceDetails> {
    private static final SdkField<List<String>> ACCELERATOR_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AcceleratorTypes")
            .getter(getter(AwsSageMakerNotebookInstanceDetails::acceleratorTypes))
            .setter(setter(Builder::acceleratorTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceleratorTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ADDITIONAL_CODE_REPOSITORIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AdditionalCodeRepositories")
            .getter(getter(AwsSageMakerNotebookInstanceDetails::additionalCodeRepositories))
            .setter(setter(Builder::additionalCodeRepositories))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalCodeRepositories").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DEFAULT_CODE_REPOSITORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultCodeRepository").getter(getter(AwsSageMakerNotebookInstanceDetails::defaultCodeRepository))
            .setter(setter(Builder::defaultCodeRepository))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultCodeRepository").build())
            .build();

    private static final SdkField<String> DIRECT_INTERNET_ACCESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectInternetAccess").getter(getter(AwsSageMakerNotebookInstanceDetails::directInternetAccess))
            .setter(setter(Builder::directInternetAccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectInternetAccess").build())
            .build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReason").getter(getter(AwsSageMakerNotebookInstanceDetails::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final SdkField<AwsSageMakerNotebookInstanceMetadataServiceConfigurationDetails> INSTANCE_METADATA_SERVICE_CONFIGURATION_FIELD = SdkField
            .<AwsSageMakerNotebookInstanceMetadataServiceConfigurationDetails> builder(MarshallingType.SDK_POJO)
            .memberName("InstanceMetadataServiceConfiguration")
            .getter(getter(AwsSageMakerNotebookInstanceDetails::instanceMetadataServiceConfiguration))
            .setter(setter(Builder::instanceMetadataServiceConfiguration))
            .constructor(AwsSageMakerNotebookInstanceMetadataServiceConfigurationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("InstanceMetadataServiceConfiguration").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceType").getter(getter(AwsSageMakerNotebookInstanceDetails::instanceType))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(AwsSageMakerNotebookInstanceDetails::kmsKeyId))
            .setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NetworkInterfaceId").getter(getter(AwsSageMakerNotebookInstanceDetails::networkInterfaceId))
            .setter(setter(Builder::networkInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId").build())
            .build();

    private static final SdkField<String> NOTEBOOK_INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NotebookInstanceArn").getter(getter(AwsSageMakerNotebookInstanceDetails::notebookInstanceArn))
            .setter(setter(Builder::notebookInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookInstanceArn").build())
            .build();

    private static final SdkField<String> NOTEBOOK_INSTANCE_LIFECYCLE_CONFIG_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NotebookInstanceLifecycleConfigName")
            .getter(getter(AwsSageMakerNotebookInstanceDetails::notebookInstanceLifecycleConfigName))
            .setter(setter(Builder::notebookInstanceLifecycleConfigName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("NotebookInstanceLifecycleConfigName").build()).build();

    private static final SdkField<String> NOTEBOOK_INSTANCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NotebookInstanceName").getter(getter(AwsSageMakerNotebookInstanceDetails::notebookInstanceName))
            .setter(setter(Builder::notebookInstanceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookInstanceName").build())
            .build();

    private static final SdkField<String> NOTEBOOK_INSTANCE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NotebookInstanceStatus").getter(getter(AwsSageMakerNotebookInstanceDetails::notebookInstanceStatus))
            .setter(setter(Builder::notebookInstanceStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookInstanceStatus").build())
            .build();

    private static final SdkField<String> PLATFORM_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlatformIdentifier").getter(getter(AwsSageMakerNotebookInstanceDetails::platformIdentifier))
            .setter(setter(Builder::platformIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformIdentifier").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(AwsSageMakerNotebookInstanceDetails::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> ROOT_ACCESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RootAccess").getter(getter(AwsSageMakerNotebookInstanceDetails::rootAccess))
            .setter(setter(Builder::rootAccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootAccess").build()).build();

    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroups")
            .getter(getter(AwsSageMakerNotebookInstanceDetails::securityGroups))
            .setter(setter(Builder::securityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubnetId").getter(getter(AwsSageMakerNotebookInstanceDetails::subnetId))
            .setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()).build();

    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Url")
            .getter(getter(AwsSageMakerNotebookInstanceDetails::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()).build();

    private static final SdkField<Integer> VOLUME_SIZE_IN_GB_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("VolumeSizeInGB").getter(getter(AwsSageMakerNotebookInstanceDetails::volumeSizeInGB))
            .setter(setter(Builder::volumeSizeInGB))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeSizeInGB").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCELERATOR_TYPES_FIELD,
            ADDITIONAL_CODE_REPOSITORIES_FIELD, DEFAULT_CODE_REPOSITORY_FIELD, DIRECT_INTERNET_ACCESS_FIELD,
            FAILURE_REASON_FIELD, INSTANCE_METADATA_SERVICE_CONFIGURATION_FIELD, INSTANCE_TYPE_FIELD, KMS_KEY_ID_FIELD,
            NETWORK_INTERFACE_ID_FIELD, NOTEBOOK_INSTANCE_ARN_FIELD, NOTEBOOK_INSTANCE_LIFECYCLE_CONFIG_NAME_FIELD,
            NOTEBOOK_INSTANCE_NAME_FIELD, NOTEBOOK_INSTANCE_STATUS_FIELD, PLATFORM_IDENTIFIER_FIELD, ROLE_ARN_FIELD,
            ROOT_ACCESS_FIELD, SECURITY_GROUPS_FIELD, SUBNET_ID_FIELD, URL_FIELD, VOLUME_SIZE_IN_GB_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> acceleratorTypes;

    private final List<String> additionalCodeRepositories;

    private final String defaultCodeRepository;

    private final String directInternetAccess;

    private final String failureReason;

    private final AwsSageMakerNotebookInstanceMetadataServiceConfigurationDetails instanceMetadataServiceConfiguration;

    private final String instanceType;

    private final String kmsKeyId;

    private final String networkInterfaceId;

    private final String notebookInstanceArn;

    private final String notebookInstanceLifecycleConfigName;

    private final String notebookInstanceName;

    private final String notebookInstanceStatus;

    private final String platformIdentifier;

    private final String roleArn;

    private final String rootAccess;

    private final List<String> securityGroups;

    private final String subnetId;

    private final String url;

    private final Integer volumeSizeInGB;

    private AwsSageMakerNotebookInstanceDetails(BuilderImpl builder) {
        this.acceleratorTypes = builder.acceleratorTypes;
        this.additionalCodeRepositories = builder.additionalCodeRepositories;
        this.defaultCodeRepository = builder.defaultCodeRepository;
        this.directInternetAccess = builder.directInternetAccess;
        this.failureReason = builder.failureReason;
        this.instanceMetadataServiceConfiguration = builder.instanceMetadataServiceConfiguration;
        this.instanceType = builder.instanceType;
        this.kmsKeyId = builder.kmsKeyId;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.notebookInstanceArn = builder.notebookInstanceArn;
        this.notebookInstanceLifecycleConfigName = builder.notebookInstanceLifecycleConfigName;
        this.notebookInstanceName = builder.notebookInstanceName;
        this.notebookInstanceStatus = builder.notebookInstanceStatus;
        this.platformIdentifier = builder.platformIdentifier;
        this.roleArn = builder.roleArn;
        this.rootAccess = builder.rootAccess;
        this.securityGroups = builder.securityGroups;
        this.subnetId = builder.subnetId;
        this.url = builder.url;
        this.volumeSizeInGB = builder.volumeSizeInGB;
    }

    /**
     * For responses, this returns true if the service returned a value for the AcceleratorTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAcceleratorTypes() {
        return acceleratorTypes != null && !(acceleratorTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Amazon Elastic Inference instance types to associate with the notebook instance. Currently, only one
     * instance type can be associated with a notebook instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAcceleratorTypes} method.
     * </p>
     * 
     * @return A list of Amazon Elastic Inference instance types to associate with the notebook instance. Currently,
     *         only one instance type can be associated with a notebook instance.
     */
    public final List<String> acceleratorTypes() {
        return acceleratorTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalCodeRepositories property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAdditionalCodeRepositories() {
        return additionalCodeRepositories != null && !(additionalCodeRepositories instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of up to three Git repositories associated with the notebook instance. These can be either the names of
     * Git repositories stored as resources in your account, or the URL of Git repositories in <a
     * href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">CodeCommit</a> or in any other Git
     * repository. These repositories are cloned at the same level as the default repository of your notebook instance.
     * For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating
     * Git repositories with SageMaker AI notebook instances</a> in the <i>Amazon SageMaker AI Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalCodeRepositories} method.
     * </p>
     * 
     * @return An array of up to three Git repositories associated with the notebook instance. These can be either the
     *         names of Git repositories stored as resources in your account, or the URL of Git repositories in <a
     *         href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">CodeCommit</a> or in any
     *         other Git repository. These repositories are cloned at the same level as the default repository of your
     *         notebook instance. For more information, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git repositories
     *         with SageMaker AI notebook instances</a> in the <i>Amazon SageMaker AI Developer Guide</i>.
     */
    public final List<String> additionalCodeRepositories() {
        return additionalCodeRepositories;
    }

    /**
     * <p>
     * The Git repository associated with the notebook instance as its default code repository. This can be either the
     * name of a Git repository stored as a resource in your account, or the URL of a Git repository in <a
     * href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">CodeCommit</a> or in any other Git
     * repository. When you open a notebook instance, it opens in the directory that contains this repository. For more
     * information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git
     * repositories with SageMaker AI notebook instances</a> in the <i>Amazon SageMaker AI Developer Guide</i>.
     * </p>
     * 
     * @return The Git repository associated with the notebook instance as its default code repository. This can be
     *         either the name of a Git repository stored as a resource in your account, or the URL of a Git repository
     *         in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">CodeCommit</a> or in
     *         any other Git repository. When you open a notebook instance, it opens in the directory that contains this
     *         repository. For more information, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git repositories
     *         with SageMaker AI notebook instances</a> in the <i>Amazon SageMaker AI Developer Guide</i>.
     */
    public final String defaultCodeRepository() {
        return defaultCodeRepository;
    }

    /**
     * <p>
     * Sets whether SageMaker AI provides internet access to the notebook instance. If you set this to
     * <code>Disabled</code>, this notebook instance is able to access resources only in your VPC, and is not be able to
     * connect to SageMaker AI training and endpoint services unless you configure a Network Address Translation (NAT)
     * Gateway in your VPC.
     * </p>
     * 
     * @return Sets whether SageMaker AI provides internet access to the notebook instance. If you set this to
     *         <code>Disabled</code>, this notebook instance is able to access resources only in your VPC, and is not be
     *         able to connect to SageMaker AI training and endpoint services unless you configure a Network Address
     *         Translation (NAT) Gateway in your VPC.
     */
    public final String directInternetAccess() {
        return directInternetAccess;
    }

    /**
     * <p>
     * If status of the instance is <code>Failed</code>, the reason it failed.
     * </p>
     * 
     * @return If status of the instance is <code>Failed</code>, the reason it failed.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * Information on the IMDS configuration of the notebook instance.
     * </p>
     * 
     * @return Information on the IMDS configuration of the notebook instance.
     */
    public final AwsSageMakerNotebookInstanceMetadataServiceConfigurationDetails instanceMetadataServiceConfiguration() {
        return instanceMetadataServiceConfiguration;
    }

    /**
     * <p>
     * The type of machine learning (ML) compute instance to launch for the notebook instance.
     * </p>
     * 
     * @return The type of machine learning (ML) compute instance to launch for the notebook instance.
     */
    public final String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an Key Management Service (KMS) key that SageMaker AI uses to encrypt data on
     * the storage volume attached to your notebook instance. The KMS key you provide must be enabled. For information,
     * see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/enabling-keys.html">Enabling and disabling
     * keys</a> in the <i>Key Management Service Developer Guide</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an Key Management Service (KMS) key that SageMaker AI uses to encrypt
     *         data on the storage volume attached to your notebook instance. The KMS key you provide must be enabled.
     *         For information, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/enabling-keys.html">Enabling and disabling
     *         keys</a> in the <i>Key Management Service Developer Guide</i>.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The network interface ID that SageMaker AI created when the instance was created.
     * </p>
     * 
     * @return The network interface ID that SageMaker AI created when the instance was created.
     */
    public final String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the notebook instance.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the notebook instance.
     */
    public final String notebookInstanceArn() {
        return notebookInstanceArn;
    }

    /**
     * <p>
     * The name of a notebook instance lifecycle configuration.
     * </p>
     * 
     * @return The name of a notebook instance lifecycle configuration.
     */
    public final String notebookInstanceLifecycleConfigName() {
        return notebookInstanceLifecycleConfigName;
    }

    /**
     * <p>
     * The name of the new notebook instance.
     * </p>
     * 
     * @return The name of the new notebook instance.
     */
    public final String notebookInstanceName() {
        return notebookInstanceName;
    }

    /**
     * <p>
     * The status of the notebook instance.
     * </p>
     * 
     * @return The status of the notebook instance.
     */
    public final String notebookInstanceStatus() {
        return notebookInstanceStatus;
    }

    /**
     * <p>
     * The platform identifier of the notebook instance runtime environment.
     * </p>
     * 
     * @return The platform identifier of the notebook instance runtime environment.
     */
    public final String platformIdentifier() {
        return platformIdentifier;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role associated with the instance.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role associated with the instance.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * Whether root access is enabled or disabled for users of the notebook instance.
     * </p>
     * 
     * @return Whether root access is enabled or disabled for users of the notebook instance.
     */
    public final String rootAccess() {
        return rootAccess;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroups() {
        return securityGroups != null && !(securityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The VPC security group IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroups} method.
     * </p>
     * 
     * @return The VPC security group IDs.
     */
    public final List<String> securityGroups() {
        return securityGroups;
    }

    /**
     * <p>
     * The ID of the VPC subnet to which you have a connectivity from your ML compute instance.
     * </p>
     * 
     * @return The ID of the VPC subnet to which you have a connectivity from your ML compute instance.
     */
    public final String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * The URL that you use to connect to the Jupyter notebook that is running in your notebook instance.
     * </p>
     * 
     * @return The URL that you use to connect to the Jupyter notebook that is running in your notebook instance.
     */
    public final String url() {
        return url;
    }

    /**
     * <p>
     * The size, in GB, of the ML storage volume to attach to the notebook instance.
     * </p>
     * 
     * @return The size, in GB, of the ML storage volume to attach to the notebook instance.
     */
    public final Integer volumeSizeInGB() {
        return volumeSizeInGB;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAcceleratorTypes() ? acceleratorTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalCodeRepositories() ? additionalCodeRepositories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(defaultCodeRepository());
        hashCode = 31 * hashCode + Objects.hashCode(directInternetAccess());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(instanceMetadataServiceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(notebookInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(notebookInstanceLifecycleConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(notebookInstanceName());
        hashCode = 31 * hashCode + Objects.hashCode(notebookInstanceStatus());
        hashCode = 31 * hashCode + Objects.hashCode(platformIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(rootAccess());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroups() ? securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        hashCode = 31 * hashCode + Objects.hashCode(volumeSizeInGB());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsSageMakerNotebookInstanceDetails)) {
            return false;
        }
        AwsSageMakerNotebookInstanceDetails other = (AwsSageMakerNotebookInstanceDetails) obj;
        return hasAcceleratorTypes() == other.hasAcceleratorTypes()
                && Objects.equals(acceleratorTypes(), other.acceleratorTypes())
                && hasAdditionalCodeRepositories() == other.hasAdditionalCodeRepositories()
                && Objects.equals(additionalCodeRepositories(), other.additionalCodeRepositories())
                && Objects.equals(defaultCodeRepository(), other.defaultCodeRepository())
                && Objects.equals(directInternetAccess(), other.directInternetAccess())
                && Objects.equals(failureReason(), other.failureReason())
                && Objects.equals(instanceMetadataServiceConfiguration(), other.instanceMetadataServiceConfiguration())
                && Objects.equals(instanceType(), other.instanceType()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(networkInterfaceId(), other.networkInterfaceId())
                && Objects.equals(notebookInstanceArn(), other.notebookInstanceArn())
                && Objects.equals(notebookInstanceLifecycleConfigName(), other.notebookInstanceLifecycleConfigName())
                && Objects.equals(notebookInstanceName(), other.notebookInstanceName())
                && Objects.equals(notebookInstanceStatus(), other.notebookInstanceStatus())
                && Objects.equals(platformIdentifier(), other.platformIdentifier()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(rootAccess(), other.rootAccess()) && hasSecurityGroups() == other.hasSecurityGroups()
                && Objects.equals(securityGroups(), other.securityGroups()) && Objects.equals(subnetId(), other.subnetId())
                && Objects.equals(url(), other.url()) && Objects.equals(volumeSizeInGB(), other.volumeSizeInGB());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsSageMakerNotebookInstanceDetails")
                .add("AcceleratorTypes", hasAcceleratorTypes() ? acceleratorTypes() : null)
                .add("AdditionalCodeRepositories", hasAdditionalCodeRepositories() ? additionalCodeRepositories() : null)
                .add("DefaultCodeRepository", defaultCodeRepository()).add("DirectInternetAccess", directInternetAccess())
                .add("FailureReason", failureReason())
                .add("InstanceMetadataServiceConfiguration", instanceMetadataServiceConfiguration())
                .add("InstanceType", instanceType()).add("KmsKeyId", kmsKeyId()).add("NetworkInterfaceId", networkInterfaceId())
                .add("NotebookInstanceArn", notebookInstanceArn())
                .add("NotebookInstanceLifecycleConfigName", notebookInstanceLifecycleConfigName())
                .add("NotebookInstanceName", notebookInstanceName()).add("NotebookInstanceStatus", notebookInstanceStatus())
                .add("PlatformIdentifier", platformIdentifier()).add("RoleArn", roleArn()).add("RootAccess", rootAccess())
                .add("SecurityGroups", hasSecurityGroups() ? securityGroups() : null).add("SubnetId", subnetId())
                .add("Url", url()).add("VolumeSizeInGB", volumeSizeInGB()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AcceleratorTypes":
            return Optional.ofNullable(clazz.cast(acceleratorTypes()));
        case "AdditionalCodeRepositories":
            return Optional.ofNullable(clazz.cast(additionalCodeRepositories()));
        case "DefaultCodeRepository":
            return Optional.ofNullable(clazz.cast(defaultCodeRepository()));
        case "DirectInternetAccess":
            return Optional.ofNullable(clazz.cast(directInternetAccess()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "InstanceMetadataServiceConfiguration":
            return Optional.ofNullable(clazz.cast(instanceMetadataServiceConfiguration()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "NetworkInterfaceId":
            return Optional.ofNullable(clazz.cast(networkInterfaceId()));
        case "NotebookInstanceArn":
            return Optional.ofNullable(clazz.cast(notebookInstanceArn()));
        case "NotebookInstanceLifecycleConfigName":
            return Optional.ofNullable(clazz.cast(notebookInstanceLifecycleConfigName()));
        case "NotebookInstanceName":
            return Optional.ofNullable(clazz.cast(notebookInstanceName()));
        case "NotebookInstanceStatus":
            return Optional.ofNullable(clazz.cast(notebookInstanceStatus()));
        case "PlatformIdentifier":
            return Optional.ofNullable(clazz.cast(platformIdentifier()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "RootAccess":
            return Optional.ofNullable(clazz.cast(rootAccess()));
        case "SecurityGroups":
            return Optional.ofNullable(clazz.cast(securityGroups()));
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "Url":
            return Optional.ofNullable(clazz.cast(url()));
        case "VolumeSizeInGB":
            return Optional.ofNullable(clazz.cast(volumeSizeInGB()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AcceleratorTypes", ACCELERATOR_TYPES_FIELD);
        map.put("AdditionalCodeRepositories", ADDITIONAL_CODE_REPOSITORIES_FIELD);
        map.put("DefaultCodeRepository", DEFAULT_CODE_REPOSITORY_FIELD);
        map.put("DirectInternetAccess", DIRECT_INTERNET_ACCESS_FIELD);
        map.put("FailureReason", FAILURE_REASON_FIELD);
        map.put("InstanceMetadataServiceConfiguration", INSTANCE_METADATA_SERVICE_CONFIGURATION_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("NetworkInterfaceId", NETWORK_INTERFACE_ID_FIELD);
        map.put("NotebookInstanceArn", NOTEBOOK_INSTANCE_ARN_FIELD);
        map.put("NotebookInstanceLifecycleConfigName", NOTEBOOK_INSTANCE_LIFECYCLE_CONFIG_NAME_FIELD);
        map.put("NotebookInstanceName", NOTEBOOK_INSTANCE_NAME_FIELD);
        map.put("NotebookInstanceStatus", NOTEBOOK_INSTANCE_STATUS_FIELD);
        map.put("PlatformIdentifier", PLATFORM_IDENTIFIER_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("RootAccess", ROOT_ACCESS_FIELD);
        map.put("SecurityGroups", SECURITY_GROUPS_FIELD);
        map.put("SubnetId", SUBNET_ID_FIELD);
        map.put("Url", URL_FIELD);
        map.put("VolumeSizeInGB", VOLUME_SIZE_IN_GB_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsSageMakerNotebookInstanceDetails, T> g) {
        return obj -> g.apply((AwsSageMakerNotebookInstanceDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsSageMakerNotebookInstanceDetails> {
        /**
         * <p>
         * A list of Amazon Elastic Inference instance types to associate with the notebook instance. Currently, only
         * one instance type can be associated with a notebook instance.
         * </p>
         * 
         * @param acceleratorTypes
         *        A list of Amazon Elastic Inference instance types to associate with the notebook instance. Currently,
         *        only one instance type can be associated with a notebook instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceleratorTypes(Collection<String> acceleratorTypes);

        /**
         * <p>
         * A list of Amazon Elastic Inference instance types to associate with the notebook instance. Currently, only
         * one instance type can be associated with a notebook instance.
         * </p>
         * 
         * @param acceleratorTypes
         *        A list of Amazon Elastic Inference instance types to associate with the notebook instance. Currently,
         *        only one instance type can be associated with a notebook instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceleratorTypes(String... acceleratorTypes);

        /**
         * <p>
         * An array of up to three Git repositories associated with the notebook instance. These can be either the names
         * of Git repositories stored as resources in your account, or the URL of Git repositories in <a
         * href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">CodeCommit</a> or in any other
         * Git repository. These repositories are cloned at the same level as the default repository of your notebook
         * instance. For more information, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git repositories with
         * SageMaker AI notebook instances</a> in the <i>Amazon SageMaker AI Developer Guide</i>.
         * </p>
         * 
         * @param additionalCodeRepositories
         *        An array of up to three Git repositories associated with the notebook instance. These can be either
         *        the names of Git repositories stored as resources in your account, or the URL of Git repositories in
         *        <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">CodeCommit</a> or in
         *        any other Git repository. These repositories are cloned at the same level as the default repository of
         *        your notebook instance. For more information, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git repositories
         *        with SageMaker AI notebook instances</a> in the <i>Amazon SageMaker AI Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalCodeRepositories(Collection<String> additionalCodeRepositories);

        /**
         * <p>
         * An array of up to three Git repositories associated with the notebook instance. These can be either the names
         * of Git repositories stored as resources in your account, or the URL of Git repositories in <a
         * href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">CodeCommit</a> or in any other
         * Git repository. These repositories are cloned at the same level as the default repository of your notebook
         * instance. For more information, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git repositories with
         * SageMaker AI notebook instances</a> in the <i>Amazon SageMaker AI Developer Guide</i>.
         * </p>
         * 
         * @param additionalCodeRepositories
         *        An array of up to three Git repositories associated with the notebook instance. These can be either
         *        the names of Git repositories stored as resources in your account, or the URL of Git repositories in
         *        <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">CodeCommit</a> or in
         *        any other Git repository. These repositories are cloned at the same level as the default repository of
         *        your notebook instance. For more information, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git repositories
         *        with SageMaker AI notebook instances</a> in the <i>Amazon SageMaker AI Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalCodeRepositories(String... additionalCodeRepositories);

        /**
         * <p>
         * The Git repository associated with the notebook instance as its default code repository. This can be either
         * the name of a Git repository stored as a resource in your account, or the URL of a Git repository in <a
         * href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">CodeCommit</a> or in any other
         * Git repository. When you open a notebook instance, it opens in the directory that contains this repository.
         * For more information, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git repositories with
         * SageMaker AI notebook instances</a> in the <i>Amazon SageMaker AI Developer Guide</i>.
         * </p>
         * 
         * @param defaultCodeRepository
         *        The Git repository associated with the notebook instance as its default code repository. This can be
         *        either the name of a Git repository stored as a resource in your account, or the URL of a Git
         *        repository in <a
         *        href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">CodeCommit</a> or in any
         *        other Git repository. When you open a notebook instance, it opens in the directory that contains this
         *        repository. For more information, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git repositories
         *        with SageMaker AI notebook instances</a> in the <i>Amazon SageMaker AI Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultCodeRepository(String defaultCodeRepository);

        /**
         * <p>
         * Sets whether SageMaker AI provides internet access to the notebook instance. If you set this to
         * <code>Disabled</code>, this notebook instance is able to access resources only in your VPC, and is not be
         * able to connect to SageMaker AI training and endpoint services unless you configure a Network Address
         * Translation (NAT) Gateway in your VPC.
         * </p>
         * 
         * @param directInternetAccess
         *        Sets whether SageMaker AI provides internet access to the notebook instance. If you set this to
         *        <code>Disabled</code>, this notebook instance is able to access resources only in your VPC, and is not
         *        be able to connect to SageMaker AI training and endpoint services unless you configure a Network
         *        Address Translation (NAT) Gateway in your VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directInternetAccess(String directInternetAccess);

        /**
         * <p>
         * If status of the instance is <code>Failed</code>, the reason it failed.
         * </p>
         * 
         * @param failureReason
         *        If status of the instance is <code>Failed</code>, the reason it failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * Information on the IMDS configuration of the notebook instance.
         * </p>
         * 
         * @param instanceMetadataServiceConfiguration
         *        Information on the IMDS configuration of the notebook instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceMetadataServiceConfiguration(
                AwsSageMakerNotebookInstanceMetadataServiceConfigurationDetails instanceMetadataServiceConfiguration);

        /**
         * <p>
         * Information on the IMDS configuration of the notebook instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsSageMakerNotebookInstanceMetadataServiceConfigurationDetails.Builder} avoiding the need to create
         * one manually via {@link AwsSageMakerNotebookInstanceMetadataServiceConfigurationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsSageMakerNotebookInstanceMetadataServiceConfigurationDetails.Builder#build()} is called immediately
         * and its result is passed to
         * {@link #instanceMetadataServiceConfiguration(AwsSageMakerNotebookInstanceMetadataServiceConfigurationDetails)}.
         * 
         * @param instanceMetadataServiceConfiguration
         *        a consumer that will call methods on
         *        {@link AwsSageMakerNotebookInstanceMetadataServiceConfigurationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceMetadataServiceConfiguration(AwsSageMakerNotebookInstanceMetadataServiceConfigurationDetails)
         */
        default Builder instanceMetadataServiceConfiguration(
                Consumer<AwsSageMakerNotebookInstanceMetadataServiceConfigurationDetails.Builder> instanceMetadataServiceConfiguration) {
            return instanceMetadataServiceConfiguration(AwsSageMakerNotebookInstanceMetadataServiceConfigurationDetails.builder()
                    .applyMutation(instanceMetadataServiceConfiguration).build());
        }

        /**
         * <p>
         * The type of machine learning (ML) compute instance to launch for the notebook instance.
         * </p>
         * 
         * @param instanceType
         *        The type of machine learning (ML) compute instance to launch for the notebook instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an Key Management Service (KMS) key that SageMaker AI uses to encrypt data
         * on the storage volume attached to your notebook instance. The KMS key you provide must be enabled. For
         * information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/enabling-keys.html">Enabling
         * and disabling keys</a> in the <i>Key Management Service Developer Guide</i>.
         * </p>
         * 
         * @param kmsKeyId
         *        The Amazon Resource Name (ARN) of an Key Management Service (KMS) key that SageMaker AI uses to
         *        encrypt data on the storage volume attached to your notebook instance. The KMS key you provide must be
         *        enabled. For information, see <a
         *        href="https://docs.aws.amazon.com/kms/latest/developerguide/enabling-keys.html">Enabling and disabling
         *        keys</a> in the <i>Key Management Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The network interface ID that SageMaker AI created when the instance was created.
         * </p>
         * 
         * @param networkInterfaceId
         *        The network interface ID that SageMaker AI created when the instance was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the notebook instance.
         * </p>
         * 
         * @param notebookInstanceArn
         *        The Amazon Resource Name (ARN) of the notebook instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notebookInstanceArn(String notebookInstanceArn);

        /**
         * <p>
         * The name of a notebook instance lifecycle configuration.
         * </p>
         * 
         * @param notebookInstanceLifecycleConfigName
         *        The name of a notebook instance lifecycle configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notebookInstanceLifecycleConfigName(String notebookInstanceLifecycleConfigName);

        /**
         * <p>
         * The name of the new notebook instance.
         * </p>
         * 
         * @param notebookInstanceName
         *        The name of the new notebook instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notebookInstanceName(String notebookInstanceName);

        /**
         * <p>
         * The status of the notebook instance.
         * </p>
         * 
         * @param notebookInstanceStatus
         *        The status of the notebook instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notebookInstanceStatus(String notebookInstanceStatus);

        /**
         * <p>
         * The platform identifier of the notebook instance runtime environment.
         * </p>
         * 
         * @param platformIdentifier
         *        The platform identifier of the notebook instance runtime environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformIdentifier(String platformIdentifier);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role associated with the instance.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM role associated with the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * Whether root access is enabled or disabled for users of the notebook instance.
         * </p>
         * 
         * @param rootAccess
         *        Whether root access is enabled or disabled for users of the notebook instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rootAccess(String rootAccess);

        /**
         * <p>
         * The VPC security group IDs.
         * </p>
         * 
         * @param securityGroups
         *        The VPC security group IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(Collection<String> securityGroups);

        /**
         * <p>
         * The VPC security group IDs.
         * </p>
         * 
         * @param securityGroups
         *        The VPC security group IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(String... securityGroups);

        /**
         * <p>
         * The ID of the VPC subnet to which you have a connectivity from your ML compute instance.
         * </p>
         * 
         * @param subnetId
         *        The ID of the VPC subnet to which you have a connectivity from your ML compute instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The URL that you use to connect to the Jupyter notebook that is running in your notebook instance.
         * </p>
         * 
         * @param url
         *        The URL that you use to connect to the Jupyter notebook that is running in your notebook instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);

        /**
         * <p>
         * The size, in GB, of the ML storage volume to attach to the notebook instance.
         * </p>
         * 
         * @param volumeSizeInGB
         *        The size, in GB, of the ML storage volume to attach to the notebook instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeSizeInGB(Integer volumeSizeInGB);
    }

    static final class BuilderImpl implements Builder {
        private List<String> acceleratorTypes = DefaultSdkAutoConstructList.getInstance();

        private List<String> additionalCodeRepositories = DefaultSdkAutoConstructList.getInstance();

        private String defaultCodeRepository;

        private String directInternetAccess;

        private String failureReason;

        private AwsSageMakerNotebookInstanceMetadataServiceConfigurationDetails instanceMetadataServiceConfiguration;

        private String instanceType;

        private String kmsKeyId;

        private String networkInterfaceId;

        private String notebookInstanceArn;

        private String notebookInstanceLifecycleConfigName;

        private String notebookInstanceName;

        private String notebookInstanceStatus;

        private String platformIdentifier;

        private String roleArn;

        private String rootAccess;

        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();

        private String subnetId;

        private String url;

        private Integer volumeSizeInGB;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsSageMakerNotebookInstanceDetails model) {
            acceleratorTypes(model.acceleratorTypes);
            additionalCodeRepositories(model.additionalCodeRepositories);
            defaultCodeRepository(model.defaultCodeRepository);
            directInternetAccess(model.directInternetAccess);
            failureReason(model.failureReason);
            instanceMetadataServiceConfiguration(model.instanceMetadataServiceConfiguration);
            instanceType(model.instanceType);
            kmsKeyId(model.kmsKeyId);
            networkInterfaceId(model.networkInterfaceId);
            notebookInstanceArn(model.notebookInstanceArn);
            notebookInstanceLifecycleConfigName(model.notebookInstanceLifecycleConfigName);
            notebookInstanceName(model.notebookInstanceName);
            notebookInstanceStatus(model.notebookInstanceStatus);
            platformIdentifier(model.platformIdentifier);
            roleArn(model.roleArn);
            rootAccess(model.rootAccess);
            securityGroups(model.securityGroups);
            subnetId(model.subnetId);
            url(model.url);
            volumeSizeInGB(model.volumeSizeInGB);
        }

        public final Collection<String> getAcceleratorTypes() {
            if (acceleratorTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return acceleratorTypes;
        }

        public final void setAcceleratorTypes(Collection<String> acceleratorTypes) {
            this.acceleratorTypes = NonEmptyStringListCopier.copy(acceleratorTypes);
        }

        @Override
        public final Builder acceleratorTypes(Collection<String> acceleratorTypes) {
            this.acceleratorTypes = NonEmptyStringListCopier.copy(acceleratorTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceleratorTypes(String... acceleratorTypes) {
            acceleratorTypes(Arrays.asList(acceleratorTypes));
            return this;
        }

        public final Collection<String> getAdditionalCodeRepositories() {
            if (additionalCodeRepositories instanceof SdkAutoConstructList) {
                return null;
            }
            return additionalCodeRepositories;
        }

        public final void setAdditionalCodeRepositories(Collection<String> additionalCodeRepositories) {
            this.additionalCodeRepositories = NonEmptyStringListCopier.copy(additionalCodeRepositories);
        }

        @Override
        public final Builder additionalCodeRepositories(Collection<String> additionalCodeRepositories) {
            this.additionalCodeRepositories = NonEmptyStringListCopier.copy(additionalCodeRepositories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalCodeRepositories(String... additionalCodeRepositories) {
            additionalCodeRepositories(Arrays.asList(additionalCodeRepositories));
            return this;
        }

        public final String getDefaultCodeRepository() {
            return defaultCodeRepository;
        }

        public final void setDefaultCodeRepository(String defaultCodeRepository) {
            this.defaultCodeRepository = defaultCodeRepository;
        }

        @Override
        public final Builder defaultCodeRepository(String defaultCodeRepository) {
            this.defaultCodeRepository = defaultCodeRepository;
            return this;
        }

        public final String getDirectInternetAccess() {
            return directInternetAccess;
        }

        public final void setDirectInternetAccess(String directInternetAccess) {
            this.directInternetAccess = directInternetAccess;
        }

        @Override
        public final Builder directInternetAccess(String directInternetAccess) {
            this.directInternetAccess = directInternetAccess;
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final AwsSageMakerNotebookInstanceMetadataServiceConfigurationDetails.Builder getInstanceMetadataServiceConfiguration() {
            return instanceMetadataServiceConfiguration != null ? instanceMetadataServiceConfiguration.toBuilder() : null;
        }

        public final void setInstanceMetadataServiceConfiguration(
                AwsSageMakerNotebookInstanceMetadataServiceConfigurationDetails.BuilderImpl instanceMetadataServiceConfiguration) {
            this.instanceMetadataServiceConfiguration = instanceMetadataServiceConfiguration != null ? instanceMetadataServiceConfiguration
                    .build() : null;
        }

        @Override
        public final Builder instanceMetadataServiceConfiguration(
                AwsSageMakerNotebookInstanceMetadataServiceConfigurationDetails instanceMetadataServiceConfiguration) {
            this.instanceMetadataServiceConfiguration = instanceMetadataServiceConfiguration;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final String getNotebookInstanceArn() {
            return notebookInstanceArn;
        }

        public final void setNotebookInstanceArn(String notebookInstanceArn) {
            this.notebookInstanceArn = notebookInstanceArn;
        }

        @Override
        public final Builder notebookInstanceArn(String notebookInstanceArn) {
            this.notebookInstanceArn = notebookInstanceArn;
            return this;
        }

        public final String getNotebookInstanceLifecycleConfigName() {
            return notebookInstanceLifecycleConfigName;
        }

        public final void setNotebookInstanceLifecycleConfigName(String notebookInstanceLifecycleConfigName) {
            this.notebookInstanceLifecycleConfigName = notebookInstanceLifecycleConfigName;
        }

        @Override
        public final Builder notebookInstanceLifecycleConfigName(String notebookInstanceLifecycleConfigName) {
            this.notebookInstanceLifecycleConfigName = notebookInstanceLifecycleConfigName;
            return this;
        }

        public final String getNotebookInstanceName() {
            return notebookInstanceName;
        }

        public final void setNotebookInstanceName(String notebookInstanceName) {
            this.notebookInstanceName = notebookInstanceName;
        }

        @Override
        public final Builder notebookInstanceName(String notebookInstanceName) {
            this.notebookInstanceName = notebookInstanceName;
            return this;
        }

        public final String getNotebookInstanceStatus() {
            return notebookInstanceStatus;
        }

        public final void setNotebookInstanceStatus(String notebookInstanceStatus) {
            this.notebookInstanceStatus = notebookInstanceStatus;
        }

        @Override
        public final Builder notebookInstanceStatus(String notebookInstanceStatus) {
            this.notebookInstanceStatus = notebookInstanceStatus;
            return this;
        }

        public final String getPlatformIdentifier() {
            return platformIdentifier;
        }

        public final void setPlatformIdentifier(String platformIdentifier) {
            this.platformIdentifier = platformIdentifier;
        }

        @Override
        public final Builder platformIdentifier(String platformIdentifier) {
            this.platformIdentifier = platformIdentifier;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getRootAccess() {
            return rootAccess;
        }

        public final void setRootAccess(String rootAccess) {
            this.rootAccess = rootAccess;
        }

        @Override
        public final Builder rootAccess(String rootAccess) {
            this.rootAccess = rootAccess;
            return this;
        }

        public final Collection<String> getSecurityGroups() {
            if (securityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroups;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = NonEmptyStringListCopier.copy(securityGroups);
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = NonEmptyStringListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String... securityGroups) {
            securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final String getUrl() {
            return url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final Integer getVolumeSizeInGB() {
            return volumeSizeInGB;
        }

        public final void setVolumeSizeInGB(Integer volumeSizeInGB) {
            this.volumeSizeInGB = volumeSizeInGB;
        }

        @Override
        public final Builder volumeSizeInGB(Integer volumeSizeInGB) {
            this.volumeSizeInGB = volumeSizeInGB;
            return this;
        }

        @Override
        public AwsSageMakerNotebookInstanceDetails build() {
            return new AwsSageMakerNotebookInstanceDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
