/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The default S3 Object Lock retention mode and period that you want to apply to new objects placed in the specified
 * Amazon S3 bucket.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails.Builder, AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails> {
    private static final SdkField<Integer> DAYS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Days")
            .getter(getter(AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails::days)).setter(setter(Builder::days))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Days").build()).build();

    private static final SdkField<String> MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Mode")
            .getter(getter(AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails::mode)).setter(setter(Builder::mode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()).build();

    private static final SdkField<Integer> YEARS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Years")
            .getter(getter(AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails::years)).setter(setter(Builder::years))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Years").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DAYS_FIELD, MODE_FIELD,
            YEARS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer days;

    private final String mode;

    private final Integer years;

    private AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails(BuilderImpl builder) {
        this.days = builder.days;
        this.mode = builder.mode;
        this.years = builder.years;
    }

    /**
     * <p>
     * The number of days that you want to specify for the default retention period.
     * </p>
     * 
     * @return The number of days that you want to specify for the default retention period.
     */
    public final Integer days() {
        return days;
    }

    /**
     * <p>
     * The default Object Lock retention mode you want to apply to new objects placed in the specified bucket.
     * </p>
     * 
     * @return The default Object Lock retention mode you want to apply to new objects placed in the specified bucket.
     */
    public final String mode() {
        return mode;
    }

    /**
     * <p>
     * The number of years that you want to specify for the default retention period.
     * </p>
     * 
     * @return The number of years that you want to specify for the default retention period.
     */
    public final Integer years() {
        return years;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(days());
        hashCode = 31 * hashCode + Objects.hashCode(mode());
        hashCode = 31 * hashCode + Objects.hashCode(years());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails)) {
            return false;
        }
        AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails other = (AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails) obj;
        return Objects.equals(days(), other.days()) && Objects.equals(mode(), other.mode())
                && Objects.equals(years(), other.years());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails").add("Days", days())
                .add("Mode", mode()).add("Years", years()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Days":
            return Optional.ofNullable(clazz.cast(days()));
        case "Mode":
            return Optional.ofNullable(clazz.cast(mode()));
        case "Years":
            return Optional.ofNullable(clazz.cast(years()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Days", DAYS_FIELD);
        map.put("Mode", MODE_FIELD);
        map.put("Years", YEARS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails, T> g) {
        return obj -> g.apply((AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo,
            CopyableBuilder<Builder, AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails> {
        /**
         * <p>
         * The number of days that you want to specify for the default retention period.
         * </p>
         * 
         * @param days
         *        The number of days that you want to specify for the default retention period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder days(Integer days);

        /**
         * <p>
         * The default Object Lock retention mode you want to apply to new objects placed in the specified bucket.
         * </p>
         * 
         * @param mode
         *        The default Object Lock retention mode you want to apply to new objects placed in the specified
         *        bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mode(String mode);

        /**
         * <p>
         * The number of years that you want to specify for the default retention period.
         * </p>
         * 
         * @param years
         *        The number of years that you want to specify for the default retention period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder years(Integer years);
    }

    static final class BuilderImpl implements Builder {
        private Integer days;

        private String mode;

        private Integer years;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails model) {
            days(model.days);
            mode(model.mode);
            years(model.years);
        }

        public final Integer getDays() {
            return days;
        }

        public final void setDays(Integer days) {
            this.days = days;
        }

        @Override
        public final Builder days(Integer days) {
            this.days = days;
            return this;
        }

        public final String getMode() {
            return mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        public final Integer getYears() {
            return years;
        }

        public final void setYears(Integer years) {
            this.years = years;
        }

        @Override
        public final Builder years(Integer years) {
            this.years = years;
            return this;
        }

        @Override
        public AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails build() {
            return new AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
