/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Identifies the objects that a rule applies to.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails.Builder, AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails> {
    private static final SdkField<AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails> PREDICATE_FIELD = SdkField
            .<AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails> builder(MarshallingType.SDK_POJO)
            .memberName("Predicate").getter(getter(AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails::predicate))
            .setter(setter(Builder::predicate))
            .constructor(AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Predicate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREDICATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails predicate;

    private AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails(BuilderImpl builder) {
        this.predicate = builder.predicate;
    }

    /**
     * <p>
     * The configuration for the filter.
     * </p>
     * 
     * @return The configuration for the filter.
     */
    public final AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails predicate() {
        return predicate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(predicate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails)) {
            return false;
        }
        AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails other = (AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails) obj;
        return Objects.equals(predicate(), other.predicate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails").add("Predicate", predicate())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Predicate":
            return Optional.ofNullable(clazz.cast(predicate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Predicate", PREDICATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails, T> g) {
        return obj -> g.apply((AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails> {
        /**
         * <p>
         * The configuration for the filter.
         * </p>
         * 
         * @param predicate
         *        The configuration for the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predicate(AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails predicate);

        /**
         * <p>
         * The configuration for the filter.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails.Builder} avoiding the need to
         * create one manually via {@link AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #predicate(AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails)}.
         * 
         * @param predicate
         *        a consumer that will call methods on
         *        {@link AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #predicate(AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails)
         */
        default Builder predicate(Consumer<AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails.Builder> predicate) {
            return predicate(AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails.builder()
                    .applyMutation(predicate).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails predicate;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails model) {
            predicate(model.predicate);
        }

        public final AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails.Builder getPredicate() {
            return predicate != null ? predicate.toBuilder() : null;
        }

        public final void setPredicate(AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails.BuilderImpl predicate) {
            this.predicate = predicate != null ? predicate.build() : null;
        }

        @Override
        public final Builder predicate(AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails predicate) {
            this.predicate = predicate;
            return this;
        }

        @Override
        public AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails build() {
            return new AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
