/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns configuration information about the specified Amazon S3 access point. S3 access points are named network
 * endpoints that are attached to buckets that you can use to perform S3 object operations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsS3AccessPointDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsS3AccessPointDetails.Builder, AwsS3AccessPointDetails> {
    private static final SdkField<String> ACCESS_POINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccessPointArn").getter(getter(AwsS3AccessPointDetails::accessPointArn))
            .setter(setter(Builder::accessPointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessPointArn").build()).build();

    private static final SdkField<String> ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Alias")
            .getter(getter(AwsS3AccessPointDetails::alias)).setter(setter(Builder::alias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alias").build()).build();

    private static final SdkField<String> BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Bucket")
            .getter(getter(AwsS3AccessPointDetails::bucket)).setter(setter(Builder::bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bucket").build()).build();

    private static final SdkField<String> BUCKET_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BucketAccountId").getter(getter(AwsS3AccessPointDetails::bucketAccountId))
            .setter(setter(Builder::bucketAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketAccountId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AwsS3AccessPointDetails::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> NETWORK_ORIGIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NetworkOrigin").getter(getter(AwsS3AccessPointDetails::networkOrigin))
            .setter(setter(Builder::networkOrigin))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkOrigin").build()).build();

    private static final SdkField<AwsS3AccountPublicAccessBlockDetails> PUBLIC_ACCESS_BLOCK_CONFIGURATION_FIELD = SdkField
            .<AwsS3AccountPublicAccessBlockDetails> builder(MarshallingType.SDK_POJO)
            .memberName("PublicAccessBlockConfiguration")
            .getter(getter(AwsS3AccessPointDetails::publicAccessBlockConfiguration))
            .setter(setter(Builder::publicAccessBlockConfiguration))
            .constructor(AwsS3AccountPublicAccessBlockDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicAccessBlockConfiguration")
                    .build()).build();

    private static final SdkField<AwsS3AccessPointVpcConfigurationDetails> VPC_CONFIGURATION_FIELD = SdkField
            .<AwsS3AccessPointVpcConfigurationDetails> builder(MarshallingType.SDK_POJO).memberName("VpcConfiguration")
            .getter(getter(AwsS3AccessPointDetails::vpcConfiguration)).setter(setter(Builder::vpcConfiguration))
            .constructor(AwsS3AccessPointVpcConfigurationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_POINT_ARN_FIELD,
            ALIAS_FIELD, BUCKET_FIELD, BUCKET_ACCOUNT_ID_FIELD, NAME_FIELD, NETWORK_ORIGIN_FIELD,
            PUBLIC_ACCESS_BLOCK_CONFIGURATION_FIELD, VPC_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String accessPointArn;

    private final String alias;

    private final String bucket;

    private final String bucketAccountId;

    private final String name;

    private final String networkOrigin;

    private final AwsS3AccountPublicAccessBlockDetails publicAccessBlockConfiguration;

    private final AwsS3AccessPointVpcConfigurationDetails vpcConfiguration;

    private AwsS3AccessPointDetails(BuilderImpl builder) {
        this.accessPointArn = builder.accessPointArn;
        this.alias = builder.alias;
        this.bucket = builder.bucket;
        this.bucketAccountId = builder.bucketAccountId;
        this.name = builder.name;
        this.networkOrigin = builder.networkOrigin;
        this.publicAccessBlockConfiguration = builder.publicAccessBlockConfiguration;
        this.vpcConfiguration = builder.vpcConfiguration;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the access point.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the access point.
     */
    public final String accessPointArn() {
        return accessPointArn;
    }

    /**
     * <p>
     * The name or alias of the access point.
     * </p>
     * 
     * @return The name or alias of the access point.
     */
    public final String alias() {
        return alias;
    }

    /**
     * <p>
     * The name of the S3 bucket associated with the specified access point.
     * </p>
     * 
     * @return The name of the S3 bucket associated with the specified access point.
     */
    public final String bucket() {
        return bucket;
    }

    /**
     * <p>
     * The Amazon Web Services account ID associated with the S3 bucket associated with this access point.
     * </p>
     * 
     * @return The Amazon Web Services account ID associated with the S3 bucket associated with this access point.
     */
    public final String bucketAccountId() {
        return bucketAccountId;
    }

    /**
     * <p>
     * The name of the specified access point.
     * </p>
     * 
     * @return The name of the specified access point.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Indicates whether this access point allows access from the public internet.
     * </p>
     * 
     * @return Indicates whether this access point allows access from the public internet.
     */
    public final String networkOrigin() {
        return networkOrigin;
    }

    /**
     * Returns the value of the PublicAccessBlockConfiguration property for this object.
     * 
     * @return The value of the PublicAccessBlockConfiguration property for this object.
     */
    public final AwsS3AccountPublicAccessBlockDetails publicAccessBlockConfiguration() {
        return publicAccessBlockConfiguration;
    }

    /**
     * <p>
     * Contains the virtual private cloud (VPC) configuration for the specified access point.
     * </p>
     * 
     * @return Contains the virtual private cloud (VPC) configuration for the specified access point.
     */
    public final AwsS3AccessPointVpcConfigurationDetails vpcConfiguration() {
        return vpcConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accessPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(alias());
        hashCode = 31 * hashCode + Objects.hashCode(bucket());
        hashCode = 31 * hashCode + Objects.hashCode(bucketAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(networkOrigin());
        hashCode = 31 * hashCode + Objects.hashCode(publicAccessBlockConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsS3AccessPointDetails)) {
            return false;
        }
        AwsS3AccessPointDetails other = (AwsS3AccessPointDetails) obj;
        return Objects.equals(accessPointArn(), other.accessPointArn()) && Objects.equals(alias(), other.alias())
                && Objects.equals(bucket(), other.bucket()) && Objects.equals(bucketAccountId(), other.bucketAccountId())
                && Objects.equals(name(), other.name()) && Objects.equals(networkOrigin(), other.networkOrigin())
                && Objects.equals(publicAccessBlockConfiguration(), other.publicAccessBlockConfiguration())
                && Objects.equals(vpcConfiguration(), other.vpcConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsS3AccessPointDetails").add("AccessPointArn", accessPointArn()).add("Alias", alias())
                .add("Bucket", bucket()).add("BucketAccountId", bucketAccountId()).add("Name", name())
                .add("NetworkOrigin", networkOrigin()).add("PublicAccessBlockConfiguration", publicAccessBlockConfiguration())
                .add("VpcConfiguration", vpcConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccessPointArn":
            return Optional.ofNullable(clazz.cast(accessPointArn()));
        case "Alias":
            return Optional.ofNullable(clazz.cast(alias()));
        case "Bucket":
            return Optional.ofNullable(clazz.cast(bucket()));
        case "BucketAccountId":
            return Optional.ofNullable(clazz.cast(bucketAccountId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "NetworkOrigin":
            return Optional.ofNullable(clazz.cast(networkOrigin()));
        case "PublicAccessBlockConfiguration":
            return Optional.ofNullable(clazz.cast(publicAccessBlockConfiguration()));
        case "VpcConfiguration":
            return Optional.ofNullable(clazz.cast(vpcConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AccessPointArn", ACCESS_POINT_ARN_FIELD);
        map.put("Alias", ALIAS_FIELD);
        map.put("Bucket", BUCKET_FIELD);
        map.put("BucketAccountId", BUCKET_ACCOUNT_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("NetworkOrigin", NETWORK_ORIGIN_FIELD);
        map.put("PublicAccessBlockConfiguration", PUBLIC_ACCESS_BLOCK_CONFIGURATION_FIELD);
        map.put("VpcConfiguration", VPC_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsS3AccessPointDetails, T> g) {
        return obj -> g.apply((AwsS3AccessPointDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsS3AccessPointDetails> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the access point.
         * </p>
         * 
         * @param accessPointArn
         *        The Amazon Resource Name (ARN) of the access point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPointArn(String accessPointArn);

        /**
         * <p>
         * The name or alias of the access point.
         * </p>
         * 
         * @param alias
         *        The name or alias of the access point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alias(String alias);

        /**
         * <p>
         * The name of the S3 bucket associated with the specified access point.
         * </p>
         * 
         * @param bucket
         *        The name of the S3 bucket associated with the specified access point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * <p>
         * The Amazon Web Services account ID associated with the S3 bucket associated with this access point.
         * </p>
         * 
         * @param bucketAccountId
         *        The Amazon Web Services account ID associated with the S3 bucket associated with this access point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketAccountId(String bucketAccountId);

        /**
         * <p>
         * The name of the specified access point.
         * </p>
         * 
         * @param name
         *        The name of the specified access point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Indicates whether this access point allows access from the public internet.
         * </p>
         * 
         * @param networkOrigin
         *        Indicates whether this access point allows access from the public internet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkOrigin(String networkOrigin);

        /**
         * Sets the value of the PublicAccessBlockConfiguration property for this object.
         *
         * @param publicAccessBlockConfiguration
         *        The new value for the PublicAccessBlockConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicAccessBlockConfiguration(AwsS3AccountPublicAccessBlockDetails publicAccessBlockConfiguration);

        /**
         * Sets the value of the PublicAccessBlockConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link AwsS3AccountPublicAccessBlockDetails.Builder} avoiding the need to create one manually via
         * {@link AwsS3AccountPublicAccessBlockDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsS3AccountPublicAccessBlockDetails.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #publicAccessBlockConfiguration(AwsS3AccountPublicAccessBlockDetails)}.
         * 
         * @param publicAccessBlockConfiguration
         *        a consumer that will call methods on {@link AwsS3AccountPublicAccessBlockDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #publicAccessBlockConfiguration(AwsS3AccountPublicAccessBlockDetails)
         */
        default Builder publicAccessBlockConfiguration(
                Consumer<AwsS3AccountPublicAccessBlockDetails.Builder> publicAccessBlockConfiguration) {
            return publicAccessBlockConfiguration(AwsS3AccountPublicAccessBlockDetails.builder()
                    .applyMutation(publicAccessBlockConfiguration).build());
        }

        /**
         * <p>
         * Contains the virtual private cloud (VPC) configuration for the specified access point.
         * </p>
         * 
         * @param vpcConfiguration
         *        Contains the virtual private cloud (VPC) configuration for the specified access point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfiguration(AwsS3AccessPointVpcConfigurationDetails vpcConfiguration);

        /**
         * <p>
         * Contains the virtual private cloud (VPC) configuration for the specified access point.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsS3AccessPointVpcConfigurationDetails.Builder} avoiding the need to create one manually via
         * {@link AwsS3AccessPointVpcConfigurationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsS3AccessPointVpcConfigurationDetails.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #vpcConfiguration(AwsS3AccessPointVpcConfigurationDetails)}.
         * 
         * @param vpcConfiguration
         *        a consumer that will call methods on {@link AwsS3AccessPointVpcConfigurationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfiguration(AwsS3AccessPointVpcConfigurationDetails)
         */
        default Builder vpcConfiguration(Consumer<AwsS3AccessPointVpcConfigurationDetails.Builder> vpcConfiguration) {
            return vpcConfiguration(AwsS3AccessPointVpcConfigurationDetails.builder().applyMutation(vpcConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String accessPointArn;

        private String alias;

        private String bucket;

        private String bucketAccountId;

        private String name;

        private String networkOrigin;

        private AwsS3AccountPublicAccessBlockDetails publicAccessBlockConfiguration;

        private AwsS3AccessPointVpcConfigurationDetails vpcConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsS3AccessPointDetails model) {
            accessPointArn(model.accessPointArn);
            alias(model.alias);
            bucket(model.bucket);
            bucketAccountId(model.bucketAccountId);
            name(model.name);
            networkOrigin(model.networkOrigin);
            publicAccessBlockConfiguration(model.publicAccessBlockConfiguration);
            vpcConfiguration(model.vpcConfiguration);
        }

        public final String getAccessPointArn() {
            return accessPointArn;
        }

        public final void setAccessPointArn(String accessPointArn) {
            this.accessPointArn = accessPointArn;
        }

        @Override
        public final Builder accessPointArn(String accessPointArn) {
            this.accessPointArn = accessPointArn;
            return this;
        }

        public final String getAlias() {
            return alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final String getBucket() {
            return bucket;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final String getBucketAccountId() {
            return bucketAccountId;
        }

        public final void setBucketAccountId(String bucketAccountId) {
            this.bucketAccountId = bucketAccountId;
        }

        @Override
        public final Builder bucketAccountId(String bucketAccountId) {
            this.bucketAccountId = bucketAccountId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getNetworkOrigin() {
            return networkOrigin;
        }

        public final void setNetworkOrigin(String networkOrigin) {
            this.networkOrigin = networkOrigin;
        }

        @Override
        public final Builder networkOrigin(String networkOrigin) {
            this.networkOrigin = networkOrigin;
            return this;
        }

        public final AwsS3AccountPublicAccessBlockDetails.Builder getPublicAccessBlockConfiguration() {
            return publicAccessBlockConfiguration != null ? publicAccessBlockConfiguration.toBuilder() : null;
        }

        public final void setPublicAccessBlockConfiguration(
                AwsS3AccountPublicAccessBlockDetails.BuilderImpl publicAccessBlockConfiguration) {
            this.publicAccessBlockConfiguration = publicAccessBlockConfiguration != null ? publicAccessBlockConfiguration.build()
                    : null;
        }

        @Override
        public final Builder publicAccessBlockConfiguration(AwsS3AccountPublicAccessBlockDetails publicAccessBlockConfiguration) {
            this.publicAccessBlockConfiguration = publicAccessBlockConfiguration;
            return this;
        }

        public final AwsS3AccessPointVpcConfigurationDetails.Builder getVpcConfiguration() {
            return vpcConfiguration != null ? vpcConfiguration.toBuilder() : null;
        }

        public final void setVpcConfiguration(AwsS3AccessPointVpcConfigurationDetails.BuilderImpl vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration != null ? vpcConfiguration.build() : null;
        }

        @Override
        public final Builder vpcConfiguration(AwsS3AccessPointVpcConfigurationDetails vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        @Override
        public AwsS3AccessPointDetails build() {
            return new AwsS3AccessPointDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
