/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details about a specified Amazon Route 53 hosted zone, including the four name servers assigned to the
 * hosted zone. A hosted zone represents a collection of records that can be managed together, belonging to a single
 * parent domain name.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsRoute53HostedZoneDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsRoute53HostedZoneDetails.Builder, AwsRoute53HostedZoneDetails> {
    private static final SdkField<AwsRoute53HostedZoneObjectDetails> HOSTED_ZONE_FIELD = SdkField
            .<AwsRoute53HostedZoneObjectDetails> builder(MarshallingType.SDK_POJO).memberName("HostedZone")
            .getter(getter(AwsRoute53HostedZoneDetails::hostedZone)).setter(setter(Builder::hostedZone))
            .constructor(AwsRoute53HostedZoneObjectDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostedZone").build()).build();

    private static final SdkField<List<AwsRoute53HostedZoneVpcDetails>> VPCS_FIELD = SdkField
            .<List<AwsRoute53HostedZoneVpcDetails>> builder(MarshallingType.LIST)
            .memberName("Vpcs")
            .getter(getter(AwsRoute53HostedZoneDetails::vpcs))
            .setter(setter(Builder::vpcs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Vpcs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsRoute53HostedZoneVpcDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsRoute53HostedZoneVpcDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> NAME_SERVERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("NameServers")
            .getter(getter(AwsRoute53HostedZoneDetails::nameServers))
            .setter(setter(Builder::nameServers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NameServers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AwsRoute53QueryLoggingConfigDetails> QUERY_LOGGING_CONFIG_FIELD = SdkField
            .<AwsRoute53QueryLoggingConfigDetails> builder(MarshallingType.SDK_POJO).memberName("QueryLoggingConfig")
            .getter(getter(AwsRoute53HostedZoneDetails::queryLoggingConfig)).setter(setter(Builder::queryLoggingConfig))
            .constructor(AwsRoute53QueryLoggingConfigDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryLoggingConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOSTED_ZONE_FIELD, VPCS_FIELD,
            NAME_SERVERS_FIELD, QUERY_LOGGING_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AwsRoute53HostedZoneObjectDetails hostedZone;

    private final List<AwsRoute53HostedZoneVpcDetails> vpcs;

    private final List<String> nameServers;

    private final AwsRoute53QueryLoggingConfigDetails queryLoggingConfig;

    private AwsRoute53HostedZoneDetails(BuilderImpl builder) {
        this.hostedZone = builder.hostedZone;
        this.vpcs = builder.vpcs;
        this.nameServers = builder.nameServers;
        this.queryLoggingConfig = builder.queryLoggingConfig;
    }

    /**
     * <p>
     * An object that contains information about the specified hosted zone.
     * </p>
     * 
     * @return An object that contains information about the specified hosted zone.
     */
    public final AwsRoute53HostedZoneObjectDetails hostedZone() {
        return hostedZone;
    }

    /**
     * For responses, this returns true if the service returned a value for the Vpcs property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasVpcs() {
        return vpcs != null && !(vpcs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An object that contains information about the Amazon Virtual Private Clouds (Amazon VPCs) that are associated
     * with the specified hosted zone.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcs} method.
     * </p>
     * 
     * @return An object that contains information about the Amazon Virtual Private Clouds (Amazon VPCs) that are
     *         associated with the specified hosted zone.
     */
    public final List<AwsRoute53HostedZoneVpcDetails> vpcs() {
        return vpcs;
    }

    /**
     * For responses, this returns true if the service returned a value for the NameServers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNameServers() {
        return nameServers != null && !(nameServers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An object that contains a list of the authoritative name servers for a hosted zone or for a reusable delegation
     * set.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNameServers} method.
     * </p>
     * 
     * @return An object that contains a list of the authoritative name servers for a hosted zone or for a reusable
     *         delegation set.
     */
    public final List<String> nameServers() {
        return nameServers;
    }

    /**
     * <p>
     * An array that contains one <code>QueryLoggingConfig</code> element for each DNS query logging configuration that
     * is associated with the current Amazon Web Services account.
     * </p>
     * 
     * @return An array that contains one <code>QueryLoggingConfig</code> element for each DNS query logging
     *         configuration that is associated with the current Amazon Web Services account.
     */
    public final AwsRoute53QueryLoggingConfigDetails queryLoggingConfig() {
        return queryLoggingConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hostedZone());
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcs() ? vpcs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNameServers() ? nameServers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(queryLoggingConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsRoute53HostedZoneDetails)) {
            return false;
        }
        AwsRoute53HostedZoneDetails other = (AwsRoute53HostedZoneDetails) obj;
        return Objects.equals(hostedZone(), other.hostedZone()) && hasVpcs() == other.hasVpcs()
                && Objects.equals(vpcs(), other.vpcs()) && hasNameServers() == other.hasNameServers()
                && Objects.equals(nameServers(), other.nameServers())
                && Objects.equals(queryLoggingConfig(), other.queryLoggingConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsRoute53HostedZoneDetails").add("HostedZone", hostedZone())
                .add("Vpcs", hasVpcs() ? vpcs() : null).add("NameServers", hasNameServers() ? nameServers() : null)
                .add("QueryLoggingConfig", queryLoggingConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HostedZone":
            return Optional.ofNullable(clazz.cast(hostedZone()));
        case "Vpcs":
            return Optional.ofNullable(clazz.cast(vpcs()));
        case "NameServers":
            return Optional.ofNullable(clazz.cast(nameServers()));
        case "QueryLoggingConfig":
            return Optional.ofNullable(clazz.cast(queryLoggingConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("HostedZone", HOSTED_ZONE_FIELD);
        map.put("Vpcs", VPCS_FIELD);
        map.put("NameServers", NAME_SERVERS_FIELD);
        map.put("QueryLoggingConfig", QUERY_LOGGING_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsRoute53HostedZoneDetails, T> g) {
        return obj -> g.apply((AwsRoute53HostedZoneDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsRoute53HostedZoneDetails> {
        /**
         * <p>
         * An object that contains information about the specified hosted zone.
         * </p>
         * 
         * @param hostedZone
         *        An object that contains information about the specified hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZone(AwsRoute53HostedZoneObjectDetails hostedZone);

        /**
         * <p>
         * An object that contains information about the specified hosted zone.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsRoute53HostedZoneObjectDetails.Builder} avoiding the need to create one manually via
         * {@link AwsRoute53HostedZoneObjectDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsRoute53HostedZoneObjectDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #hostedZone(AwsRoute53HostedZoneObjectDetails)}.
         * 
         * @param hostedZone
         *        a consumer that will call methods on {@link AwsRoute53HostedZoneObjectDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hostedZone(AwsRoute53HostedZoneObjectDetails)
         */
        default Builder hostedZone(Consumer<AwsRoute53HostedZoneObjectDetails.Builder> hostedZone) {
            return hostedZone(AwsRoute53HostedZoneObjectDetails.builder().applyMutation(hostedZone).build());
        }

        /**
         * <p>
         * An object that contains information about the Amazon Virtual Private Clouds (Amazon VPCs) that are associated
         * with the specified hosted zone.
         * </p>
         * 
         * @param vpcs
         *        An object that contains information about the Amazon Virtual Private Clouds (Amazon VPCs) that are
         *        associated with the specified hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcs(Collection<AwsRoute53HostedZoneVpcDetails> vpcs);

        /**
         * <p>
         * An object that contains information about the Amazon Virtual Private Clouds (Amazon VPCs) that are associated
         * with the specified hosted zone.
         * </p>
         * 
         * @param vpcs
         *        An object that contains information about the Amazon Virtual Private Clouds (Amazon VPCs) that are
         *        associated with the specified hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcs(AwsRoute53HostedZoneVpcDetails... vpcs);

        /**
         * <p>
         * An object that contains information about the Amazon Virtual Private Clouds (Amazon VPCs) that are associated
         * with the specified hosted zone.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRoute53HostedZoneVpcDetails.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRoute53HostedZoneVpcDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRoute53HostedZoneVpcDetails.Builder#build()} is
         * called immediately and its result is passed to {@link #vpcs(List<AwsRoute53HostedZoneVpcDetails>)}.
         * 
         * @param vpcs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsRoute53HostedZoneVpcDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcs(java.util.Collection<AwsRoute53HostedZoneVpcDetails>)
         */
        Builder vpcs(Consumer<AwsRoute53HostedZoneVpcDetails.Builder>... vpcs);

        /**
         * <p>
         * An object that contains a list of the authoritative name servers for a hosted zone or for a reusable
         * delegation set.
         * </p>
         * 
         * @param nameServers
         *        An object that contains a list of the authoritative name servers for a hosted zone or for a reusable
         *        delegation set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameServers(Collection<String> nameServers);

        /**
         * <p>
         * An object that contains a list of the authoritative name servers for a hosted zone or for a reusable
         * delegation set.
         * </p>
         * 
         * @param nameServers
         *        An object that contains a list of the authoritative name servers for a hosted zone or for a reusable
         *        delegation set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameServers(String... nameServers);

        /**
         * <p>
         * An array that contains one <code>QueryLoggingConfig</code> element for each DNS query logging configuration
         * that is associated with the current Amazon Web Services account.
         * </p>
         * 
         * @param queryLoggingConfig
         *        An array that contains one <code>QueryLoggingConfig</code> element for each DNS query logging
         *        configuration that is associated with the current Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryLoggingConfig(AwsRoute53QueryLoggingConfigDetails queryLoggingConfig);

        /**
         * <p>
         * An array that contains one <code>QueryLoggingConfig</code> element for each DNS query logging configuration
         * that is associated with the current Amazon Web Services account.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsRoute53QueryLoggingConfigDetails.Builder} avoiding the need to create one manually via
         * {@link AwsRoute53QueryLoggingConfigDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsRoute53QueryLoggingConfigDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #queryLoggingConfig(AwsRoute53QueryLoggingConfigDetails)}.
         * 
         * @param queryLoggingConfig
         *        a consumer that will call methods on {@link AwsRoute53QueryLoggingConfigDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queryLoggingConfig(AwsRoute53QueryLoggingConfigDetails)
         */
        default Builder queryLoggingConfig(Consumer<AwsRoute53QueryLoggingConfigDetails.Builder> queryLoggingConfig) {
            return queryLoggingConfig(AwsRoute53QueryLoggingConfigDetails.builder().applyMutation(queryLoggingConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AwsRoute53HostedZoneObjectDetails hostedZone;

        private List<AwsRoute53HostedZoneVpcDetails> vpcs = DefaultSdkAutoConstructList.getInstance();

        private List<String> nameServers = DefaultSdkAutoConstructList.getInstance();

        private AwsRoute53QueryLoggingConfigDetails queryLoggingConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsRoute53HostedZoneDetails model) {
            hostedZone(model.hostedZone);
            vpcs(model.vpcs);
            nameServers(model.nameServers);
            queryLoggingConfig(model.queryLoggingConfig);
        }

        public final AwsRoute53HostedZoneObjectDetails.Builder getHostedZone() {
            return hostedZone != null ? hostedZone.toBuilder() : null;
        }

        public final void setHostedZone(AwsRoute53HostedZoneObjectDetails.BuilderImpl hostedZone) {
            this.hostedZone = hostedZone != null ? hostedZone.build() : null;
        }

        @Override
        public final Builder hostedZone(AwsRoute53HostedZoneObjectDetails hostedZone) {
            this.hostedZone = hostedZone;
            return this;
        }

        public final List<AwsRoute53HostedZoneVpcDetails.Builder> getVpcs() {
            List<AwsRoute53HostedZoneVpcDetails.Builder> result = AwsRoute53HostedZoneVpcsListCopier.copyToBuilder(this.vpcs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpcs(Collection<AwsRoute53HostedZoneVpcDetails.BuilderImpl> vpcs) {
            this.vpcs = AwsRoute53HostedZoneVpcsListCopier.copyFromBuilder(vpcs);
        }

        @Override
        public final Builder vpcs(Collection<AwsRoute53HostedZoneVpcDetails> vpcs) {
            this.vpcs = AwsRoute53HostedZoneVpcsListCopier.copy(vpcs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcs(AwsRoute53HostedZoneVpcDetails... vpcs) {
            vpcs(Arrays.asList(vpcs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcs(Consumer<AwsRoute53HostedZoneVpcDetails.Builder>... vpcs) {
            vpcs(Stream.of(vpcs).map(c -> AwsRoute53HostedZoneVpcDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getNameServers() {
            if (nameServers instanceof SdkAutoConstructList) {
                return null;
            }
            return nameServers;
        }

        public final void setNameServers(Collection<String> nameServers) {
            this.nameServers = AwsRoute53HostedZoneNameServersListCopier.copy(nameServers);
        }

        @Override
        public final Builder nameServers(Collection<String> nameServers) {
            this.nameServers = AwsRoute53HostedZoneNameServersListCopier.copy(nameServers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nameServers(String... nameServers) {
            nameServers(Arrays.asList(nameServers));
            return this;
        }

        public final AwsRoute53QueryLoggingConfigDetails.Builder getQueryLoggingConfig() {
            return queryLoggingConfig != null ? queryLoggingConfig.toBuilder() : null;
        }

        public final void setQueryLoggingConfig(AwsRoute53QueryLoggingConfigDetails.BuilderImpl queryLoggingConfig) {
            this.queryLoggingConfig = queryLoggingConfig != null ? queryLoggingConfig.build() : null;
        }

        @Override
        public final Builder queryLoggingConfig(AwsRoute53QueryLoggingConfigDetails queryLoggingConfig) {
            this.queryLoggingConfig = queryLoggingConfig;
            return this;
        }

        @Override
        public AwsRoute53HostedZoneDetails build() {
            return new AwsRoute53HostedZoneDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
