/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * You can configure Amazon Redshift to copy snapshots for a cluster to another Amazon Web Services Region. This
 * parameter provides information about a cross-Region snapshot copy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsRedshiftClusterClusterSnapshotCopyStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsRedshiftClusterClusterSnapshotCopyStatus.Builder, AwsRedshiftClusterClusterSnapshotCopyStatus> {
    private static final SdkField<String> DESTINATION_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationRegion").getter(getter(AwsRedshiftClusterClusterSnapshotCopyStatus::destinationRegion))
            .setter(setter(Builder::destinationRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationRegion").build()).build();

    private static final SdkField<Integer> MANUAL_SNAPSHOT_RETENTION_PERIOD_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("ManualSnapshotRetentionPeriod")
            .getter(getter(AwsRedshiftClusterClusterSnapshotCopyStatus::manualSnapshotRetentionPeriod))
            .setter(setter(Builder::manualSnapshotRetentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManualSnapshotRetentionPeriod")
                    .build()).build();

    private static final SdkField<Integer> RETENTION_PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RetentionPeriod").getter(getter(AwsRedshiftClusterClusterSnapshotCopyStatus::retentionPeriod))
            .setter(setter(Builder::retentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionPeriod").build()).build();

    private static final SdkField<String> SNAPSHOT_COPY_GRANT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotCopyGrantName")
            .getter(getter(AwsRedshiftClusterClusterSnapshotCopyStatus::snapshotCopyGrantName))
            .setter(setter(Builder::snapshotCopyGrantName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotCopyGrantName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_REGION_FIELD,
            MANUAL_SNAPSHOT_RETENTION_PERIOD_FIELD, RETENTION_PERIOD_FIELD, SNAPSHOT_COPY_GRANT_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String destinationRegion;

    private final Integer manualSnapshotRetentionPeriod;

    private final Integer retentionPeriod;

    private final String snapshotCopyGrantName;

    private AwsRedshiftClusterClusterSnapshotCopyStatus(BuilderImpl builder) {
        this.destinationRegion = builder.destinationRegion;
        this.manualSnapshotRetentionPeriod = builder.manualSnapshotRetentionPeriod;
        this.retentionPeriod = builder.retentionPeriod;
        this.snapshotCopyGrantName = builder.snapshotCopyGrantName;
    }

    /**
     * <p>
     * The destination Region that snapshots are automatically copied to when cross-Region snapshot copy is enabled.
     * </p>
     * 
     * @return The destination Region that snapshots are automatically copied to when cross-Region snapshot copy is
     *         enabled.
     */
    public final String destinationRegion() {
        return destinationRegion;
    }

    /**
     * <p>
     * The number of days that manual snapshots are retained in the destination Region after they are copied from a
     * source Region.
     * </p>
     * <p>
     * If the value is <code>-1</code>, then the manual snapshot is retained indefinitely.
     * </p>
     * <p>
     * Valid values: Either <code>-1</code> or an integer between 1 and 3,653
     * </p>
     * 
     * @return The number of days that manual snapshots are retained in the destination Region after they are copied
     *         from a source Region.</p>
     *         <p>
     *         If the value is <code>-1</code>, then the manual snapshot is retained indefinitely.
     *         </p>
     *         <p>
     *         Valid values: Either <code>-1</code> or an integer between 1 and 3,653
     */
    public final Integer manualSnapshotRetentionPeriod() {
        return manualSnapshotRetentionPeriod;
    }

    /**
     * <p>
     * The number of days to retain automated snapshots in the destination Region after they are copied from a source
     * Region.
     * </p>
     * 
     * @return The number of days to retain automated snapshots in the destination Region after they are copied from a
     *         source Region.
     */
    public final Integer retentionPeriod() {
        return retentionPeriod;
    }

    /**
     * <p>
     * The name of the snapshot copy grant.
     * </p>
     * 
     * @return The name of the snapshot copy grant.
     */
    public final String snapshotCopyGrantName() {
        return snapshotCopyGrantName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destinationRegion());
        hashCode = 31 * hashCode + Objects.hashCode(manualSnapshotRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(retentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotCopyGrantName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsRedshiftClusterClusterSnapshotCopyStatus)) {
            return false;
        }
        AwsRedshiftClusterClusterSnapshotCopyStatus other = (AwsRedshiftClusterClusterSnapshotCopyStatus) obj;
        return Objects.equals(destinationRegion(), other.destinationRegion())
                && Objects.equals(manualSnapshotRetentionPeriod(), other.manualSnapshotRetentionPeriod())
                && Objects.equals(retentionPeriod(), other.retentionPeriod())
                && Objects.equals(snapshotCopyGrantName(), other.snapshotCopyGrantName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsRedshiftClusterClusterSnapshotCopyStatus").add("DestinationRegion", destinationRegion())
                .add("ManualSnapshotRetentionPeriod", manualSnapshotRetentionPeriod()).add("RetentionPeriod", retentionPeriod())
                .add("SnapshotCopyGrantName", snapshotCopyGrantName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DestinationRegion":
            return Optional.ofNullable(clazz.cast(destinationRegion()));
        case "ManualSnapshotRetentionPeriod":
            return Optional.ofNullable(clazz.cast(manualSnapshotRetentionPeriod()));
        case "RetentionPeriod":
            return Optional.ofNullable(clazz.cast(retentionPeriod()));
        case "SnapshotCopyGrantName":
            return Optional.ofNullable(clazz.cast(snapshotCopyGrantName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DestinationRegion", DESTINATION_REGION_FIELD);
        map.put("ManualSnapshotRetentionPeriod", MANUAL_SNAPSHOT_RETENTION_PERIOD_FIELD);
        map.put("RetentionPeriod", RETENTION_PERIOD_FIELD);
        map.put("SnapshotCopyGrantName", SNAPSHOT_COPY_GRANT_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsRedshiftClusterClusterSnapshotCopyStatus, T> g) {
        return obj -> g.apply((AwsRedshiftClusterClusterSnapshotCopyStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsRedshiftClusterClusterSnapshotCopyStatus> {
        /**
         * <p>
         * The destination Region that snapshots are automatically copied to when cross-Region snapshot copy is enabled.
         * </p>
         * 
         * @param destinationRegion
         *        The destination Region that snapshots are automatically copied to when cross-Region snapshot copy is
         *        enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationRegion(String destinationRegion);

        /**
         * <p>
         * The number of days that manual snapshots are retained in the destination Region after they are copied from a
         * source Region.
         * </p>
         * <p>
         * If the value is <code>-1</code>, then the manual snapshot is retained indefinitely.
         * </p>
         * <p>
         * Valid values: Either <code>-1</code> or an integer between 1 and 3,653
         * </p>
         * 
         * @param manualSnapshotRetentionPeriod
         *        The number of days that manual snapshots are retained in the destination Region after they are copied
         *        from a source Region.</p>
         *        <p>
         *        If the value is <code>-1</code>, then the manual snapshot is retained indefinitely.
         *        </p>
         *        <p>
         *        Valid values: Either <code>-1</code> or an integer between 1 and 3,653
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manualSnapshotRetentionPeriod(Integer manualSnapshotRetentionPeriod);

        /**
         * <p>
         * The number of days to retain automated snapshots in the destination Region after they are copied from a
         * source Region.
         * </p>
         * 
         * @param retentionPeriod
         *        The number of days to retain automated snapshots in the destination Region after they are copied from
         *        a source Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionPeriod(Integer retentionPeriod);

        /**
         * <p>
         * The name of the snapshot copy grant.
         * </p>
         * 
         * @param snapshotCopyGrantName
         *        The name of the snapshot copy grant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotCopyGrantName(String snapshotCopyGrantName);
    }

    static final class BuilderImpl implements Builder {
        private String destinationRegion;

        private Integer manualSnapshotRetentionPeriod;

        private Integer retentionPeriod;

        private String snapshotCopyGrantName;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsRedshiftClusterClusterSnapshotCopyStatus model) {
            destinationRegion(model.destinationRegion);
            manualSnapshotRetentionPeriod(model.manualSnapshotRetentionPeriod);
            retentionPeriod(model.retentionPeriod);
            snapshotCopyGrantName(model.snapshotCopyGrantName);
        }

        public final String getDestinationRegion() {
            return destinationRegion;
        }

        public final void setDestinationRegion(String destinationRegion) {
            this.destinationRegion = destinationRegion;
        }

        @Override
        public final Builder destinationRegion(String destinationRegion) {
            this.destinationRegion = destinationRegion;
            return this;
        }

        public final Integer getManualSnapshotRetentionPeriod() {
            return manualSnapshotRetentionPeriod;
        }

        public final void setManualSnapshotRetentionPeriod(Integer manualSnapshotRetentionPeriod) {
            this.manualSnapshotRetentionPeriod = manualSnapshotRetentionPeriod;
        }

        @Override
        public final Builder manualSnapshotRetentionPeriod(Integer manualSnapshotRetentionPeriod) {
            this.manualSnapshotRetentionPeriod = manualSnapshotRetentionPeriod;
            return this;
        }

        public final Integer getRetentionPeriod() {
            return retentionPeriod;
        }

        public final void setRetentionPeriod(Integer retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
        }

        @Override
        public final Builder retentionPeriod(Integer retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        public final String getSnapshotCopyGrantName() {
            return snapshotCopyGrantName;
        }

        public final void setSnapshotCopyGrantName(String snapshotCopyGrantName) {
            this.snapshotCopyGrantName = snapshotCopyGrantName;
        }

        @Override
        public final Builder snapshotCopyGrantName(String snapshotCopyGrantName) {
            this.snapshotCopyGrantName = snapshotCopyGrantName;
            return this;
        }

        @Override
        public AwsRedshiftClusterClusterSnapshotCopyStatus build() {
            return new AwsRedshiftClusterClusterSnapshotCopyStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
